import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_CreateResourceDataSyncCommand, se_CreateResourceDataSyncCommand } from "../protocols/Aws_json1_1";
export { $Command };
export class CreateResourceDataSyncCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonSSM", "CreateResourceDataSync", {})
    .n("SSMClient", "CreateResourceDataSyncCommand")
    .f(void 0, void 0)
    .ser(se_CreateResourceDataSyncCommand)
    .de(de_CreateResourceDataSyncCommand)
    .build() {
}
