import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_DescribeMaintenanceWindowScheduleCommand, se_DescribeMaintenanceWindowScheduleCommand, } from "../protocols/Aws_json1_1";
export { $Command };
export class DescribeMaintenanceWindowScheduleCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonSSM", "DescribeMaintenanceWindowSchedule", {})
    .n("SSMClient", "DescribeMaintenanceWindowScheduleCommand")
    .f(void 0, void 0)
    .ser(se_DescribeMaintenanceWindowScheduleCommand)
    .de(de_DescribeMaintenanceWindowScheduleCommand)
    .build() {
}
