import os
from .utils import Get_ENV, Load_ENV

class BotSetup:
    def __init__(self, bot):
        self.bot = bot
        self.token = Get_ENV(key="TOKEN")
        self.cogs_directory = "./cogs"

    def run_bot(self):
        try:
            if not self.token or self.token == "NO_TOKEN_ADDED":
                print("NO_TOKEN_ADDED. Please add a valid token in environment secrets")
                return
            self.bot.run(self.token)
        except Exception as e:
            print("ERROR: bot.py | bot.run() failed to run the bot. Possible wrong token or invalid token?!")
            raise Exception(e)

    def add_cogs(self):
        try:
            if not os.path.exists(self.cogs_directory):
                print(f"ERROR: bot.py | Cog directory '{self.cogs_directory}' does not exist.")
                return

            for filename in os.listdir(self.cogs_directory):
                if filename.endswith(".py"):
                    try:
                        self.bot.load_extension(f"cogs.{filename[:-3]}")
                        print(">", filename)
                    except Exception as e:
                        print(f"ERROR: bot.py | Failed to load cog '{filename}'. Error: {e}")
                        raise Exception(e)
        except Exception as e:
            print(f"ERROR: bot.py | Cog Support failed to load. Possible /cogs does not exist?! or Duplicate?! Error: \n{e}")
            raise Exception(e)

    def setup_bot(self):
        try:
            Load_ENV()
            print("=====BOT=====")
            print("Loading Cogs:")
            self.add_cogs()
            print("==================================================")
            self.run_bot()
        except Exception as e:
            print(f"ERROR: bot.py | Bot Setup failed to run. Error: \n{e}")
            raise Exception(e)