"""
Concrete cover functions

    .. uml::

        class concrete_cover <<(M,#FF7700)>> {
        .. functions ..
        + cmindur(cat, env)
        }

"""

import pandas as pd
import numpy as np


def cmindur(cat, env):
    """
    Minimum cover cmin,dur with regard to durability for reinforcement steel

    +----------------+----+-----+---------+-----+---------+---------+---------+
    | Struct. Class  | X0 | XC1 | XC2/XC3 | XC4 | XD1/XS1 | XD2/XS2 | XD3/XS3 |
    +================+====+=====+=========+=====+=========+=========+=========+
    | S1             | 10 |  10 |    10   | 15  |   20    |   25    |   30    |
    +----------------+----+-----+---------+-----+---------+---------+---------+
    | S2             | 10 |  10 |    15   | 20  |   25    |   30    |   35    |
    +----------------+----+-----+---------+-----+---------+---------+---------+
    | S3             | 10 |  10 |    20   | 25  |   30    |   35    |   40    |
    +----------------+----+-----+---------+-----+---------+---------+---------+
    | S4             | 10 |  15 |    25   | 30  |   35    |   40    |   45    |
    +----------------+----+-----+---------+-----+---------+---------+---------+
    | S5             | 15 |  20 |    30   | 35  |   40    |   45    |   50    |
    +----------------+----+-----+---------+-----+---------+---------+---------+
    | S6             | 20 |  25 |    35   | 40  |   45    |   50    |   55    |
    +----------------+----+-----+---------+-----+---------+---------+---------+

    Args:
        cat (str): Structural Class
        env (str): Exposure Class

    Returns:
        int: Taken from the table above

    """
    if env == 'XC3': env = 'XC2'
    if env == 'XS1': env = 'XD1'
    if env == 'XS2': env = 'XD2'
    if env == 'XS3': env = 'XD3'

    df_cmindur = pd.DataFrame(np.array([[10, 10, 10, 15, 20, 25, 30],
                                        [10, 10, 15, 20, 25, 30, 35],
                                        [10, 10, 20, 25, 30, 35, 40],
                                        [10, 15, 25, 30, 35, 40, 45],
                                        [15, 20, 30, 35, 40, 45, 50],
                                        [20, 25, 35, 40, 45, 50, 55]]),
                              columns=['X0', 'XC1', 'XC2', 'XC4', 'XD1', 'XD2', 'XD3'],
                              index=['S1', 'S2', 'S3', 'S4', 'S5', 'S6'])

    return df_cmindur.loc[cat, env]