# -*- coding: utf-8 -*-
"""
Created on Thu Oct  1 14:30:43 2015

@author: chiaracasotto
"""
import csv
from rmtk.vulnerability.common.utils import isNumber

def read_parameters(input_file):

    hysteresis = {}
    if input_file == 'Default':
        hysteresis['type'] = 'Default'
    else:
        rDisp,fForce,uForce = [],[],[]
        gK, gD, gF, gE = [],[],[],[]
        dmgType = []
        with open(input_file, 'rU') as f:
            data = csv.reader(f)
            for line in data:
                if line[0] == 'rDisp':
                    for values in line[1:]:
                        if isNumber(values): 
                            rDisp.append(float(values))
                if line[0] == 'fForce':
                    for values in line[1:]:
                        if isNumber(values): 
                            fForce.append(float(values))
                if line[0] == 'uForce':
                    for values in line[1:]:
                        if isNumber(values): 
                            uForce.append(float(values))
                if line[0][0:2] == 'gK':
                    temp = []
                    for values in line[1:]:
                        if isNumber(values):
                            temp.append(float(values))
                    gK.append(temp)
                if line[0][0:2] == 'gD':
                    temp = []
                    for values in line[1:]:
                        if isNumber(values):
                            temp.append(float(values))
                    gD.append(temp)
                if line[0][0:2] == 'gF':
                    temp = []
                    for values in line[1:]:
                        if isNumber(values):
                            temp.append(float(values))
                    gF.append(temp)
                if line[0] == 'gE':
                    for values in line[1:]:
                        if isNumber(values):
                            gE.append(float(values))
                if line[0] == 'dmgType':
                    for values in line[1:]:
                        if len(values) != 0:
                            dmgType.append(values)
        
        # Store all the data in the dictionary
        hysteresis = {'type': "user-defined", 'rDisp': None, 'fForce': None, 'uForce': None,
                    'gK': None, 'gD': None, 'gF': None, 'gE': None, 'dmgType': None}
        
        hysteresis['rDisp'] = rDisp
        hysteresis['fForce'] = fForce
        hysteresis['uForce'] = uForce
        hysteresis['gK'] = gK
        hysteresis['gD'] = gD
        hysteresis['gF'] = gF
        hysteresis['gE'] = gE
        hysteresis['dmgType'] = dmgType

    return hysteresis
            