"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FileAssetPackaging = exports.AssetHashType = void 0;
/**
 * The type of asset hash
 */
var AssetHashType;
(function (AssetHashType) {
    /**
     * Based on the content of the source path
     */
    AssetHashType["SOURCE"] = "source";
    /**
     * Based on the content of the bundled path
     */
    AssetHashType["BUNDLE"] = "bundle";
    /**
     * Use a custom hash
     */
    AssetHashType["CUSTOM"] = "custom";
})(AssetHashType = exports.AssetHashType || (exports.AssetHashType = {}));
/**
 * Packaging modes for file assets.
 */
var FileAssetPackaging;
(function (FileAssetPackaging) {
    /**
     * The asset source path points to a directory, which should be archived using
     * zip and and then uploaded to Amazon S3.
     */
    FileAssetPackaging["ZIP_DIRECTORY"] = "zip";
    /**
     * The asset source path points to a single file, which should be uploaded
     * to Amazon S3.
     */
    FileAssetPackaging["FILE"] = "file";
})(FileAssetPackaging = exports.FileAssetPackaging || (exports.FileAssetPackaging = {}));
//# sourceMappingURL=data:application/json;base64,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