# coding: utf-8

"""
    DataForSEO API documentation

    DataForSEO API is the starting point on your journey towards building powerful SEO software. With DataForSEO you can get all the data you need to build an efficient application while also saving your time and budget. DataForSEO API is using the REST technology for interchanging data between your application and our service. The data exchange is made through the widely used HTTP protocol, which allows applying our API to almost all programming languages.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class AboutThisResultElement(BaseModel):
    """
    AboutThisResultElement
    """ # noqa: E501
    type: Optional[StrictStr] = Field(default=None, description="type of element")
    url: Optional[StrictStr] = Field(default=None, description="result’s URL")
    source: Optional[StrictStr] = Field(default=None, description="source of additional information about the result")
    source_info: Optional[StrictStr] = Field(default=None, description="additional information about the result description of the website from Wikipedia or another additional context")
    source_url: Optional[StrictStr] = Field(default=None, description="URL to full information from the 'source'")
    language: Optional[StrictStr] = Field(default=None, description="the language of the result")
    location: Optional[StrictStr] = Field(default=None, description="location for which the result is relevant")
    search_terms: Optional[List[Optional[StrictStr]]] = Field(default=None, description="matching search terms that appear in the result")
    related_terms: Optional[List[Optional[StrictStr]]] = Field(default=None, description="related search terms that appear in the result")
    __properties: ClassVar[List[str]] = ["type", "url", "source", "source_info", "source_url", "language", "location", "search_terms", "related_terms"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AboutThisResultElement from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if type (nullable) is None
        # and model_fields_set contains the field
        if self.type is None and "type" in self.model_fields_set:
            _dict['type'] = None

        # set to None if url (nullable) is None
        # and model_fields_set contains the field
        if self.url is None and "url" in self.model_fields_set:
            _dict['url'] = None

        # set to None if source (nullable) is None
        # and model_fields_set contains the field
        if self.source is None and "source" in self.model_fields_set:
            _dict['source'] = None

        # set to None if source_info (nullable) is None
        # and model_fields_set contains the field
        if self.source_info is None and "source_info" in self.model_fields_set:
            _dict['source_info'] = None

        # set to None if source_url (nullable) is None
        # and model_fields_set contains the field
        if self.source_url is None and "source_url" in self.model_fields_set:
            _dict['source_url'] = None

        # set to None if language (nullable) is None
        # and model_fields_set contains the field
        if self.language is None and "language" in self.model_fields_set:
            _dict['language'] = None

        # set to None if location (nullable) is None
        # and model_fields_set contains the field
        if self.location is None and "location" in self.model_fields_set:
            _dict['location'] = None

        # set to None if search_terms (nullable) is None
        # and model_fields_set contains the field
        if self.search_terms is None and "search_terms" in self.model_fields_set:
            _dict['search_terms'] = None

        # set to None if related_terms (nullable) is None
        # and model_fields_set contains the field
        if self.related_terms is None and "related_terms" in self.model_fields_set:
            _dict['related_terms'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AboutThisResultElement from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "type": obj.get("type"),
            "url": obj.get("url"),
            "source": obj.get("source"),
            "source_info": obj.get("source_info"),
            "source_url": obj.get("source_url"),
            "language": obj.get("language"),
            "location": obj.get("location"),
            "search_terms": obj.get("search_terms"),
            "related_terms": obj.get("related_terms")
        })
        return _obj


