# coding: utf-8

"""
    DataForSEO API documentation

    DataForSEO API is the starting point on your journey towards building powerful SEO software. With DataForSEO you can get all the data you need to build an efficient application while also saving your time and budget. DataForSEO API is using the REST technology for interchanging data between your application and our service. The data exchange is made through the widely used HTTP protocol, which allows applying our API to almost all programming languages.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel
from typing import Any, ClassVar, Dict, List, Optional
from dataforseo_client.models.appendix_business_listings_business_data_price_data import AppendixBusinessListingsBusinessDataPriceData
from dataforseo_client.models.appendix_google_business_data_price_data import AppendixGoogleBusinessDataPriceData
from dataforseo_client.models.appendix_social_media_business_data_price_data import AppendixSocialMediaBusinessDataPriceData
from dataforseo_client.models.appendix_task_keywords_data_price_data_info import AppendixTaskKeywordsDataPriceDataInfo
from dataforseo_client.models.appendix_tr_business_data_price_data_info import AppendixTrBusinessDataPriceDataInfo
from typing import Optional, Set
from typing_extensions import Self

class AppendixBusinessDataPriceData(BaseModel):
    """
    AppendixBusinessDataPriceData
    """ # noqa: E501
    business_listings: Optional[AppendixBusinessListingsBusinessDataPriceData] = None
    errors: Optional[AppendixTaskKeywordsDataPriceDataInfo] = None
    social_media: Optional[AppendixSocialMediaBusinessDataPriceData] = None
    google: Optional[AppendixGoogleBusinessDataPriceData] = None
    languages: Optional[AppendixTaskKeywordsDataPriceDataInfo] = None
    locations: Optional[AppendixTaskKeywordsDataPriceDataInfo] = None
    trustpilot: Optional[AppendixTrBusinessDataPriceDataInfo] = None
    tripadvisor: Optional[AppendixTrBusinessDataPriceDataInfo] = None
    yelp: Optional[AppendixTrBusinessDataPriceDataInfo] = None
    tasks_ready: Optional[AppendixTaskKeywordsDataPriceDataInfo] = None
    __properties: ClassVar[List[str]] = ["business_listings", "errors", "social_media", "google", "languages", "locations", "trustpilot", "tripadvisor", "yelp", "tasks_ready"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AppendixBusinessDataPriceData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of business_listings
        if self.business_listings:
            _dict['business_listings'] = self.business_listings.to_dict()
        # override the default output from pydantic by calling `to_dict()` of errors
        if self.errors:
            _dict['errors'] = self.errors.to_dict()
        # override the default output from pydantic by calling `to_dict()` of social_media
        if self.social_media:
            _dict['social_media'] = self.social_media.to_dict()
        # override the default output from pydantic by calling `to_dict()` of google
        if self.google:
            _dict['google'] = self.google.to_dict()
        # override the default output from pydantic by calling `to_dict()` of languages
        if self.languages:
            _dict['languages'] = self.languages.to_dict()
        # override the default output from pydantic by calling `to_dict()` of locations
        if self.locations:
            _dict['locations'] = self.locations.to_dict()
        # override the default output from pydantic by calling `to_dict()` of trustpilot
        if self.trustpilot:
            _dict['trustpilot'] = self.trustpilot.to_dict()
        # override the default output from pydantic by calling `to_dict()` of tripadvisor
        if self.tripadvisor:
            _dict['tripadvisor'] = self.tripadvisor.to_dict()
        # override the default output from pydantic by calling `to_dict()` of yelp
        if self.yelp:
            _dict['yelp'] = self.yelp.to_dict()
        # override the default output from pydantic by calling `to_dict()` of tasks_ready
        if self.tasks_ready:
            _dict['tasks_ready'] = self.tasks_ready.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AppendixBusinessDataPriceData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "business_listings": AppendixBusinessListingsBusinessDataPriceData.from_dict(obj["business_listings"]) if obj.get("business_listings") is not None else None,
            "errors": AppendixTaskKeywordsDataPriceDataInfo.from_dict(obj["errors"]) if obj.get("errors") is not None else None,
            "social_media": AppendixSocialMediaBusinessDataPriceData.from_dict(obj["social_media"]) if obj.get("social_media") is not None else None,
            "google": AppendixGoogleBusinessDataPriceData.from_dict(obj["google"]) if obj.get("google") is not None else None,
            "languages": AppendixTaskKeywordsDataPriceDataInfo.from_dict(obj["languages"]) if obj.get("languages") is not None else None,
            "locations": AppendixTaskKeywordsDataPriceDataInfo.from_dict(obj["locations"]) if obj.get("locations") is not None else None,
            "trustpilot": AppendixTrBusinessDataPriceDataInfo.from_dict(obj["trustpilot"]) if obj.get("trustpilot") is not None else None,
            "tripadvisor": AppendixTrBusinessDataPriceDataInfo.from_dict(obj["tripadvisor"]) if obj.get("tripadvisor") is not None else None,
            "yelp": AppendixTrBusinessDataPriceDataInfo.from_dict(obj["yelp"]) if obj.get("yelp") is not None else None,
            "tasks_ready": AppendixTaskKeywordsDataPriceDataInfo.from_dict(obj["tasks_ready"]) if obj.get("tasks_ready") is not None else None
        })
        return _obj


