# coding: utf-8

"""
    DataForSEO API documentation

    DataForSEO API is the starting point on your journey towards building powerful SEO software. With DataForSEO you can get all the data you need to build an efficient application while also saving your time and budget. DataForSEO API is using the REST technology for interchanging data between your application and our service. The data exchange is made through the widely used HTTP protocol, which allows applying our API to almost all programming languages.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel
from typing import Any, ClassVar, Dict, List, Optional
from dataforseo_client.models.appendix_keyword_bing_keywords_data_price_data_info import AppendixKeywordBingKeywordsDataPriceDataInfo
from dataforseo_client.models.appendix_task_keywords_data_price_data_info import AppendixTaskKeywordsDataPriceDataInfo
from typing import Optional, Set
from typing_extensions import Self

class AppendixClickstreamDataKeywordsDataPriceData(BaseModel):
    """
    AppendixClickstreamDataKeywordsDataPriceData
    """ # noqa: E501
    bulk_search_volume: Optional[AppendixKeywordBingKeywordsDataPriceDataInfo] = None
    dataforseo_search_volume: Optional[AppendixKeywordBingKeywordsDataPriceDataInfo] = None
    global_search_volume: Optional[AppendixKeywordBingKeywordsDataPriceDataInfo] = None
    locations_and_languages: Optional[AppendixTaskKeywordsDataPriceDataInfo] = None
    __properties: ClassVar[List[str]] = ["bulk_search_volume", "dataforseo_search_volume", "global_search_volume", "locations_and_languages"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AppendixClickstreamDataKeywordsDataPriceData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of bulk_search_volume
        if self.bulk_search_volume:
            _dict['bulk_search_volume'] = self.bulk_search_volume.to_dict()
        # override the default output from pydantic by calling `to_dict()` of dataforseo_search_volume
        if self.dataforseo_search_volume:
            _dict['dataforseo_search_volume'] = self.dataforseo_search_volume.to_dict()
        # override the default output from pydantic by calling `to_dict()` of global_search_volume
        if self.global_search_volume:
            _dict['global_search_volume'] = self.global_search_volume.to_dict()
        # override the default output from pydantic by calling `to_dict()` of locations_and_languages
        if self.locations_and_languages:
            _dict['locations_and_languages'] = self.locations_and_languages.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AppendixClickstreamDataKeywordsDataPriceData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "bulk_search_volume": AppendixKeywordBingKeywordsDataPriceDataInfo.from_dict(obj["bulk_search_volume"]) if obj.get("bulk_search_volume") is not None else None,
            "dataforseo_search_volume": AppendixKeywordBingKeywordsDataPriceDataInfo.from_dict(obj["dataforseo_search_volume"]) if obj.get("dataforseo_search_volume") is not None else None,
            "global_search_volume": AppendixKeywordBingKeywordsDataPriceDataInfo.from_dict(obj["global_search_volume"]) if obj.get("global_search_volume") is not None else None,
            "locations_and_languages": AppendixTaskKeywordsDataPriceDataInfo.from_dict(obj["locations_and_languages"]) if obj.get("locations_and_languages") is not None else None
        })
        return _obj


