# coding: utf-8

"""
    DataForSEO API documentation

    DataForSEO API is the starting point on your journey towards building powerful SEO software. With DataForSEO you can get all the data you need to build an efficient application while also saving your time and budget. DataForSEO API is using the REST technology for interchanging data between your application and our service. The data exchange is made through the widely used HTTP protocol, which allows applying our API to almost all programming languages.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel
from typing import Any, ClassVar, Dict, List, Optional
from dataforseo_client.models.appendix_keyword_bing_keywords_data_price_data_info import AppendixKeywordBingKeywordsDataPriceDataInfo
from dataforseo_client.models.appendix_task_keywords_data_price_data_info import AppendixTaskKeywordsDataPriceDataInfo
from typing import Optional, Set
from typing_extensions import Self

class AppendixContentAnalysisPriceData(BaseModel):
    """
    AppendixContentAnalysisPriceData
    """ # noqa: E501
    categories: Optional[AppendixTaskKeywordsDataPriceDataInfo] = None
    category_trends: Optional[AppendixKeywordBingKeywordsDataPriceDataInfo] = None
    errors: Optional[AppendixTaskKeywordsDataPriceDataInfo] = None
    languages: Optional[AppendixTaskKeywordsDataPriceDataInfo] = None
    locations: Optional[AppendixTaskKeywordsDataPriceDataInfo] = None
    phrase_trends: Optional[AppendixKeywordBingKeywordsDataPriceDataInfo] = None
    rating_distribution: Optional[AppendixKeywordBingKeywordsDataPriceDataInfo] = None
    search: Optional[AppendixKeywordBingKeywordsDataPriceDataInfo] = None
    sentiment_analysis: Optional[AppendixKeywordBingKeywordsDataPriceDataInfo] = None
    summary: Optional[AppendixKeywordBingKeywordsDataPriceDataInfo] = None
    __properties: ClassVar[List[str]] = ["categories", "category_trends", "errors", "languages", "locations", "phrase_trends", "rating_distribution", "search", "sentiment_analysis", "summary"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AppendixContentAnalysisPriceData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of categories
        if self.categories:
            _dict['categories'] = self.categories.to_dict()
        # override the default output from pydantic by calling `to_dict()` of category_trends
        if self.category_trends:
            _dict['category_trends'] = self.category_trends.to_dict()
        # override the default output from pydantic by calling `to_dict()` of errors
        if self.errors:
            _dict['errors'] = self.errors.to_dict()
        # override the default output from pydantic by calling `to_dict()` of languages
        if self.languages:
            _dict['languages'] = self.languages.to_dict()
        # override the default output from pydantic by calling `to_dict()` of locations
        if self.locations:
            _dict['locations'] = self.locations.to_dict()
        # override the default output from pydantic by calling `to_dict()` of phrase_trends
        if self.phrase_trends:
            _dict['phrase_trends'] = self.phrase_trends.to_dict()
        # override the default output from pydantic by calling `to_dict()` of rating_distribution
        if self.rating_distribution:
            _dict['rating_distribution'] = self.rating_distribution.to_dict()
        # override the default output from pydantic by calling `to_dict()` of search
        if self.search:
            _dict['search'] = self.search.to_dict()
        # override the default output from pydantic by calling `to_dict()` of sentiment_analysis
        if self.sentiment_analysis:
            _dict['sentiment_analysis'] = self.sentiment_analysis.to_dict()
        # override the default output from pydantic by calling `to_dict()` of summary
        if self.summary:
            _dict['summary'] = self.summary.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AppendixContentAnalysisPriceData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "categories": AppendixTaskKeywordsDataPriceDataInfo.from_dict(obj["categories"]) if obj.get("categories") is not None else None,
            "category_trends": AppendixKeywordBingKeywordsDataPriceDataInfo.from_dict(obj["category_trends"]) if obj.get("category_trends") is not None else None,
            "errors": AppendixTaskKeywordsDataPriceDataInfo.from_dict(obj["errors"]) if obj.get("errors") is not None else None,
            "languages": AppendixTaskKeywordsDataPriceDataInfo.from_dict(obj["languages"]) if obj.get("languages") is not None else None,
            "locations": AppendixTaskKeywordsDataPriceDataInfo.from_dict(obj["locations"]) if obj.get("locations") is not None else None,
            "phrase_trends": AppendixKeywordBingKeywordsDataPriceDataInfo.from_dict(obj["phrase_trends"]) if obj.get("phrase_trends") is not None else None,
            "rating_distribution": AppendixKeywordBingKeywordsDataPriceDataInfo.from_dict(obj["rating_distribution"]) if obj.get("rating_distribution") is not None else None,
            "search": AppendixKeywordBingKeywordsDataPriceDataInfo.from_dict(obj["search"]) if obj.get("search") is not None else None,
            "sentiment_analysis": AppendixKeywordBingKeywordsDataPriceDataInfo.from_dict(obj["sentiment_analysis"]) if obj.get("sentiment_analysis") is not None else None,
            "summary": AppendixKeywordBingKeywordsDataPriceDataInfo.from_dict(obj["summary"]) if obj.get("summary") is not None else None
        })
        return _obj


