# coding: utf-8

"""
    DataForSEO API documentation

    DataForSEO API is the starting point on your journey towards building powerful SEO software. With DataForSEO you can get all the data you need to build an efficient application while also saving your time and budget. DataForSEO API is using the REST technology for interchanging data between your application and our service. The data exchange is made through the widely used HTTP protocol, which allows applying our API to almost all programming languages.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel
from typing import Any, ClassVar, Dict, List, Optional
from dataforseo_client.models.appendix_google_business_data_price_data_info import AppendixGoogleBusinessDataPriceDataInfo
from dataforseo_client.models.appendix_task_keywords_data_price_data_info import AppendixTaskKeywordsDataPriceDataInfo
from typing import Optional, Set
from typing_extensions import Self

class AppendixOnPagePriceData(BaseModel):
    """
    AppendixOnPagePriceData
    """ # noqa: E501
    errors: Optional[AppendixTaskKeywordsDataPriceDataInfo] = None
    lighthouse: Optional[AppendixGoogleBusinessDataPriceDataInfo] = None
    content_parsing: Optional[AppendixTaskKeywordsDataPriceDataInfo] = None
    content_parsing_live: Optional[AppendixTaskKeywordsDataPriceDataInfo] = None
    duplicate_content: Optional[AppendixTaskKeywordsDataPriceDataInfo] = None
    duplicate_tags: Optional[AppendixTaskKeywordsDataPriceDataInfo] = None
    instant_pages: Optional[AppendixTaskKeywordsDataPriceDataInfo] = None
    keyword_density: Optional[AppendixTaskKeywordsDataPriceDataInfo] = None
    links: Optional[AppendixTaskKeywordsDataPriceDataInfo] = None
    non_indexable: Optional[AppendixTaskKeywordsDataPriceDataInfo] = None
    pages: Optional[AppendixTaskKeywordsDataPriceDataInfo] = None
    pages_by_resource: Optional[AppendixTaskKeywordsDataPriceDataInfo] = None
    page_screenshot: Optional[AppendixTaskKeywordsDataPriceDataInfo] = None
    raw_html: Optional[AppendixTaskKeywordsDataPriceDataInfo] = None
    redirect_chains: Optional[AppendixTaskKeywordsDataPriceDataInfo] = None
    resources: Optional[AppendixTaskKeywordsDataPriceDataInfo] = None
    summary: Optional[AppendixTaskKeywordsDataPriceDataInfo] = None
    task_post: Optional[AppendixTaskKeywordsDataPriceDataInfo] = None
    tasks_ready: Optional[AppendixTaskKeywordsDataPriceDataInfo] = None
    waterfall: Optional[AppendixTaskKeywordsDataPriceDataInfo] = None
    __properties: ClassVar[List[str]] = ["errors", "lighthouse", "content_parsing", "content_parsing_live", "duplicate_content", "duplicate_tags", "instant_pages", "keyword_density", "links", "non_indexable", "pages", "pages_by_resource", "page_screenshot", "raw_html", "redirect_chains", "resources", "summary", "task_post", "tasks_ready", "waterfall"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AppendixOnPagePriceData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of errors
        if self.errors:
            _dict['errors'] = self.errors.to_dict()
        # override the default output from pydantic by calling `to_dict()` of lighthouse
        if self.lighthouse:
            _dict['lighthouse'] = self.lighthouse.to_dict()
        # override the default output from pydantic by calling `to_dict()` of content_parsing
        if self.content_parsing:
            _dict['content_parsing'] = self.content_parsing.to_dict()
        # override the default output from pydantic by calling `to_dict()` of content_parsing_live
        if self.content_parsing_live:
            _dict['content_parsing_live'] = self.content_parsing_live.to_dict()
        # override the default output from pydantic by calling `to_dict()` of duplicate_content
        if self.duplicate_content:
            _dict['duplicate_content'] = self.duplicate_content.to_dict()
        # override the default output from pydantic by calling `to_dict()` of duplicate_tags
        if self.duplicate_tags:
            _dict['duplicate_tags'] = self.duplicate_tags.to_dict()
        # override the default output from pydantic by calling `to_dict()` of instant_pages
        if self.instant_pages:
            _dict['instant_pages'] = self.instant_pages.to_dict()
        # override the default output from pydantic by calling `to_dict()` of keyword_density
        if self.keyword_density:
            _dict['keyword_density'] = self.keyword_density.to_dict()
        # override the default output from pydantic by calling `to_dict()` of links
        if self.links:
            _dict['links'] = self.links.to_dict()
        # override the default output from pydantic by calling `to_dict()` of non_indexable
        if self.non_indexable:
            _dict['non_indexable'] = self.non_indexable.to_dict()
        # override the default output from pydantic by calling `to_dict()` of pages
        if self.pages:
            _dict['pages'] = self.pages.to_dict()
        # override the default output from pydantic by calling `to_dict()` of pages_by_resource
        if self.pages_by_resource:
            _dict['pages_by_resource'] = self.pages_by_resource.to_dict()
        # override the default output from pydantic by calling `to_dict()` of page_screenshot
        if self.page_screenshot:
            _dict['page_screenshot'] = self.page_screenshot.to_dict()
        # override the default output from pydantic by calling `to_dict()` of raw_html
        if self.raw_html:
            _dict['raw_html'] = self.raw_html.to_dict()
        # override the default output from pydantic by calling `to_dict()` of redirect_chains
        if self.redirect_chains:
            _dict['redirect_chains'] = self.redirect_chains.to_dict()
        # override the default output from pydantic by calling `to_dict()` of resources
        if self.resources:
            _dict['resources'] = self.resources.to_dict()
        # override the default output from pydantic by calling `to_dict()` of summary
        if self.summary:
            _dict['summary'] = self.summary.to_dict()
        # override the default output from pydantic by calling `to_dict()` of task_post
        if self.task_post:
            _dict['task_post'] = self.task_post.to_dict()
        # override the default output from pydantic by calling `to_dict()` of tasks_ready
        if self.tasks_ready:
            _dict['tasks_ready'] = self.tasks_ready.to_dict()
        # override the default output from pydantic by calling `to_dict()` of waterfall
        if self.waterfall:
            _dict['waterfall'] = self.waterfall.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AppendixOnPagePriceData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "errors": AppendixTaskKeywordsDataPriceDataInfo.from_dict(obj["errors"]) if obj.get("errors") is not None else None,
            "lighthouse": AppendixGoogleBusinessDataPriceDataInfo.from_dict(obj["lighthouse"]) if obj.get("lighthouse") is not None else None,
            "content_parsing": AppendixTaskKeywordsDataPriceDataInfo.from_dict(obj["content_parsing"]) if obj.get("content_parsing") is not None else None,
            "content_parsing_live": AppendixTaskKeywordsDataPriceDataInfo.from_dict(obj["content_parsing_live"]) if obj.get("content_parsing_live") is not None else None,
            "duplicate_content": AppendixTaskKeywordsDataPriceDataInfo.from_dict(obj["duplicate_content"]) if obj.get("duplicate_content") is not None else None,
            "duplicate_tags": AppendixTaskKeywordsDataPriceDataInfo.from_dict(obj["duplicate_tags"]) if obj.get("duplicate_tags") is not None else None,
            "instant_pages": AppendixTaskKeywordsDataPriceDataInfo.from_dict(obj["instant_pages"]) if obj.get("instant_pages") is not None else None,
            "keyword_density": AppendixTaskKeywordsDataPriceDataInfo.from_dict(obj["keyword_density"]) if obj.get("keyword_density") is not None else None,
            "links": AppendixTaskKeywordsDataPriceDataInfo.from_dict(obj["links"]) if obj.get("links") is not None else None,
            "non_indexable": AppendixTaskKeywordsDataPriceDataInfo.from_dict(obj["non_indexable"]) if obj.get("non_indexable") is not None else None,
            "pages": AppendixTaskKeywordsDataPriceDataInfo.from_dict(obj["pages"]) if obj.get("pages") is not None else None,
            "pages_by_resource": AppendixTaskKeywordsDataPriceDataInfo.from_dict(obj["pages_by_resource"]) if obj.get("pages_by_resource") is not None else None,
            "page_screenshot": AppendixTaskKeywordsDataPriceDataInfo.from_dict(obj["page_screenshot"]) if obj.get("page_screenshot") is not None else None,
            "raw_html": AppendixTaskKeywordsDataPriceDataInfo.from_dict(obj["raw_html"]) if obj.get("raw_html") is not None else None,
            "redirect_chains": AppendixTaskKeywordsDataPriceDataInfo.from_dict(obj["redirect_chains"]) if obj.get("redirect_chains") is not None else None,
            "resources": AppendixTaskKeywordsDataPriceDataInfo.from_dict(obj["resources"]) if obj.get("resources") is not None else None,
            "summary": AppendixTaskKeywordsDataPriceDataInfo.from_dict(obj["summary"]) if obj.get("summary") is not None else None,
            "task_post": AppendixTaskKeywordsDataPriceDataInfo.from_dict(obj["task_post"]) if obj.get("task_post") is not None else None,
            "tasks_ready": AppendixTaskKeywordsDataPriceDataInfo.from_dict(obj["tasks_ready"]) if obj.get("tasks_ready") is not None else None,
            "waterfall": AppendixTaskKeywordsDataPriceDataInfo.from_dict(obj["waterfall"]) if obj.get("waterfall") is not None else None
        })
        return _obj


