# coding: utf-8

"""
    DataForSEO API documentation

    DataForSEO API is the starting point on your journey towards building powerful SEO software. With DataForSEO you can get all the data you need to build an efficient application while also saving your time and budget. DataForSEO API is using the REST technology for interchanging data between your application and our service. The data exchange is made through the widely used HTTP protocol, which allows applying our API to almost all programming languages.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel
from typing import Any, ClassVar, Dict, List, Optional
from dataforseo_client.models.appendix_app_data_price_data import AppendixAppDataPriceData
from dataforseo_client.models.appendix_appendix_price_data import AppendixAppendixPriceData
from dataforseo_client.models.appendix_backlinks_price_data import AppendixBacklinksPriceData
from dataforseo_client.models.appendix_business_data_price_data import AppendixBusinessDataPriceData
from dataforseo_client.models.appendix_content_analysis_price_data import AppendixContentAnalysisPriceData
from dataforseo_client.models.appendix_content_generation_price_data import AppendixContentGenerationPriceData
from dataforseo_client.models.appendix_dataforseo_labs_price_data import AppendixDataforseoLabsPriceData
from dataforseo_client.models.appendix_domain_analytics_price_data import AppendixDomainAnalyticsPriceData
from dataforseo_client.models.appendix_keywords_data_price_data import AppendixKeywordsDataPriceData
from dataforseo_client.models.appendix_merchant_price_data import AppendixMerchantPriceData
from dataforseo_client.models.appendix_on_page_price_data import AppendixOnPagePriceData
from dataforseo_client.models.appendix_serp_price_data import AppendixSerpPriceData
from typing import Optional, Set
from typing_extensions import Self

class AppendixPriceData(BaseModel):
    """
    AppendixPriceData
    """ # noqa: E501
    keywords_data: Optional[AppendixKeywordsDataPriceData] = None
    merchant: Optional[AppendixMerchantPriceData] = None
    serp: Optional[AppendixSerpPriceData] = None
    appendix: Optional[AppendixAppendixPriceData] = None
    app_data: Optional[AppendixAppDataPriceData] = None
    backlinks: Optional[AppendixBacklinksPriceData] = None
    business_data: Optional[AppendixBusinessDataPriceData] = None
    content_analysis: Optional[AppendixContentAnalysisPriceData] = None
    content_generation: Optional[AppendixContentGenerationPriceData] = None
    dataforseo_labs: Optional[AppendixDataforseoLabsPriceData] = None
    domain_analytics: Optional[AppendixDomainAnalyticsPriceData] = None
    on_page: Optional[AppendixOnPagePriceData] = None
    __properties: ClassVar[List[str]] = ["keywords_data", "merchant", "serp", "appendix", "app_data", "backlinks", "business_data", "content_analysis", "content_generation", "dataforseo_labs", "domain_analytics", "on_page"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AppendixPriceData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of keywords_data
        if self.keywords_data:
            _dict['keywords_data'] = self.keywords_data.to_dict()
        # override the default output from pydantic by calling `to_dict()` of merchant
        if self.merchant:
            _dict['merchant'] = self.merchant.to_dict()
        # override the default output from pydantic by calling `to_dict()` of serp
        if self.serp:
            _dict['serp'] = self.serp.to_dict()
        # override the default output from pydantic by calling `to_dict()` of appendix
        if self.appendix:
            _dict['appendix'] = self.appendix.to_dict()
        # override the default output from pydantic by calling `to_dict()` of app_data
        if self.app_data:
            _dict['app_data'] = self.app_data.to_dict()
        # override the default output from pydantic by calling `to_dict()` of backlinks
        if self.backlinks:
            _dict['backlinks'] = self.backlinks.to_dict()
        # override the default output from pydantic by calling `to_dict()` of business_data
        if self.business_data:
            _dict['business_data'] = self.business_data.to_dict()
        # override the default output from pydantic by calling `to_dict()` of content_analysis
        if self.content_analysis:
            _dict['content_analysis'] = self.content_analysis.to_dict()
        # override the default output from pydantic by calling `to_dict()` of content_generation
        if self.content_generation:
            _dict['content_generation'] = self.content_generation.to_dict()
        # override the default output from pydantic by calling `to_dict()` of dataforseo_labs
        if self.dataforseo_labs:
            _dict['dataforseo_labs'] = self.dataforseo_labs.to_dict()
        # override the default output from pydantic by calling `to_dict()` of domain_analytics
        if self.domain_analytics:
            _dict['domain_analytics'] = self.domain_analytics.to_dict()
        # override the default output from pydantic by calling `to_dict()` of on_page
        if self.on_page:
            _dict['on_page'] = self.on_page.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AppendixPriceData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "keywords_data": AppendixKeywordsDataPriceData.from_dict(obj["keywords_data"]) if obj.get("keywords_data") is not None else None,
            "merchant": AppendixMerchantPriceData.from_dict(obj["merchant"]) if obj.get("merchant") is not None else None,
            "serp": AppendixSerpPriceData.from_dict(obj["serp"]) if obj.get("serp") is not None else None,
            "appendix": AppendixAppendixPriceData.from_dict(obj["appendix"]) if obj.get("appendix") is not None else None,
            "app_data": AppendixAppDataPriceData.from_dict(obj["app_data"]) if obj.get("app_data") is not None else None,
            "backlinks": AppendixBacklinksPriceData.from_dict(obj["backlinks"]) if obj.get("backlinks") is not None else None,
            "business_data": AppendixBusinessDataPriceData.from_dict(obj["business_data"]) if obj.get("business_data") is not None else None,
            "content_analysis": AppendixContentAnalysisPriceData.from_dict(obj["content_analysis"]) if obj.get("content_analysis") is not None else None,
            "content_generation": AppendixContentGenerationPriceData.from_dict(obj["content_generation"]) if obj.get("content_generation") is not None else None,
            "dataforseo_labs": AppendixDataforseoLabsPriceData.from_dict(obj["dataforseo_labs"]) if obj.get("dataforseo_labs") is not None else None,
            "domain_analytics": AppendixDomainAnalyticsPriceData.from_dict(obj["domain_analytics"]) if obj.get("domain_analytics") is not None else None,
            "on_page": AppendixOnPagePriceData.from_dict(obj["on_page"]) if obj.get("on_page") is not None else None
        })
        return _obj


