# coding: utf-8

"""
    DataForSEO API documentation

    DataForSEO API is the starting point on your journey towards building powerful SEO software. With DataForSEO you can get all the data you need to build an efficient application while also saving your time and budget. DataForSEO API is using the REST technology for interchanging data between your application and our service. The data exchange is made through the widely used HTTP protocol, which allows applying our API to almost all programming languages.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class BacklinksAvailableFiltersResultInfo(BaseModel):
    """
    BacklinksAvailableFiltersResultInfo
    """ # noqa: E501
    content_duplicates: Optional[Dict[str, Optional[StrictStr]]] = None
    backlinks: Optional[Dict[str, Optional[StrictStr]]] = None
    domain_pages: Optional[Dict[str, Optional[StrictStr]]] = None
    anchors: Optional[Dict[str, Optional[StrictStr]]] = None
    referring_domains: Optional[Dict[str, Optional[StrictStr]]] = None
    domain_intersection: Optional[Dict[str, Optional[StrictStr]]] = None
    page_intersection: Optional[Dict[str, Optional[StrictStr]]] = None
    referring_networks: Optional[Dict[str, Optional[StrictStr]]] = None
    domain_pages_summary: Optional[Dict[str, Optional[StrictStr]]] = None
    competitors: Optional[Dict[str, Optional[StrictStr]]] = None
    __properties: ClassVar[List[str]] = ["content_duplicates", "backlinks", "domain_pages", "anchors", "referring_domains", "domain_intersection", "page_intersection", "referring_networks", "domain_pages_summary", "competitors"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BacklinksAvailableFiltersResultInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if content_duplicates (nullable) is None
        # and model_fields_set contains the field
        if self.content_duplicates is None and "content_duplicates" in self.model_fields_set:
            _dict['content_duplicates'] = None

        # set to None if backlinks (nullable) is None
        # and model_fields_set contains the field
        if self.backlinks is None and "backlinks" in self.model_fields_set:
            _dict['backlinks'] = None

        # set to None if domain_pages (nullable) is None
        # and model_fields_set contains the field
        if self.domain_pages is None and "domain_pages" in self.model_fields_set:
            _dict['domain_pages'] = None

        # set to None if anchors (nullable) is None
        # and model_fields_set contains the field
        if self.anchors is None and "anchors" in self.model_fields_set:
            _dict['anchors'] = None

        # set to None if referring_domains (nullable) is None
        # and model_fields_set contains the field
        if self.referring_domains is None and "referring_domains" in self.model_fields_set:
            _dict['referring_domains'] = None

        # set to None if domain_intersection (nullable) is None
        # and model_fields_set contains the field
        if self.domain_intersection is None and "domain_intersection" in self.model_fields_set:
            _dict['domain_intersection'] = None

        # set to None if page_intersection (nullable) is None
        # and model_fields_set contains the field
        if self.page_intersection is None and "page_intersection" in self.model_fields_set:
            _dict['page_intersection'] = None

        # set to None if referring_networks (nullable) is None
        # and model_fields_set contains the field
        if self.referring_networks is None and "referring_networks" in self.model_fields_set:
            _dict['referring_networks'] = None

        # set to None if domain_pages_summary (nullable) is None
        # and model_fields_set contains the field
        if self.domain_pages_summary is None and "domain_pages_summary" in self.model_fields_set:
            _dict['domain_pages_summary'] = None

        # set to None if competitors (nullable) is None
        # and model_fields_set contains the field
        if self.competitors is None and "competitors" in self.model_fields_set:
            _dict['competitors'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BacklinksAvailableFiltersResultInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "content_duplicates": obj.get("content_duplicates"),
            "backlinks": obj.get("backlinks"),
            "domain_pages": obj.get("domain_pages"),
            "anchors": obj.get("anchors"),
            "referring_domains": obj.get("referring_domains"),
            "domain_intersection": obj.get("domain_intersection"),
            "page_intersection": obj.get("page_intersection"),
            "referring_networks": obj.get("referring_networks"),
            "domain_pages_summary": obj.get("domain_pages_summary"),
            "competitors": obj.get("competitors")
        })
        return _obj


