# coding: utf-8

"""
    DataForSEO API documentation

    DataForSEO API is the starting point on your journey towards building powerful SEO software. With DataForSEO you can get all the data you need to build an efficient application while also saving your time and budget. DataForSEO API is using the REST technology for interchanging data between your application and our service. The data exchange is made through the widely used HTTP protocol, which allows applying our API to almost all programming languages.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from dataforseo_client.models.backlinks_backlinks_live_item import BacklinksBacklinksLiveItem
from typing import Optional, Set
from typing_extensions import Self

class BacklinksBacklinksLiveResultInfo(BaseModel):
    """
    BacklinksBacklinksLiveResultInfo
    """ # noqa: E501
    target: Optional[StrictStr] = Field(default=None, description="target domain in a POST array")
    mode: Optional[StrictStr] = Field(default=None, description="mode specified in a POST array")
    custom_mode: Optional[Dict[str, Optional[Dict[str, Any]]]] = Field(default=None, description="custom mode specified in a POST array")
    total_count: Optional[StrictInt] = Field(default=None, description="total amount of results relevant the request")
    items_count: Optional[StrictInt] = Field(default=None, description="the number of results returned in the items array")
    items: Optional[List[BacklinksBacklinksLiveItem]] = Field(default=None, description="contains relevant backlinks and referring domains data")
    search_after_token: Optional[StrictStr] = Field(default=None, description="token for subsequent requests by specifying the unique search_after_token when setting a new task, you will get the subsequent results of the initial task; search_after_token values are unique for each subsequent task")
    __properties: ClassVar[List[str]] = ["target", "mode", "custom_mode", "total_count", "items_count", "items", "search_after_token"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BacklinksBacklinksLiveResultInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in items (list)
        _items = []
        if self.items:
            for _item in self.items:
                if _item:
                    _items.append(_item.to_dict())
            _dict['items'] = _items
        # set to None if target (nullable) is None
        # and model_fields_set contains the field
        if self.target is None and "target" in self.model_fields_set:
            _dict['target'] = None

        # set to None if mode (nullable) is None
        # and model_fields_set contains the field
        if self.mode is None and "mode" in self.model_fields_set:
            _dict['mode'] = None

        # set to None if custom_mode (nullable) is None
        # and model_fields_set contains the field
        if self.custom_mode is None and "custom_mode" in self.model_fields_set:
            _dict['custom_mode'] = None

        # set to None if total_count (nullable) is None
        # and model_fields_set contains the field
        if self.total_count is None and "total_count" in self.model_fields_set:
            _dict['total_count'] = None

        # set to None if items_count (nullable) is None
        # and model_fields_set contains the field
        if self.items_count is None and "items_count" in self.model_fields_set:
            _dict['items_count'] = None

        # set to None if items (nullable) is None
        # and model_fields_set contains the field
        if self.items is None and "items" in self.model_fields_set:
            _dict['items'] = None

        # set to None if search_after_token (nullable) is None
        # and model_fields_set contains the field
        if self.search_after_token is None and "search_after_token" in self.model_fields_set:
            _dict['search_after_token'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BacklinksBacklinksLiveResultInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "target": obj.get("target"),
            "mode": obj.get("mode"),
            "custom_mode": obj.get("custom_mode"),
            "total_count": obj.get("total_count"),
            "items_count": obj.get("items_count"),
            "items": [BacklinksBacklinksLiveItem.from_dict(_item) for _item in obj["items"]] if obj.get("items") is not None else None,
            "search_after_token": obj.get("search_after_token")
        })
        return _obj


