# coding: utf-8

"""
    DataForSEO API documentation

    DataForSEO API is the starting point on your journey towards building powerful SEO software. With DataForSEO you can get all the data you need to build an efficient application while also saving your time and budget. DataForSEO API is using the REST technology for interchanging data between your application and our service. The data exchange is made through the widely used HTTP protocol, which allows applying our API to almost all programming languages.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class BaseDataforseoLabsSerpElementItem(BaseModel):
    """
    BaseDataforseoLabsSerpElementItem
    """ # noqa: E501
    type: Optional[StrictStr] = Field(default=None, description="type of element")
    __properties: ClassVar[List[str]] = ["type"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    # JSON field name that stores the object type
    __discriminator_property_name: ClassVar[str] = 'type'

    # discriminator mappings
    __discriminator_value_class_map: ClassVar[Dict[str, str]] = {
        'answer_box': 'QAnswerBoxDataforseoLabsSerpElementItem','carousel': 'CarouselDataforseoLabsSerpElementItem','commercial_units': 'CommercialUnitsDataforseoLabsSerpElementItem','events': 'EventsDataforseoLabsSerpElementItem','featured_snippet': 'FeaturedSnippetDataforseoLabsSerpElementItem','find_results_on': 'FindResultsOnDataforseoLabsSerpElementItem','google_flights': 'GoogleFlightsDataforseoLabsSerpElementItem','google_hotels': 'GoogleHotelsDataforseoLabsSerpElementItem','google_posts': 'GooglePostsDataforseoLabsSerpElementItem','google_reviews': 'GoogleReviewsDataforseoLabsSerpElementItem','hotels_pack': 'HotelsPackDataforseoLabsSerpElementItem','images': 'ImagesDataforseoLabsSerpElementItem','jobs': 'JobsDataforseoLabsSerpElementItem','knowledge_graph': 'KnowledgeGraphDataforseoLabsSerpElementItem','knowledge_graph_carousel_item': 'KnowledgeGraphCarouselItemDataforseoLabsSerpElementItem','knowledge_graph_description_item': 'KnowledgeGraphDescriptionItemDataforseoLabsSerpElementItem','knowledge_graph_expanded_item': 'KnowledgeGraphExpandedItemDataforseoLabsSerpElementItem','knowledge_graph_images_item': 'KnowledgeGraphImagesItemDataforseoLabsSerpElementItem','knowledge_graph_list_item': 'KnowledgeGraphListItemDataforseoLabsSerpElementItem','knowledge_graph_part_item': 'KnowledgeGraphPartItemDataforseoLabsSerpElementItem','knowledge_graph_row_item': 'KnowledgeGraphRowItemDataforseoLabsSerpElementItem','knowledge_graph_shopping_item': 'KnowledgeGraphShoppingItemDataforseoLabsSerpElementItem','local_pack': 'LocalPackDataforseoLabsSerpElementItem','local_services': 'LocalServicesDataforseoLabsSerpElementItem','map': 'MapDataforseoLabsSerpElementItem','math_solver': 'MathSolverDataforseoLabsSerpElementItem','mention_carousel': 'MentionCarouselDataforseoLabsSerpElementItem','multi_carousel': 'MultiCarouselDataforseoLabsSerpElementItem','organic': 'OrganicDataforseoLabsSerpElementItem','paid': 'PaidDataforseoLabsSerpElementItem','people_also_ask': 'PeopleAlsoAskDataforseoLabsSerpElementItem','people_also_search': 'PeopleAlsoSearchDataforseoLabsSerpElementItem','podcasts': 'PodcastsDataforseoLabsSerpElementItem','popular_products': 'PopularProductsDataforseoLabsSerpElementItem','questions_and_answers': 'QuestionsAndAnswersDataforseoLabsSerpElementItem','recipes': 'RecipesDataforseoLabsSerpElementItem','related_searches': 'RelatedSearchesDataforseoLabsSerpElementItem','scholarly_articles': 'ScholarlyArticlesDataforseoLabsSerpElementItem','shopping': 'ShoppingDataforseoLabsSerpElementItem','stocks_box': 'StocksBoxDataforseoLabsSerpElementItem','top_sights': 'TopSightsDataforseoLabsSerpElementItem','top_stories': 'TopStoriesDataforseoLabsSerpElementItem','twitter': 'TwitterDataforseoLabsSerpElementItem','video': 'VideoDataforseoLabsSerpElementItem','visual_stories': 'VisualStoriesDataforseoLabsSerpElementItem'
    }

    @classmethod
    def get_discriminator_value(cls, obj: Dict[str, Any]) -> Optional[str]:
        """Returns the discriminator value (object type) of the data"""
        discriminator_value = obj[cls.__discriminator_property_name]
        if discriminator_value:
            return cls.__discriminator_value_class_map.get(discriminator_value)
        else:
            return None

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Union[Self, Self, Self, Self, Self, Self, Self, Self, Self, Self, Self, Self, Self, Self, Self, Self, Self, Self, Self, Self, Self, Self, Self, Self, Self, Self, Self, Self, Self, Self, Self, Self, Self, Self, Self, Self, Self, Self, Self, Self, Self, Self, Self, Self, Self]]:
        """Create an instance of BaseDataforseoLabsSerpElementItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if type (nullable) is None
        # and model_fields_set contains the field
        if self.type is None and "type" in self.model_fields_set:
            _dict['type'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Dict[str, Any]) -> Optional[Union[Self, Self, Self, Self, Self, Self, Self, Self, Self, Self, Self, Self, Self, Self, Self, Self, Self, Self, Self, Self, Self, Self, Self, Self, Self, Self, Self, Self, Self, Self, Self, Self, Self, Self, Self, Self, Self, Self, Self, Self, Self, Self, Self, Self, Self]]:
        """Create an instance of BaseDataforseoLabsSerpElementItem from a dict"""
        # look up the object type based on discriminator mapping
        object_type = cls.get_discriminator_value(obj)
        if object_type:
            klass = globals()[object_type]
            return klass.from_dict(obj)
        else:
            raise ValueError("BaseDataforseoLabsSerpElementItem failed to lookup discriminator value from " +
                             json.dumps(obj) + ". Discriminator property name: " + cls.__discriminator_property_name +
                             ", mapping: " + json.dumps(cls.__discriminator_value_class_map))

from dataforseo_client.models.carousel_dataforseo_labs_serp_element_item import CarouselDataforseoLabsSerpElementItem
from dataforseo_client.models.commercial_units_dataforseo_labs_serp_element_item import CommercialUnitsDataforseoLabsSerpElementItem
from dataforseo_client.models.events_dataforseo_labs_serp_element_item import EventsDataforseoLabsSerpElementItem
from dataforseo_client.models.featured_snippet_dataforseo_labs_serp_element_item import FeaturedSnippetDataforseoLabsSerpElementItem
from dataforseo_client.models.find_results_on_dataforseo_labs_serp_element_item import FindResultsOnDataforseoLabsSerpElementItem
from dataforseo_client.models.google_flights_dataforseo_labs_serp_element_item import GoogleFlightsDataforseoLabsSerpElementItem
from dataforseo_client.models.google_hotels_dataforseo_labs_serp_element_item import GoogleHotelsDataforseoLabsSerpElementItem
from dataforseo_client.models.google_posts_dataforseo_labs_serp_element_item import GooglePostsDataforseoLabsSerpElementItem
from dataforseo_client.models.google_reviews_dataforseo_labs_serp_element_item import GoogleReviewsDataforseoLabsSerpElementItem
from dataforseo_client.models.hotels_pack_dataforseo_labs_serp_element_item import HotelsPackDataforseoLabsSerpElementItem
from dataforseo_client.models.images_dataforseo_labs_serp_element_item import ImagesDataforseoLabsSerpElementItem
from dataforseo_client.models.jobs_dataforseo_labs_serp_element_item import JobsDataforseoLabsSerpElementItem
from dataforseo_client.models.knowledge_graph_carousel_item_dataforseo_labs_serp_element_item import KnowledgeGraphCarouselItemDataforseoLabsSerpElementItem
from dataforseo_client.models.knowledge_graph_dataforseo_labs_serp_element_item import KnowledgeGraphDataforseoLabsSerpElementItem
from dataforseo_client.models.knowledge_graph_description_item_dataforseo_labs_serp_element_item import KnowledgeGraphDescriptionItemDataforseoLabsSerpElementItem
from dataforseo_client.models.knowledge_graph_expanded_item_dataforseo_labs_serp_element_item import KnowledgeGraphExpandedItemDataforseoLabsSerpElementItem
from dataforseo_client.models.knowledge_graph_images_item_dataforseo_labs_serp_element_item import KnowledgeGraphImagesItemDataforseoLabsSerpElementItem
from dataforseo_client.models.knowledge_graph_list_item_dataforseo_labs_serp_element_item import KnowledgeGraphListItemDataforseoLabsSerpElementItem
from dataforseo_client.models.knowledge_graph_part_item_dataforseo_labs_serp_element_item import KnowledgeGraphPartItemDataforseoLabsSerpElementItem
from dataforseo_client.models.knowledge_graph_row_item_dataforseo_labs_serp_element_item import KnowledgeGraphRowItemDataforseoLabsSerpElementItem
from dataforseo_client.models.knowledge_graph_shopping_item_dataforseo_labs_serp_element_item import KnowledgeGraphShoppingItemDataforseoLabsSerpElementItem
from dataforseo_client.models.local_pack_dataforseo_labs_serp_element_item import LocalPackDataforseoLabsSerpElementItem
from dataforseo_client.models.local_services_dataforseo_labs_serp_element_item import LocalServicesDataforseoLabsSerpElementItem
from dataforseo_client.models.map_dataforseo_labs_serp_element_item import MapDataforseoLabsSerpElementItem
from dataforseo_client.models.math_solver_dataforseo_labs_serp_element_item import MathSolverDataforseoLabsSerpElementItem
from dataforseo_client.models.mention_carousel_dataforseo_labs_serp_element_item import MentionCarouselDataforseoLabsSerpElementItem
from dataforseo_client.models.multi_carousel_dataforseo_labs_serp_element_item import MultiCarouselDataforseoLabsSerpElementItem
from dataforseo_client.models.organic_dataforseo_labs_serp_element_item import OrganicDataforseoLabsSerpElementItem
from dataforseo_client.models.paid_dataforseo_labs_serp_element_item import PaidDataforseoLabsSerpElementItem
from dataforseo_client.models.people_also_ask_dataforseo_labs_serp_element_item import PeopleAlsoAskDataforseoLabsSerpElementItem
from dataforseo_client.models.people_also_search_dataforseo_labs_serp_element_item import PeopleAlsoSearchDataforseoLabsSerpElementItem
from dataforseo_client.models.podcasts_dataforseo_labs_serp_element_item import PodcastsDataforseoLabsSerpElementItem
from dataforseo_client.models.popular_products_dataforseo_labs_serp_element_item import PopularProductsDataforseoLabsSerpElementItem
from dataforseo_client.models.q_answer_box_dataforseo_labs_serp_element_item import QAnswerBoxDataforseoLabsSerpElementItem
from dataforseo_client.models.questions_and_answers_dataforseo_labs_serp_element_item import QuestionsAndAnswersDataforseoLabsSerpElementItem
from dataforseo_client.models.recipes_dataforseo_labs_serp_element_item import RecipesDataforseoLabsSerpElementItem
from dataforseo_client.models.related_searches_dataforseo_labs_serp_element_item import RelatedSearchesDataforseoLabsSerpElementItem
from dataforseo_client.models.scholarly_articles_dataforseo_labs_serp_element_item import ScholarlyArticlesDataforseoLabsSerpElementItem
from dataforseo_client.models.shopping_dataforseo_labs_serp_element_item import ShoppingDataforseoLabsSerpElementItem
from dataforseo_client.models.stocks_box_dataforseo_labs_serp_element_item import StocksBoxDataforseoLabsSerpElementItem
from dataforseo_client.models.top_sights_dataforseo_labs_serp_element_item import TopSightsDataforseoLabsSerpElementItem
from dataforseo_client.models.top_stories_dataforseo_labs_serp_element_item import TopStoriesDataforseoLabsSerpElementItem
from dataforseo_client.models.twitter_dataforseo_labs_serp_element_item import TwitterDataforseoLabsSerpElementItem
from dataforseo_client.models.video_dataforseo_labs_serp_element_item import VideoDataforseoLabsSerpElementItem
from dataforseo_client.models.visual_stories_dataforseo_labs_serp_element_item import VisualStoriesDataforseoLabsSerpElementItem
# TODO: Rewrite to not use raise_errors
BaseDataforseoLabsSerpElementItem.model_rebuild(raise_errors=False)

