# coding: utf-8

"""
    DataForSEO API documentation

    DataForSEO API is the starting point on your journey towards building powerful SEO software. With DataForSEO you can get all the data you need to build an efficient application while also saving your time and budget. DataForSEO API is using the REST technology for interchanging data between your application and our service. The data exchange is made through the widely used HTTP protocol, which allows applying our API to almost all programming languages.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from dataforseo_client.models.hotel_about_info import HotelAboutInfo
from dataforseo_client.models.hotel_location_info import HotelLocationInfo
from dataforseo_client.models.hotel_price_info import HotelPriceInfo
from dataforseo_client.models.hotel_review_info import HotelReviewInfo
from typing import Optional, Set
from typing_extensions import Self

class BusinessDataGoogleHotelInfoTaskGetAdvancedResultInfo(BaseModel):
    """
    BusinessDataGoogleHotelInfoTaskGetAdvancedResultInfo
    """ # noqa: E501
    hotel_identifier: Optional[StrictStr] = Field(default=None, description="unique hotel identifier this field will contain the hotel_identifier parameter; example: CgoI-KWyzenM_MV3EAE")
    location_code: Optional[StrictInt] = Field(default=None, description="location code in a POST array")
    language_code: Optional[StrictStr] = Field(default=None, description="language code in a POST array")
    check_url: Optional[StrictStr] = Field(default=None, description="direct URL to search engine results you can use it to make sure that we provided accurate results")
    datetime: Optional[StrictStr] = Field(default=None, description="date and time when the result was received in the UTC format: “yyyy-mm-dd hh-mm-ss +00:00” example: 2019-11-15 12:57:46 +00:00")
    title: Optional[StrictStr] = Field(default=None, description="hotel title the title of the hotel entity for which the results are collected")
    stars: Optional[StrictInt] = Field(default=None, description="hotel class rating class rating that ranges between 1-5 stars and displayed after review ratings in hotel summary")
    stars_description: Optional[StrictStr] = Field(default=None, description="hotel class rating class rating that ranges between 1-5 stars and displayed after review ratings in the hotel summary")
    address: Optional[StrictStr] = Field(default=None, description="hotel address physical address of the hotel")
    phone: Optional[StrictStr] = Field(default=None, description="hotel phone number contact phone number of the hotel")
    about: Optional[HotelAboutInfo] = None
    location: Optional[HotelLocationInfo] = None
    reviews: Optional[HotelReviewInfo] = None
    overview_images: Optional[List[Optional[StrictStr]]] = Field(default=None, description="images displayed in the hotel overview array containing URLs to images displayed in the hotel overview")
    prices: Optional[HotelPriceInfo] = None
    __properties: ClassVar[List[str]] = ["hotel_identifier", "location_code", "language_code", "check_url", "datetime", "title", "stars", "stars_description", "address", "phone", "about", "location", "reviews", "overview_images", "prices"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BusinessDataGoogleHotelInfoTaskGetAdvancedResultInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of about
        if self.about:
            _dict['about'] = self.about.to_dict()
        # override the default output from pydantic by calling `to_dict()` of location
        if self.location:
            _dict['location'] = self.location.to_dict()
        # override the default output from pydantic by calling `to_dict()` of reviews
        if self.reviews:
            _dict['reviews'] = self.reviews.to_dict()
        # override the default output from pydantic by calling `to_dict()` of prices
        if self.prices:
            _dict['prices'] = self.prices.to_dict()
        # set to None if hotel_identifier (nullable) is None
        # and model_fields_set contains the field
        if self.hotel_identifier is None and "hotel_identifier" in self.model_fields_set:
            _dict['hotel_identifier'] = None

        # set to None if location_code (nullable) is None
        # and model_fields_set contains the field
        if self.location_code is None and "location_code" in self.model_fields_set:
            _dict['location_code'] = None

        # set to None if language_code (nullable) is None
        # and model_fields_set contains the field
        if self.language_code is None and "language_code" in self.model_fields_set:
            _dict['language_code'] = None

        # set to None if check_url (nullable) is None
        # and model_fields_set contains the field
        if self.check_url is None and "check_url" in self.model_fields_set:
            _dict['check_url'] = None

        # set to None if datetime (nullable) is None
        # and model_fields_set contains the field
        if self.datetime is None and "datetime" in self.model_fields_set:
            _dict['datetime'] = None

        # set to None if title (nullable) is None
        # and model_fields_set contains the field
        if self.title is None and "title" in self.model_fields_set:
            _dict['title'] = None

        # set to None if stars (nullable) is None
        # and model_fields_set contains the field
        if self.stars is None and "stars" in self.model_fields_set:
            _dict['stars'] = None

        # set to None if stars_description (nullable) is None
        # and model_fields_set contains the field
        if self.stars_description is None and "stars_description" in self.model_fields_set:
            _dict['stars_description'] = None

        # set to None if address (nullable) is None
        # and model_fields_set contains the field
        if self.address is None and "address" in self.model_fields_set:
            _dict['address'] = None

        # set to None if phone (nullable) is None
        # and model_fields_set contains the field
        if self.phone is None and "phone" in self.model_fields_set:
            _dict['phone'] = None

        # set to None if overview_images (nullable) is None
        # and model_fields_set contains the field
        if self.overview_images is None and "overview_images" in self.model_fields_set:
            _dict['overview_images'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BusinessDataGoogleHotelInfoTaskGetAdvancedResultInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "hotel_identifier": obj.get("hotel_identifier"),
            "location_code": obj.get("location_code"),
            "language_code": obj.get("language_code"),
            "check_url": obj.get("check_url"),
            "datetime": obj.get("datetime"),
            "title": obj.get("title"),
            "stars": obj.get("stars"),
            "stars_description": obj.get("stars_description"),
            "address": obj.get("address"),
            "phone": obj.get("phone"),
            "about": HotelAboutInfo.from_dict(obj["about"]) if obj.get("about") is not None else None,
            "location": HotelLocationInfo.from_dict(obj["location"]) if obj.get("location") is not None else None,
            "reviews": HotelReviewInfo.from_dict(obj["reviews"]) if obj.get("reviews") is not None else None,
            "overview_images": obj.get("overview_images"),
            "prices": HotelPriceInfo.from_dict(obj["prices"]) if obj.get("prices") is not None else None
        })
        return _obj


