# coding: utf-8

"""
    DataForSEO API documentation

    DataForSEO API is the starting point on your journey towards building powerful SEO software. With DataForSEO you can get all the data you need to build an efficient application while also saving your time and budget. DataForSEO API is using the REST technology for interchanging data between your application and our service. The data exchange is made through the widely used HTTP protocol, which allows applying our API to almost all programming languages.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from dataforseo_client.models.gps_coordinates_location_info import GpsCoordinatesLocationInfo
from dataforseo_client.models.hotel_price_info import HotelPriceInfo
from dataforseo_client.models.hotel_review_info import HotelReviewInfo
from typing import Optional, Set
from typing_extensions import Self

class BusinessDataGoogleHotelSearchesItem(BaseModel):
    """
    BusinessDataGoogleHotelSearchesItem
    """ # noqa: E501
    type: Optional[StrictStr] = Field(default=None, description="type of element")
    hotel_identifier: Optional[StrictStr] = Field(default=None, description="unique identifier of a hotel entity in Google search example: CgoI-KWyzenM_MV3EAE")
    title: Optional[StrictStr] = Field(default=None, description="title of the hotel")
    stars: Optional[StrictInt] = Field(default=None, description="hotel class rating class rating that ranges between 1-5 stars")
    is_paid: Optional[StrictBool] = Field(default=None, description="indicates a paid hotel listing if true, related hotel_search_item is a paid ad if false, related hotel_search_item is an organic hotel listing")
    location: Optional[GpsCoordinatesLocationInfo] = None
    reviews: Optional[HotelReviewInfo] = None
    overview_images: Optional[List[Optional[StrictStr]]] = Field(default=None, description="featured images for a hotel")
    prices: Optional[HotelPriceInfo] = None
    __properties: ClassVar[List[str]] = ["type", "hotel_identifier", "title", "stars", "is_paid", "location", "reviews", "overview_images", "prices"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BusinessDataGoogleHotelSearchesItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of location
        if self.location:
            _dict['location'] = self.location.to_dict()
        # override the default output from pydantic by calling `to_dict()` of reviews
        if self.reviews:
            _dict['reviews'] = self.reviews.to_dict()
        # override the default output from pydantic by calling `to_dict()` of prices
        if self.prices:
            _dict['prices'] = self.prices.to_dict()
        # set to None if type (nullable) is None
        # and model_fields_set contains the field
        if self.type is None and "type" in self.model_fields_set:
            _dict['type'] = None

        # set to None if hotel_identifier (nullable) is None
        # and model_fields_set contains the field
        if self.hotel_identifier is None and "hotel_identifier" in self.model_fields_set:
            _dict['hotel_identifier'] = None

        # set to None if title (nullable) is None
        # and model_fields_set contains the field
        if self.title is None and "title" in self.model_fields_set:
            _dict['title'] = None

        # set to None if stars (nullable) is None
        # and model_fields_set contains the field
        if self.stars is None and "stars" in self.model_fields_set:
            _dict['stars'] = None

        # set to None if is_paid (nullable) is None
        # and model_fields_set contains the field
        if self.is_paid is None and "is_paid" in self.model_fields_set:
            _dict['is_paid'] = None

        # set to None if overview_images (nullable) is None
        # and model_fields_set contains the field
        if self.overview_images is None and "overview_images" in self.model_fields_set:
            _dict['overview_images'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BusinessDataGoogleHotelSearchesItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "type": obj.get("type"),
            "hotel_identifier": obj.get("hotel_identifier"),
            "title": obj.get("title"),
            "stars": obj.get("stars"),
            "is_paid": obj.get("is_paid"),
            "location": GpsCoordinatesLocationInfo.from_dict(obj["location"]) if obj.get("location") is not None else None,
            "reviews": HotelReviewInfo.from_dict(obj["reviews"]) if obj.get("reviews") is not None else None,
            "overview_images": obj.get("overview_images"),
            "prices": HotelPriceInfo.from_dict(obj["prices"]) if obj.get("prices") is not None else None
        })
        return _obj


