# coding: utf-8

"""
    DataForSEO API documentation

    DataForSEO API is the starting point on your journey towards building powerful SEO software. With DataForSEO you can get all the data you need to build an efficient application while also saving your time and budget. DataForSEO API is using the REST technology for interchanging data between your application and our service. The data exchange is made through the widely used HTTP protocol, which allows applying our API to almost all programming languages.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from dataforseo_client.models.content_analysis_categories_info import ContentAnalysisCategoriesInfo
from dataforseo_client.models.top_domain_info import TopDomainInfo
from typing import Optional, Set
from typing_extensions import Self

class ContentAnalysisPhraseTrendsLiveResultInfo(BaseModel):
    """
    ContentAnalysisPhraseTrendsLiveResultInfo
    """ # noqa: E501
    type: Optional[StrictStr] = Field(default=None, description="type of element")
    var_date: Optional[StrictStr] = Field(default=None, description="date for which the data is provided", alias="date")
    total_count: Optional[StrictInt] = Field(default=None, description="total number of results in our database relevant to your request")
    rank: Optional[StrictInt] = Field(default=None, description="rank of all URLs citing the keyword normalized sum of ranks of all URLs citing the target keyword for the given date")
    top_domains: Optional[List[TopDomainInfo]] = Field(default=None, description="top domains citing the target keyword contains objects with top domains citing the target keyword and citation count per each domain")
    sentiment_connotations: Optional[Dict[str, Optional[StrictInt]]] = Field(default=None, description="sentiment connotations contains sentiments (emotional reactions) related to the target keyword citation and the number of citations per each sentiment possible connotations: \"anger\", \"happiness\", \"love\", \"sadness\", \"share\", \"fun\"")
    connotation_types: Optional[Dict[str, Optional[StrictInt]]] = Field(default=None, description="connotation types contains types of sentiments (sentiment polarity) related to the keyword citation and citation count per each sentiment type possible connotation types: \"positive\", \"negative\", \"neutral\"")
    text_categories: Optional[List[ContentAnalysisCategoriesInfo]] = Field(default=None, description="text categories contains objects with text categories and citation count in each text category to obtain a full list of available categories, refer to the Categories endpoint")
    page_categories: Optional[List[ContentAnalysisCategoriesInfo]] = Field(default=None, description="page categories contains objects with page categories and citation count in each page category to obtain a full list of available categories, refer to the Categories endpoint")
    page_types: Optional[Dict[str, Optional[StrictInt]]] = Field(default=None, description="page types contains page types and citation count per each page type")
    countries: Optional[Dict[str, Optional[StrictInt]]] = Field(default=None, description="countries contains countries and citation count in each country to obtain a full list of available countries, refer to the Locations endpoint")
    languages: Optional[Dict[str, Optional[StrictInt]]] = Field(default=None, description="languages contains languages and citation count in each language to obtain a full list of available languages, refer to the Languages endpoint")
    __properties: ClassVar[List[str]] = ["type", "date", "total_count", "rank", "top_domains", "sentiment_connotations", "connotation_types", "text_categories", "page_categories", "page_types", "countries", "languages"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ContentAnalysisPhraseTrendsLiveResultInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in top_domains (list)
        _items = []
        if self.top_domains:
            for _item in self.top_domains:
                if _item:
                    _items.append(_item.to_dict())
            _dict['top_domains'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in text_categories (list)
        _items = []
        if self.text_categories:
            for _item in self.text_categories:
                if _item:
                    _items.append(_item.to_dict())
            _dict['text_categories'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in page_categories (list)
        _items = []
        if self.page_categories:
            for _item in self.page_categories:
                if _item:
                    _items.append(_item.to_dict())
            _dict['page_categories'] = _items
        # set to None if type (nullable) is None
        # and model_fields_set contains the field
        if self.type is None and "type" in self.model_fields_set:
            _dict['type'] = None

        # set to None if var_date (nullable) is None
        # and model_fields_set contains the field
        if self.var_date is None and "var_date" in self.model_fields_set:
            _dict['date'] = None

        # set to None if total_count (nullable) is None
        # and model_fields_set contains the field
        if self.total_count is None and "total_count" in self.model_fields_set:
            _dict['total_count'] = None

        # set to None if rank (nullable) is None
        # and model_fields_set contains the field
        if self.rank is None and "rank" in self.model_fields_set:
            _dict['rank'] = None

        # set to None if top_domains (nullable) is None
        # and model_fields_set contains the field
        if self.top_domains is None and "top_domains" in self.model_fields_set:
            _dict['top_domains'] = None

        # set to None if sentiment_connotations (nullable) is None
        # and model_fields_set contains the field
        if self.sentiment_connotations is None and "sentiment_connotations" in self.model_fields_set:
            _dict['sentiment_connotations'] = None

        # set to None if connotation_types (nullable) is None
        # and model_fields_set contains the field
        if self.connotation_types is None and "connotation_types" in self.model_fields_set:
            _dict['connotation_types'] = None

        # set to None if text_categories (nullable) is None
        # and model_fields_set contains the field
        if self.text_categories is None and "text_categories" in self.model_fields_set:
            _dict['text_categories'] = None

        # set to None if page_categories (nullable) is None
        # and model_fields_set contains the field
        if self.page_categories is None and "page_categories" in self.model_fields_set:
            _dict['page_categories'] = None

        # set to None if page_types (nullable) is None
        # and model_fields_set contains the field
        if self.page_types is None and "page_types" in self.model_fields_set:
            _dict['page_types'] = None

        # set to None if countries (nullable) is None
        # and model_fields_set contains the field
        if self.countries is None and "countries" in self.model_fields_set:
            _dict['countries'] = None

        # set to None if languages (nullable) is None
        # and model_fields_set contains the field
        if self.languages is None and "languages" in self.model_fields_set:
            _dict['languages'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ContentAnalysisPhraseTrendsLiveResultInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "type": obj.get("type"),
            "date": obj.get("date"),
            "total_count": obj.get("total_count"),
            "rank": obj.get("rank"),
            "top_domains": [TopDomainInfo.from_dict(_item) for _item in obj["top_domains"]] if obj.get("top_domains") is not None else None,
            "sentiment_connotations": obj.get("sentiment_connotations"),
            "connotation_types": obj.get("connotation_types"),
            "text_categories": [ContentAnalysisCategoriesInfo.from_dict(_item) for _item in obj["text_categories"]] if obj.get("text_categories") is not None else None,
            "page_categories": [ContentAnalysisCategoriesInfo.from_dict(_item) for _item in obj["page_categories"]] if obj.get("page_categories") is not None else None,
            "page_types": obj.get("page_types"),
            "countries": obj.get("countries"),
            "languages": obj.get("languages")
        })
        return _obj


