# coding: utf-8

"""
    DataForSEO API documentation

    DataForSEO API is the starting point on your journey towards building powerful SEO software. With DataForSEO you can get all the data you need to build an efficient application while also saving your time and budget. DataForSEO API is using the REST technology for interchanging data between your application and our service. The data exchange is made through the widely used HTTP protocol, which allows applying our API to almost all programming languages.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from dataforseo_client.models.analysis_content_info import AnalysisContentInfo
from dataforseo_client.models.rating_info import RatingInfo
from dataforseo_client.models.social_metrics_info import SocialMetricsInfo
from typing import Optional, Set
from typing_extensions import Self

class ContentAnalysisSearchLiveItem(BaseModel):
    """
    ContentAnalysisSearchLiveItem
    """ # noqa: E501
    type: Optional[StrictStr] = Field(default=None, description="type of element")
    url: Optional[StrictStr] = Field(default=None, description="URL where the citation was found")
    domain: Optional[StrictStr] = Field(default=None, description="domain name")
    main_domain: Optional[StrictStr] = Field(default=None, description="main domain")
    url_rank: Optional[StrictInt] = Field(default=None, description="rank of the url this value is based on backlink data for the given URL from DataForSEO Backlink Index; url_rank is calculated based on the method for node ranking in a linked database – a principle used in the original Google PageRank algorithm learn more about the metric and how it is calculated in this help center article")
    spam_score: Optional[StrictStr] = Field(default=None, description="backlink spam score of the url this value is based on backlink data for the given URL from DataForSEO Backlink Index; learn more about how the metric is calculated on this help center page")
    domain_rank: Optional[StrictStr] = Field(default=None, description="rank of the domain this value is based on backlink data for the given domain from DataForSEO Backlink Index; domain_rank is calculated based on the method for node ranking in a linked database – a principle used in the original Google PageRank algorithm learn more about the metric and how it is calculated in this help center article")
    fetch_time: Optional[StrictStr] = Field(default=None, description="date and time when our crawler visited the page in the UTC format: “yyyy-mm-dd hh-mm-ss +00:00” example: 2017-01-24 13:20:59 +00:00")
    country: Optional[StrictStr] = Field(default=None, description="country code of the domain registration to obtain a full list of available countries, refer to the Locations endpoint")
    language: Optional[StrictStr] = Field(default=None, description="main language of the domain to obtain a full list of available languages, refer to the Languages endpoint")
    score: Optional[StrictStr] = Field(default=None, description="citation prominence score this value is based on url_rank, domain_rank, keyword presence in title, main_title, url, snippet the higher the score, the more value the related citation has")
    page_category: Optional[List[StrictInt]] = Field(default=None, description="contains all relevant page categories product and service categories relevant for the page to obtain a full list of available categories, refer to the Categories endpoint")
    page_types: Optional[List[StrictStr]] = Field(default=None, description="page types")
    ratings: Optional[List[RatingInfo]] = Field(default=None, description="ratings found on the page all ratings found on the page based on microdata")
    social_metrics: Optional[List[SocialMetricsInfo]] = Field(default=None, description="social media engagement metrics data on social media interactions associated with the content based on website embeds developed and supported by social media platforms")
    content_info: Optional[AnalysisContentInfo] = None
    __properties: ClassVar[List[str]] = ["type", "url", "domain", "main_domain", "url_rank", "spam_score", "domain_rank", "fetch_time", "country", "language", "score", "page_category", "page_types", "ratings", "social_metrics", "content_info"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ContentAnalysisSearchLiveItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in ratings (list)
        _items = []
        if self.ratings:
            for _item in self.ratings:
                if _item:
                    _items.append(_item.to_dict())
            _dict['ratings'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in social_metrics (list)
        _items = []
        if self.social_metrics:
            for _item in self.social_metrics:
                if _item:
                    _items.append(_item.to_dict())
            _dict['social_metrics'] = _items
        # override the default output from pydantic by calling `to_dict()` of content_info
        if self.content_info:
            _dict['content_info'] = self.content_info.to_dict()
        # set to None if type (nullable) is None
        # and model_fields_set contains the field
        if self.type is None and "type" in self.model_fields_set:
            _dict['type'] = None

        # set to None if url (nullable) is None
        # and model_fields_set contains the field
        if self.url is None and "url" in self.model_fields_set:
            _dict['url'] = None

        # set to None if domain (nullable) is None
        # and model_fields_set contains the field
        if self.domain is None and "domain" in self.model_fields_set:
            _dict['domain'] = None

        # set to None if main_domain (nullable) is None
        # and model_fields_set contains the field
        if self.main_domain is None and "main_domain" in self.model_fields_set:
            _dict['main_domain'] = None

        # set to None if url_rank (nullable) is None
        # and model_fields_set contains the field
        if self.url_rank is None and "url_rank" in self.model_fields_set:
            _dict['url_rank'] = None

        # set to None if spam_score (nullable) is None
        # and model_fields_set contains the field
        if self.spam_score is None and "spam_score" in self.model_fields_set:
            _dict['spam_score'] = None

        # set to None if domain_rank (nullable) is None
        # and model_fields_set contains the field
        if self.domain_rank is None and "domain_rank" in self.model_fields_set:
            _dict['domain_rank'] = None

        # set to None if fetch_time (nullable) is None
        # and model_fields_set contains the field
        if self.fetch_time is None and "fetch_time" in self.model_fields_set:
            _dict['fetch_time'] = None

        # set to None if country (nullable) is None
        # and model_fields_set contains the field
        if self.country is None and "country" in self.model_fields_set:
            _dict['country'] = None

        # set to None if language (nullable) is None
        # and model_fields_set contains the field
        if self.language is None and "language" in self.model_fields_set:
            _dict['language'] = None

        # set to None if score (nullable) is None
        # and model_fields_set contains the field
        if self.score is None and "score" in self.model_fields_set:
            _dict['score'] = None

        # set to None if page_category (nullable) is None
        # and model_fields_set contains the field
        if self.page_category is None and "page_category" in self.model_fields_set:
            _dict['page_category'] = None

        # set to None if page_types (nullable) is None
        # and model_fields_set contains the field
        if self.page_types is None and "page_types" in self.model_fields_set:
            _dict['page_types'] = None

        # set to None if ratings (nullable) is None
        # and model_fields_set contains the field
        if self.ratings is None and "ratings" in self.model_fields_set:
            _dict['ratings'] = None

        # set to None if social_metrics (nullable) is None
        # and model_fields_set contains the field
        if self.social_metrics is None and "social_metrics" in self.model_fields_set:
            _dict['social_metrics'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ContentAnalysisSearchLiveItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "type": obj.get("type"),
            "url": obj.get("url"),
            "domain": obj.get("domain"),
            "main_domain": obj.get("main_domain"),
            "url_rank": obj.get("url_rank"),
            "spam_score": obj.get("spam_score"),
            "domain_rank": obj.get("domain_rank"),
            "fetch_time": obj.get("fetch_time"),
            "country": obj.get("country"),
            "language": obj.get("language"),
            "score": obj.get("score"),
            "page_category": obj.get("page_category"),
            "page_types": obj.get("page_types"),
            "ratings": [RatingInfo.from_dict(_item) for _item in obj["ratings"]] if obj.get("ratings") is not None else None,
            "social_metrics": [SocialMetricsInfo.from_dict(_item) for _item in obj["social_metrics"]] if obj.get("social_metrics") is not None else None,
            "content_info": AnalysisContentInfo.from_dict(obj["content_info"]) if obj.get("content_info") is not None else None
        })
        return _obj


