# coding: utf-8

"""
    DataForSEO API documentation

    DataForSEO API is the starting point on your journey towards building powerful SEO software. With DataForSEO you can get all the data you need to build an efficient application while also saving your time and budget. DataForSEO API is using the REST technology for interchanging data between your application and our service. The data exchange is made through the widely used HTTP protocol, which allows applying our API to almost all programming languages.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class ContentGenerationTextSummaryLiveResultInfo(BaseModel):
    """
    ContentGenerationTextSummaryLiveResultInfo
    """ # noqa: E501
    sentences: Optional[StrictInt] = Field(default=None, description="number of sentences found in the target text")
    paragraphs: Optional[StrictInt] = Field(default=None, description="number of paragraphs found in the target text")
    words: Optional[StrictInt] = Field(default=None, description="number of words found in the target text")
    characters_without_spaces: Optional[StrictInt] = Field(default=None, description="number of characters without spaces found in the target text")
    characters_with_spaces: Optional[StrictInt] = Field(default=None, description="number of characters with spaces found in the target text")
    words_per_sentence: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="average number of words per sentence in the target text")
    characters_per_word: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="average number of characters per word in the target text")
    vocabulary_density: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="vocabulary density of the target text")
    keyword_density: Optional[Dict[str, Optional[StrictInt]]] = Field(default=None, description="keyword density of the target text contains most common words and their count")
    automated_readability_index: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Automated Readability Index")
    coleman_liau_index: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Coleman–Liau Index")
    flesch_kincaid_grade_level: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Flesch–Kincaid Readability Index")
    smog_readability_index: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="SMOG Readability Index")
    spelling_errors: Optional[StrictInt] = Field(default=None, description="number of spelling errors found in the target text")
    grammar_errors: Optional[StrictInt] = Field(default=None, description="number of grammar errors found in the target text")
    __properties: ClassVar[List[str]] = ["sentences", "paragraphs", "words", "characters_without_spaces", "characters_with_spaces", "words_per_sentence", "characters_per_word", "vocabulary_density", "keyword_density", "automated_readability_index", "coleman_liau_index", "flesch_kincaid_grade_level", "smog_readability_index", "spelling_errors", "grammar_errors"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ContentGenerationTextSummaryLiveResultInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if sentences (nullable) is None
        # and model_fields_set contains the field
        if self.sentences is None and "sentences" in self.model_fields_set:
            _dict['sentences'] = None

        # set to None if paragraphs (nullable) is None
        # and model_fields_set contains the field
        if self.paragraphs is None and "paragraphs" in self.model_fields_set:
            _dict['paragraphs'] = None

        # set to None if words (nullable) is None
        # and model_fields_set contains the field
        if self.words is None and "words" in self.model_fields_set:
            _dict['words'] = None

        # set to None if characters_without_spaces (nullable) is None
        # and model_fields_set contains the field
        if self.characters_without_spaces is None and "characters_without_spaces" in self.model_fields_set:
            _dict['characters_without_spaces'] = None

        # set to None if characters_with_spaces (nullable) is None
        # and model_fields_set contains the field
        if self.characters_with_spaces is None and "characters_with_spaces" in self.model_fields_set:
            _dict['characters_with_spaces'] = None

        # set to None if words_per_sentence (nullable) is None
        # and model_fields_set contains the field
        if self.words_per_sentence is None and "words_per_sentence" in self.model_fields_set:
            _dict['words_per_sentence'] = None

        # set to None if characters_per_word (nullable) is None
        # and model_fields_set contains the field
        if self.characters_per_word is None and "characters_per_word" in self.model_fields_set:
            _dict['characters_per_word'] = None

        # set to None if vocabulary_density (nullable) is None
        # and model_fields_set contains the field
        if self.vocabulary_density is None and "vocabulary_density" in self.model_fields_set:
            _dict['vocabulary_density'] = None

        # set to None if keyword_density (nullable) is None
        # and model_fields_set contains the field
        if self.keyword_density is None and "keyword_density" in self.model_fields_set:
            _dict['keyword_density'] = None

        # set to None if automated_readability_index (nullable) is None
        # and model_fields_set contains the field
        if self.automated_readability_index is None and "automated_readability_index" in self.model_fields_set:
            _dict['automated_readability_index'] = None

        # set to None if coleman_liau_index (nullable) is None
        # and model_fields_set contains the field
        if self.coleman_liau_index is None and "coleman_liau_index" in self.model_fields_set:
            _dict['coleman_liau_index'] = None

        # set to None if flesch_kincaid_grade_level (nullable) is None
        # and model_fields_set contains the field
        if self.flesch_kincaid_grade_level is None and "flesch_kincaid_grade_level" in self.model_fields_set:
            _dict['flesch_kincaid_grade_level'] = None

        # set to None if smog_readability_index (nullable) is None
        # and model_fields_set contains the field
        if self.smog_readability_index is None and "smog_readability_index" in self.model_fields_set:
            _dict['smog_readability_index'] = None

        # set to None if spelling_errors (nullable) is None
        # and model_fields_set contains the field
        if self.spelling_errors is None and "spelling_errors" in self.model_fields_set:
            _dict['spelling_errors'] = None

        # set to None if grammar_errors (nullable) is None
        # and model_fields_set contains the field
        if self.grammar_errors is None and "grammar_errors" in self.model_fields_set:
            _dict['grammar_errors'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ContentGenerationTextSummaryLiveResultInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "sentences": obj.get("sentences"),
            "paragraphs": obj.get("paragraphs"),
            "words": obj.get("words"),
            "characters_without_spaces": obj.get("characters_without_spaces"),
            "characters_with_spaces": obj.get("characters_with_spaces"),
            "words_per_sentence": obj.get("words_per_sentence"),
            "characters_per_word": obj.get("characters_per_word"),
            "vocabulary_density": obj.get("vocabulary_density"),
            "keyword_density": obj.get("keyword_density"),
            "automated_readability_index": obj.get("automated_readability_index"),
            "coleman_liau_index": obj.get("coleman_liau_index"),
            "flesch_kincaid_grade_level": obj.get("flesch_kincaid_grade_level"),
            "smog_readability_index": obj.get("smog_readability_index"),
            "spelling_errors": obj.get("spelling_errors"),
            "grammar_errors": obj.get("grammar_errors")
        })
        return _obj


