# coding: utf-8

"""
    DataForSEO API documentation

    DataForSEO API is the starting point on your journey towards building powerful SEO software. With DataForSEO you can get all the data you need to build an efficient application while also saving your time and budget. DataForSEO API is using the REST technology for interchanging data between your application and our service. The data exchange is made through the widely used HTTP protocol, which allows applying our API to almost all programming languages.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class DataforseoLabsSerpCompetitorsLiveItem(BaseModel):
    """
    DataforseoLabsSerpCompetitorsLiveItem
    """ # noqa: E501
    se_type: Optional[StrictStr] = Field(default=None, description="search engine type")
    domain: Optional[StrictStr] = Field(default=None, description="domain name of the detected SERP competitor")
    avg_position: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="the average position of the domain for the specified keywords the arithmetic mean of values in the keywords_positions array")
    median_position: Optional[StrictInt] = Field(default=None, description="the median position of the domain for the specified keywords the median of the values in the keywords_positions array")
    rating: Optional[StrictInt] = Field(default=None, description="the margin between the greatest possible and actual keyword positions represents the relative visibility rate of the domain in SERP for the specified keywords calculated as sum(100-keywords_positions)")
    etv: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="estimated traffic volume represents the estimated monthly traffic that specified keywords are driving to the website calculated as the sum of the products of the specified keywords’ search volume values and CTR (click-through-rate) rates at certain positions in SERP learn more about how the metric is calculated in this help center article")
    keywords_count: Optional[StrictInt] = Field(default=None, description="the number of specified keywords the domain has positions for in SERPs")
    visibility: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="SERP visibility rate represents the website visibility rate based on the SERP positions of the specified keywords Keywords with positions in the range from 1 to 10 are assigned the visibility index from 1 to 0.1, respectively Keywords with positions in the range from 11 to 20 have the fixed visibility index of 0.05 keywords with positions from 20 to 100 have the visibility index equal to 0")
    relevant_serp_items: Optional[StrictInt] = Field(default=None, description="the number of SERP elements relevant to the domain represents the number of search results in SERP relevant to the domain for the specified keywords")
    keywords_positions: Optional[Dict[str, Optional[List[Optional[StrictInt]]]]] = Field(default=None, description="keyword positions SERP positions the related domain holds in SERP for the specified keywords")
    __properties: ClassVar[List[str]] = ["se_type", "domain", "avg_position", "median_position", "rating", "etv", "keywords_count", "visibility", "relevant_serp_items", "keywords_positions"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DataforseoLabsSerpCompetitorsLiveItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if se_type (nullable) is None
        # and model_fields_set contains the field
        if self.se_type is None and "se_type" in self.model_fields_set:
            _dict['se_type'] = None

        # set to None if domain (nullable) is None
        # and model_fields_set contains the field
        if self.domain is None and "domain" in self.model_fields_set:
            _dict['domain'] = None

        # set to None if avg_position (nullable) is None
        # and model_fields_set contains the field
        if self.avg_position is None and "avg_position" in self.model_fields_set:
            _dict['avg_position'] = None

        # set to None if median_position (nullable) is None
        # and model_fields_set contains the field
        if self.median_position is None and "median_position" in self.model_fields_set:
            _dict['median_position'] = None

        # set to None if rating (nullable) is None
        # and model_fields_set contains the field
        if self.rating is None and "rating" in self.model_fields_set:
            _dict['rating'] = None

        # set to None if etv (nullable) is None
        # and model_fields_set contains the field
        if self.etv is None and "etv" in self.model_fields_set:
            _dict['etv'] = None

        # set to None if keywords_count (nullable) is None
        # and model_fields_set contains the field
        if self.keywords_count is None and "keywords_count" in self.model_fields_set:
            _dict['keywords_count'] = None

        # set to None if visibility (nullable) is None
        # and model_fields_set contains the field
        if self.visibility is None and "visibility" in self.model_fields_set:
            _dict['visibility'] = None

        # set to None if relevant_serp_items (nullable) is None
        # and model_fields_set contains the field
        if self.relevant_serp_items is None and "relevant_serp_items" in self.model_fields_set:
            _dict['relevant_serp_items'] = None

        # set to None if keywords_positions (nullable) is None
        # and model_fields_set contains the field
        if self.keywords_positions is None and "keywords_positions" in self.model_fields_set:
            _dict['keywords_positions'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DataforseoLabsSerpCompetitorsLiveItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "se_type": obj.get("se_type"),
            "domain": obj.get("domain"),
            "avg_position": obj.get("avg_position"),
            "median_position": obj.get("median_position"),
            "rating": obj.get("rating"),
            "etv": obj.get("etv"),
            "keywords_count": obj.get("keywords_count"),
            "visibility": obj.get("visibility"),
            "relevant_serp_items": obj.get("relevant_serp_items"),
            "keywords_positions": obj.get("keywords_positions")
        })
        return _obj


