# coding: utf-8

"""
    DataForSEO API documentation

    DataForSEO API is the starting point on your journey towards building powerful SEO software. With DataForSEO you can get all the data you need to build an efficient application while also saving your time and budget. DataForSEO API is using the REST technology for interchanging data between your application and our service. The data exchange is made through the widely used HTTP protocol, which allows applying our API to almost all programming languages.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class DomainAnalyticsTechnologiesAggregationTechnologiesLiveItem(BaseModel):
    """
    items array
    """ # noqa: E501
    type: Optional[StrictStr] = Field(default=None, description="type of element")
    group: Optional[StrictStr] = Field(default=None, description="technology group id")
    category: Optional[StrictStr] = Field(default=None, description="technology category id")
    technology: Optional[StrictStr] = Field(default=None, description="technology name")
    groups_count: Optional[StrictInt] = Field(default=None, description="technology groups count number of domains that match the parameters you specified and are using technologies from the indicated group")
    categories_count: Optional[StrictInt] = Field(default=None, description="technology categories count number of domains that match the parameters you specified and are using technologies from the indicated category")
    technologies_count: Optional[StrictInt] = Field(default=None, description="technologies count number of domains that match the parameters you specified and are using the indicated technology")
    __properties: ClassVar[List[str]] = ["type", "group", "category", "technology", "groups_count", "categories_count", "technologies_count"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DomainAnalyticsTechnologiesAggregationTechnologiesLiveItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if type (nullable) is None
        # and model_fields_set contains the field
        if self.type is None and "type" in self.model_fields_set:
            _dict['type'] = None

        # set to None if group (nullable) is None
        # and model_fields_set contains the field
        if self.group is None and "group" in self.model_fields_set:
            _dict['group'] = None

        # set to None if category (nullable) is None
        # and model_fields_set contains the field
        if self.category is None and "category" in self.model_fields_set:
            _dict['category'] = None

        # set to None if technology (nullable) is None
        # and model_fields_set contains the field
        if self.technology is None and "technology" in self.model_fields_set:
            _dict['technology'] = None

        # set to None if groups_count (nullable) is None
        # and model_fields_set contains the field
        if self.groups_count is None and "groups_count" in self.model_fields_set:
            _dict['groups_count'] = None

        # set to None if categories_count (nullable) is None
        # and model_fields_set contains the field
        if self.categories_count is None and "categories_count" in self.model_fields_set:
            _dict['categories_count'] = None

        # set to None if technologies_count (nullable) is None
        # and model_fields_set contains the field
        if self.technologies_count is None and "technologies_count" in self.model_fields_set:
            _dict['technologies_count'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DomainAnalyticsTechnologiesAggregationTechnologiesLiveItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "type": obj.get("type"),
            "group": obj.get("group"),
            "category": obj.get("category"),
            "technology": obj.get("technology"),
            "groups_count": obj.get("groups_count"),
            "categories_count": obj.get("categories_count"),
            "technologies_count": obj.get("technologies_count")
        })
        return _obj


