# coding: utf-8

"""
    DataForSEO API documentation

    DataForSEO API is the starting point on your journey towards building powerful SEO software. With DataForSEO you can get all the data you need to build an efficient application while also saving your time and budget. DataForSEO API is using the REST technology for interchanging data between your application and our service. The data exchange is made through the widely used HTTP protocol, which allows applying our API to almost all programming languages.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class EventDates(BaseModel):
    """
    EventDates
    """ # noqa: E501
    start_datetime: Optional[StrictStr] = Field(default=None, description="date and time when the event starts if time zone is specified in the event, value will be returned in the UTC format: “yyyy-mm-ddThh-mm-ss+00:00” example: 2019-11-15T12:57:46+00:00 if time zone is not specified in the event, unspecified local time will be returned in the following format: “yyyy-mm-ddThh-mm-ss” example: 2019-11-15T12:57:46")
    end_datetime: Optional[StrictStr] = Field(default=None, description="date and time when the event ends if time zone is specified in the event, value will be returned in the UTC format: “yyyy-mm-ddThh-mm-ss+00:00” example: 2019-11-15T12:57:46+00:00 if time zone is not specified in the event, unspecified local time will be returned in the following format: “yyyy-mm-ddThh-mm-ss” example: 2019-11-15T12:57:46")
    displayed_dates: Optional[StrictStr] = Field(default=None, description="date or date range as it is displayed in SERP")
    __properties: ClassVar[List[str]] = ["start_datetime", "end_datetime", "displayed_dates"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EventDates from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if start_datetime (nullable) is None
        # and model_fields_set contains the field
        if self.start_datetime is None and "start_datetime" in self.model_fields_set:
            _dict['start_datetime'] = None

        # set to None if end_datetime (nullable) is None
        # and model_fields_set contains the field
        if self.end_datetime is None and "end_datetime" in self.model_fields_set:
            _dict['end_datetime'] = None

        # set to None if displayed_dates (nullable) is None
        # and model_fields_set contains the field
        if self.displayed_dates is None and "displayed_dates" in self.model_fields_set:
            _dict['displayed_dates'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EventDates from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "start_datetime": obj.get("start_datetime"),
            "end_datetime": obj.get("end_datetime"),
            "displayed_dates": obj.get("displayed_dates")
        })
        return _obj


