# coding: utf-8

"""
    DataForSEO API documentation

    DataForSEO API is the starting point on your journey towards building powerful SEO software. With DataForSEO you can get all the data you need to build an efficient application while also saving your time and budget. DataForSEO API is using the REST technology for interchanging data between your application and our service. The data exchange is made through the widely used HTTP protocol, which allows applying our API to almost all programming languages.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from dataforseo_client.models.other_sites_reviews_info import OtherSitesReviewsInfo
from dataforseo_client.models.review_mention_info import ReviewMentionInfo
from typing import Optional, Set
from typing_extensions import Self

class HotelReviewInfo(BaseModel):
    """
    HotelReviewInfo
    """ # noqa: E501
    value: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="overall hotel rating based on customer votes")
    votes_count: Optional[StrictInt] = Field(default=None, description="number of customer votes the number of customer votes included in the calculation of the hotel rating")
    mentions: Optional[List[ReviewMentionInfo]] = Field(default=None, description="hotel mentions information about hotel reviews by criteria")
    rating_distribution: Optional[Dict[str, Optional[StrictInt]]] = Field(default=None, description="rating distribution by votes the distribution of votes across the rating in the range from 1 to 5")
    other_sites_reviews: Optional[List[OtherSitesReviewsInfo]] = Field(default=None, description="reviews on third-party sites reviews from third-paty sites")
    __properties: ClassVar[List[str]] = ["value", "votes_count", "mentions", "rating_distribution", "other_sites_reviews"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of HotelReviewInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in mentions (list)
        _items = []
        if self.mentions:
            for _item in self.mentions:
                if _item:
                    _items.append(_item.to_dict())
            _dict['mentions'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in other_sites_reviews (list)
        _items = []
        if self.other_sites_reviews:
            for _item in self.other_sites_reviews:
                if _item:
                    _items.append(_item.to_dict())
            _dict['other_sites_reviews'] = _items
        # set to None if value (nullable) is None
        # and model_fields_set contains the field
        if self.value is None and "value" in self.model_fields_set:
            _dict['value'] = None

        # set to None if votes_count (nullable) is None
        # and model_fields_set contains the field
        if self.votes_count is None and "votes_count" in self.model_fields_set:
            _dict['votes_count'] = None

        # set to None if mentions (nullable) is None
        # and model_fields_set contains the field
        if self.mentions is None and "mentions" in self.model_fields_set:
            _dict['mentions'] = None

        # set to None if rating_distribution (nullable) is None
        # and model_fields_set contains the field
        if self.rating_distribution is None and "rating_distribution" in self.model_fields_set:
            _dict['rating_distribution'] = None

        # set to None if other_sites_reviews (nullable) is None
        # and model_fields_set contains the field
        if self.other_sites_reviews is None and "other_sites_reviews" in self.model_fields_set:
            _dict['other_sites_reviews'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of HotelReviewInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "value": obj.get("value"),
            "votes_count": obj.get("votes_count"),
            "mentions": [ReviewMentionInfo.from_dict(_item) for _item in obj["mentions"]] if obj.get("mentions") is not None else None,
            "rating_distribution": obj.get("rating_distribution"),
            "other_sites_reviews": [OtherSitesReviewsInfo.from_dict(_item) for _item in obj["other_sites_reviews"]] if obj.get("other_sites_reviews") is not None else None
        })
        return _obj


