# coding: utf-8

"""
    DataForSEO API documentation

    DataForSEO API is the starting point on your journey towards building powerful SEO software. With DataForSEO you can get all the data you need to build an efficient application while also saving your time and budget. DataForSEO API is using the REST technology for interchanging data between your application and our service. The data exchange is made through the widely used HTTP protocol, which allows applying our API to almost all programming languages.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class HtmlContentInfo(BaseModel):
    """
    HtmlContentInfo
    """ # noqa: E501
    plain_text_size: Optional[StrictInt] = Field(default=None, description="total size of the text on the page measured in bytes")
    plain_text_rate: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="plaintext rate value plain_text_size to size ratio")
    plain_text_word_count: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="number of words on the page")
    automated_readability_index: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Automated Readability Index")
    coleman_liau_readability_index: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Coleman–Liau Index")
    dale_chall_readability_index: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Dale–Chall Readability Index")
    flesch_kincaid_readability_index: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Flesch–Kincaid Readability Index")
    smog_readability_index: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="SMOG Readability Index")
    description_to_content_consistency: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="consistency of the meta description tag with the page content measured from 0 to 1")
    title_to_content_consistency: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="consistency of the meta title tag with the page content measured from 0 to 1")
    meta_keywords_to_content_consistency: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="consistency of meta keywordstag with the page content measured from 0 to 1")
    __properties: ClassVar[List[str]] = ["plain_text_size", "plain_text_rate", "plain_text_word_count", "automated_readability_index", "coleman_liau_readability_index", "dale_chall_readability_index", "flesch_kincaid_readability_index", "smog_readability_index", "description_to_content_consistency", "title_to_content_consistency", "meta_keywords_to_content_consistency"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of HtmlContentInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if plain_text_size (nullable) is None
        # and model_fields_set contains the field
        if self.plain_text_size is None and "plain_text_size" in self.model_fields_set:
            _dict['plain_text_size'] = None

        # set to None if plain_text_rate (nullable) is None
        # and model_fields_set contains the field
        if self.plain_text_rate is None and "plain_text_rate" in self.model_fields_set:
            _dict['plain_text_rate'] = None

        # set to None if plain_text_word_count (nullable) is None
        # and model_fields_set contains the field
        if self.plain_text_word_count is None and "plain_text_word_count" in self.model_fields_set:
            _dict['plain_text_word_count'] = None

        # set to None if automated_readability_index (nullable) is None
        # and model_fields_set contains the field
        if self.automated_readability_index is None and "automated_readability_index" in self.model_fields_set:
            _dict['automated_readability_index'] = None

        # set to None if coleman_liau_readability_index (nullable) is None
        # and model_fields_set contains the field
        if self.coleman_liau_readability_index is None and "coleman_liau_readability_index" in self.model_fields_set:
            _dict['coleman_liau_readability_index'] = None

        # set to None if dale_chall_readability_index (nullable) is None
        # and model_fields_set contains the field
        if self.dale_chall_readability_index is None and "dale_chall_readability_index" in self.model_fields_set:
            _dict['dale_chall_readability_index'] = None

        # set to None if flesch_kincaid_readability_index (nullable) is None
        # and model_fields_set contains the field
        if self.flesch_kincaid_readability_index is None and "flesch_kincaid_readability_index" in self.model_fields_set:
            _dict['flesch_kincaid_readability_index'] = None

        # set to None if smog_readability_index (nullable) is None
        # and model_fields_set contains the field
        if self.smog_readability_index is None and "smog_readability_index" in self.model_fields_set:
            _dict['smog_readability_index'] = None

        # set to None if description_to_content_consistency (nullable) is None
        # and model_fields_set contains the field
        if self.description_to_content_consistency is None and "description_to_content_consistency" in self.model_fields_set:
            _dict['description_to_content_consistency'] = None

        # set to None if title_to_content_consistency (nullable) is None
        # and model_fields_set contains the field
        if self.title_to_content_consistency is None and "title_to_content_consistency" in self.model_fields_set:
            _dict['title_to_content_consistency'] = None

        # set to None if meta_keywords_to_content_consistency (nullable) is None
        # and model_fields_set contains the field
        if self.meta_keywords_to_content_consistency is None and "meta_keywords_to_content_consistency" in self.model_fields_set:
            _dict['meta_keywords_to_content_consistency'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of HtmlContentInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "plain_text_size": obj.get("plain_text_size"),
            "plain_text_rate": obj.get("plain_text_rate"),
            "plain_text_word_count": obj.get("plain_text_word_count"),
            "automated_readability_index": obj.get("automated_readability_index"),
            "coleman_liau_readability_index": obj.get("coleman_liau_readability_index"),
            "dale_chall_readability_index": obj.get("dale_chall_readability_index"),
            "flesch_kincaid_readability_index": obj.get("flesch_kincaid_readability_index"),
            "smog_readability_index": obj.get("smog_readability_index"),
            "description_to_content_consistency": obj.get("description_to_content_consistency"),
            "title_to_content_consistency": obj.get("title_to_content_consistency"),
            "meta_keywords_to_content_consistency": obj.get("meta_keywords_to_content_consistency")
        })
        return _obj


