# coding: utf-8

"""
    DataForSEO API documentation

    DataForSEO API is the starting point on your journey towards building powerful SEO software. With DataForSEO you can get all the data you need to build an efficient application while also saving your time and budget. DataForSEO API is using the REST technology for interchanging data between your application and our service. The data exchange is made through the widely used HTTP protocol, which allows applying our API to almost all programming languages.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class KeywordKpiInfo(BaseModel):
    """
    KeywordKpiInfo
    """ # noqa: E501
    ad_position: Optional[StrictStr] = Field(default=None, description="represents the position of the relevant ad in SERP can take the following values: FirstPage1: The first ad to appear on the right side of the first search results page FirstPage2: The second ad to appear on the right side of the first search results page FirstPage3: The third ad to appear on the right side of the first search results page FirstPage4: The fourth ad to appear on the right side of the first search results page FirstPage5: The fifth ad to appear on the right side of the first search results page FirstPage6: The sixth ad to appear on the right side of the first search results page FirstPage7: The seventh ad to appear on the right side of the first search results page FirstPage8: The eighth ad to appear on the right side of the first search results page FirstPage9: The ninth ad to appear on the right side of the first search results page FirstPage10: The tenth ad to appear on the right side of the first search results page MainLine1: The first ad to appear at the top of the search results page MainLine2: The second ad to appear at the top of the search results page MainLine3: The third ad to appear at the top of the search results page MainLine4: The fourth ad to appear at the top of the search results page")
    clicks: Optional[StrictInt] = Field(default=None, description="ad clicks the number of clicks that the keyword and match type generated during the last month")
    impressions: Optional[StrictInt] = Field(default=None, description="ad impressions the number of impressions that the keyword and match type generated during the last month")
    average_cpc: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="average cost per click, USD calculated by dividing the cost of all clicks by the number of clicks")
    ctr: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="click-through rate as a percentage calculated by dividing the number of clicks by the number of impressions and multiplying the result by 100")
    total_cost: Optional[StrictInt] = Field(default=None, description="total cost of an ad, USD the cost of using the specified keyword and match type during the last month")
    average_bid: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="average bid of the keyword")
    __properties: ClassVar[List[str]] = ["ad_position", "clicks", "impressions", "average_cpc", "ctr", "total_cost", "average_bid"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of KeywordKpiInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if ad_position (nullable) is None
        # and model_fields_set contains the field
        if self.ad_position is None and "ad_position" in self.model_fields_set:
            _dict['ad_position'] = None

        # set to None if clicks (nullable) is None
        # and model_fields_set contains the field
        if self.clicks is None and "clicks" in self.model_fields_set:
            _dict['clicks'] = None

        # set to None if impressions (nullable) is None
        # and model_fields_set contains the field
        if self.impressions is None and "impressions" in self.model_fields_set:
            _dict['impressions'] = None

        # set to None if average_cpc (nullable) is None
        # and model_fields_set contains the field
        if self.average_cpc is None and "average_cpc" in self.model_fields_set:
            _dict['average_cpc'] = None

        # set to None if ctr (nullable) is None
        # and model_fields_set contains the field
        if self.ctr is None and "ctr" in self.model_fields_set:
            _dict['ctr'] = None

        # set to None if total_cost (nullable) is None
        # and model_fields_set contains the field
        if self.total_cost is None and "total_cost" in self.model_fields_set:
            _dict['total_cost'] = None

        # set to None if average_bid (nullable) is None
        # and model_fields_set contains the field
        if self.average_bid is None and "average_bid" in self.model_fields_set:
            _dict['average_bid'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of KeywordKpiInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "ad_position": obj.get("ad_position"),
            "clicks": obj.get("clicks"),
            "impressions": obj.get("impressions"),
            "average_cpc": obj.get("average_cpc"),
            "ctr": obj.get("ctr"),
            "total_cost": obj.get("total_cost"),
            "average_bid": obj.get("average_bid")
        })
        return _obj


