# coding: utf-8

"""
    DataForSEO API documentation

    DataForSEO API is the starting point on your journey towards building powerful SEO software. With DataForSEO you can get all the data you need to build an efficient application while also saving your time and budget. DataForSEO API is using the REST technology for interchanging data between your application and our service. The data exchange is made through the widely used HTTP protocol, which allows applying our API to almost all programming languages.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class KeywordProperties(BaseModel):
    """
    KeywordProperties
    """ # noqa: E501
    se_type: Optional[StrictStr] = Field(default=None, description="search engine type")
    core_keyword: Optional[StrictStr] = Field(default=None, description="main keyword in a group contains the main keyword in a group determined by the synonym clustering algorithm if the value is null, our database does not contain any keywords the corresponding algorithm could identify as synonymous with keyword")
    synonym_clustering_algorithm: Optional[StrictStr] = Field(default=None, description="the algorithm used to identify synonyms possible values: keyword_metrics – indicates the algorithm based on keyword_info parameters text_processing – indicates the text-based algorithm if the value is null, our database does not contain any keywords the corresponding algorithm could identify as synonymous with keyword")
    keyword_difficulty: Optional[StrictInt] = Field(default=None, description="difficulty of ranking in the first top-10 organic results for a keyword indicates the chance of getting in top-10 organic results for a keyword on a logarithmic scale from 0 to 100; calculated by analysing, among other parameters, link profiles of the first 10 pages in SERP; learn more about the metric in this help center guide")
    detected_language: Optional[StrictStr] = Field(default=None, description="detected language of the keyword indicates the language of the keyword as identified by our system")
    is_another_language: Optional[StrictBool] = Field(default=None, description="detected language of the keyword is different from the set language if true, the language set in the request does not match the language determined by our system for a given keyword")
    __properties: ClassVar[List[str]] = ["se_type", "core_keyword", "synonym_clustering_algorithm", "keyword_difficulty", "detected_language", "is_another_language"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of KeywordProperties from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if se_type (nullable) is None
        # and model_fields_set contains the field
        if self.se_type is None and "se_type" in self.model_fields_set:
            _dict['se_type'] = None

        # set to None if core_keyword (nullable) is None
        # and model_fields_set contains the field
        if self.core_keyword is None and "core_keyword" in self.model_fields_set:
            _dict['core_keyword'] = None

        # set to None if synonym_clustering_algorithm (nullable) is None
        # and model_fields_set contains the field
        if self.synonym_clustering_algorithm is None and "synonym_clustering_algorithm" in self.model_fields_set:
            _dict['synonym_clustering_algorithm'] = None

        # set to None if keyword_difficulty (nullable) is None
        # and model_fields_set contains the field
        if self.keyword_difficulty is None and "keyword_difficulty" in self.model_fields_set:
            _dict['keyword_difficulty'] = None

        # set to None if detected_language (nullable) is None
        # and model_fields_set contains the field
        if self.detected_language is None and "detected_language" in self.model_fields_set:
            _dict['detected_language'] = None

        # set to None if is_another_language (nullable) is None
        # and model_fields_set contains the field
        if self.is_another_language is None and "is_another_language" in self.model_fields_set:
            _dict['is_another_language'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of KeywordProperties from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "se_type": obj.get("se_type"),
            "core_keyword": obj.get("core_keyword"),
            "synonym_clustering_algorithm": obj.get("synonym_clustering_algorithm"),
            "keyword_difficulty": obj.get("keyword_difficulty"),
            "detected_language": obj.get("detected_language"),
            "is_another_language": obj.get("is_another_language")
        })
        return _obj


