# coding: utf-8

"""
    DataForSEO API documentation

    DataForSEO API is the starting point on your journey towards building powerful SEO software. With DataForSEO you can get all the data you need to build an efficient application while also saving your time and budget. DataForSEO API is using the REST technology for interchanging data between your application and our service. The data exchange is made through the widely used HTTP protocol, which allows applying our API to almost all programming languages.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class KeywordsDataGoogleAdsAdTrafficByKeywordsTaskGetResultInfo(BaseModel):
    """
    KeywordsDataGoogleAdsAdTrafficByKeywordsTaskGetResultInfo
    """ # noqa: E501
    keyword: Optional[StrictStr] = Field(default=None, description="keyword in a POST array metrics are provided for all the keywords specified in the POST array")
    location_code: Optional[StrictInt] = Field(default=None, description="location code in a POST array if there is no data, then the value is null")
    language_code: Optional[StrictStr] = Field(default=None, description="language code in a POST array if there is no data, then the value is null")
    date_interval: Optional[StrictStr] = Field(default=None, description="forecasting date interval in a POST array")
    search_partners: Optional[StrictBool] = Field(default=None, description="include Google search partners the value you specified when setting the task if true, the results are returned for owned, operated, and syndicated networks across Google and partner sites that host Google search; if false, the results are returned for Google search sites only")
    bid: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="the maximum custom bid the bid you have specified when setting the task represents the price you are willing to pay for an ad the higher value you have specified, the higher metrics and cost you receive in response learn more in this help center article")
    match: Optional[StrictStr] = Field(default=None, description="keywords match-type can take the following values: exact, broad, phrase")
    impressions: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="projected number of ad impressions number of impressions an ad is projected to get within the specified time period if there is no data, then the value is null learn more about impressions in this help center article")
    ctr: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="projected clickthrough rate (CTR) of the advertisement number of clicks an ad is projected to receive divided by the number of ad impressions; the CTR is projected for the specified time period if there is no data, then the value is null")
    average_cpc: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="the average cost-per-click value represents the cost-per-click (USD) estimated for a keyword based on the specified time period and historical data; if there is no data, then the value is null")
    cost: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="charge for an ad amount that will be charged for running an ad within the specified time period if there is no data, then the value is null")
    clicks: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="number of clicks on an ad number of clicks an ad is projected to get within the specified time period if there is no data, then the value is null")
    __properties: ClassVar[List[str]] = ["keyword", "location_code", "language_code", "date_interval", "search_partners", "bid", "match", "impressions", "ctr", "average_cpc", "cost", "clicks"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of KeywordsDataGoogleAdsAdTrafficByKeywordsTaskGetResultInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if keyword (nullable) is None
        # and model_fields_set contains the field
        if self.keyword is None and "keyword" in self.model_fields_set:
            _dict['keyword'] = None

        # set to None if location_code (nullable) is None
        # and model_fields_set contains the field
        if self.location_code is None and "location_code" in self.model_fields_set:
            _dict['location_code'] = None

        # set to None if language_code (nullable) is None
        # and model_fields_set contains the field
        if self.language_code is None and "language_code" in self.model_fields_set:
            _dict['language_code'] = None

        # set to None if date_interval (nullable) is None
        # and model_fields_set contains the field
        if self.date_interval is None and "date_interval" in self.model_fields_set:
            _dict['date_interval'] = None

        # set to None if search_partners (nullable) is None
        # and model_fields_set contains the field
        if self.search_partners is None and "search_partners" in self.model_fields_set:
            _dict['search_partners'] = None

        # set to None if bid (nullable) is None
        # and model_fields_set contains the field
        if self.bid is None and "bid" in self.model_fields_set:
            _dict['bid'] = None

        # set to None if match (nullable) is None
        # and model_fields_set contains the field
        if self.match is None and "match" in self.model_fields_set:
            _dict['match'] = None

        # set to None if impressions (nullable) is None
        # and model_fields_set contains the field
        if self.impressions is None and "impressions" in self.model_fields_set:
            _dict['impressions'] = None

        # set to None if ctr (nullable) is None
        # and model_fields_set contains the field
        if self.ctr is None and "ctr" in self.model_fields_set:
            _dict['ctr'] = None

        # set to None if average_cpc (nullable) is None
        # and model_fields_set contains the field
        if self.average_cpc is None and "average_cpc" in self.model_fields_set:
            _dict['average_cpc'] = None

        # set to None if cost (nullable) is None
        # and model_fields_set contains the field
        if self.cost is None and "cost" in self.model_fields_set:
            _dict['cost'] = None

        # set to None if clicks (nullable) is None
        # and model_fields_set contains the field
        if self.clicks is None and "clicks" in self.model_fields_set:
            _dict['clicks'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of KeywordsDataGoogleAdsAdTrafficByKeywordsTaskGetResultInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "keyword": obj.get("keyword"),
            "location_code": obj.get("location_code"),
            "language_code": obj.get("language_code"),
            "date_interval": obj.get("date_interval"),
            "search_partners": obj.get("search_partners"),
            "bid": obj.get("bid"),
            "match": obj.get("match"),
            "impressions": obj.get("impressions"),
            "ctr": obj.get("ctr"),
            "average_cpc": obj.get("average_cpc"),
            "cost": obj.get("cost"),
            "clicks": obj.get("clicks")
        })
        return _obj


