# coding: utf-8

"""
    DataForSEO API documentation

    DataForSEO API is the starting point on your journey towards building powerful SEO software. With DataForSEO you can get all the data you need to build an efficient application while also saving your time and budget. DataForSEO API is using the REST technology for interchanging data between your application and our service. The data exchange is made through the widely used HTTP protocol, which allows applying our API to almost all programming languages.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class KeywordsDataGoogleAdsStatusResultInfo(BaseModel):
    """
    KeywordsDataGoogleAdsStatusResultInfo
    """ # noqa: E501
    actual_data: Optional[StrictBool] = Field(default=None, description="indicates whether Google updated keyword data for the previous month generally, Google updates keyword data in the middle of the month if the value is true, Google currently provides up-to-date data for the previous month if the value is false, we are not able to provide data for the previous month")
    date_update: Optional[StrictStr] = Field(default=None, description="date of the latest update of Google Ads data indicates the latest date when Google updated search volume, CPC, and other keyword metrics example: 2020-05-15")
    last_year_in_monthly_searches: Optional[StrictInt] = Field(default=None, description="the latest year for which search volume data is available")
    last_month_in_monthly_searches: Optional[StrictInt] = Field(default=None, description="the latest month for which search volume data is available")
    __properties: ClassVar[List[str]] = ["actual_data", "date_update", "last_year_in_monthly_searches", "last_month_in_monthly_searches"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of KeywordsDataGoogleAdsStatusResultInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if actual_data (nullable) is None
        # and model_fields_set contains the field
        if self.actual_data is None and "actual_data" in self.model_fields_set:
            _dict['actual_data'] = None

        # set to None if date_update (nullable) is None
        # and model_fields_set contains the field
        if self.date_update is None and "date_update" in self.model_fields_set:
            _dict['date_update'] = None

        # set to None if last_year_in_monthly_searches (nullable) is None
        # and model_fields_set contains the field
        if self.last_year_in_monthly_searches is None and "last_year_in_monthly_searches" in self.model_fields_set:
            _dict['last_year_in_monthly_searches'] = None

        # set to None if last_month_in_monthly_searches (nullable) is None
        # and model_fields_set contains the field
        if self.last_month_in_monthly_searches is None and "last_month_in_monthly_searches" in self.model_fields_set:
            _dict['last_month_in_monthly_searches'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of KeywordsDataGoogleAdsStatusResultInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "actual_data": obj.get("actual_data"),
            "date_update": obj.get("date_update"),
            "last_year_in_monthly_searches": obj.get("last_year_in_monthly_searches"),
            "last_month_in_monthly_searches": obj.get("last_month_in_monthly_searches")
        })
        return _obj


