# coding: utf-8

"""
    DataForSEO API documentation

    DataForSEO API is the starting point on your journey towards building powerful SEO software. With DataForSEO you can get all the data you need to build an efficient application while also saving your time and budget. DataForSEO API is using the REST technology for interchanging data between your application and our service. The data exchange is made through the widely used HTTP protocol, which allows applying our API to almost all programming languages.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from dataforseo_client.models.base_merchant_serp_element_item import BaseMerchantSerpElementItem
from dataforseo_client.models.product_seller import ProductSeller
from dataforseo_client.models.product_variation import ProductVariation
from dataforseo_client.models.rating_element import RatingElement
from typing import Optional, Set
from typing_extensions import Self

class ProductInfoElementMerchantSerpElementItem(BaseMerchantSerpElementItem):
    """
    ProductInfoElementMerchantSerpElementItem
    """ # noqa: E501
    rank_group: Optional[StrictInt] = Field(default=None, description="position within a group of elements with identical type values positions of elements with different type values are omitted from rank_group")
    rank_absolute: Optional[StrictInt] = Field(default=None, description="absolute rank on the product specification page absolute position among all the elements found on the product specification page")
    position: Optional[StrictStr] = Field(default=None, description="alignment of the element on the product specification page can take the following values: right, left")
    product_id: Optional[StrictStr] = Field(default=None, description="product_id received in a POST array ilearn more about the parameter in this help center guide")
    title: Optional[StrictStr] = Field(default=None, description="title of the product")
    description: Optional[StrictStr] = Field(default=None, description="description of the product")
    url: Optional[StrictStr] = Field(default=None, description="product url url of the product on Google Shopping")
    images: Optional[List[Optional[StrictStr]]] = Field(default=None, description="product images contains urls to product images")
    features: Optional[List[Optional[StrictStr]]] = Field(default=None, description="product features contains snippets with the description of product features")
    rating: Optional[RatingElement] = None
    seller_reviews_count: Optional[StrictInt] = Field(default=None, description="number of seller reviews number of reviews on the product seller’s account")
    sellers: Optional[List[ProductSeller]] = Field(default=None, description="sellers of the product number of reviews on the product seller’s account")
    variations: Optional[List[ProductVariation]] = Field(default=None, description="variations of the product contains brief information about different product variations")
    __properties: ClassVar[List[str]] = ["type", "rank_group", "rank_absolute", "position", "product_id", "title", "description", "url", "images", "features", "rating", "seller_reviews_count", "sellers", "variations"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ProductInfoElementMerchantSerpElementItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of rating
        if self.rating:
            _dict['rating'] = self.rating.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in sellers (list)
        _items = []
        if self.sellers:
            for _item in self.sellers:
                if _item:
                    _items.append(_item.to_dict())
            _dict['sellers'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in variations (list)
        _items = []
        if self.variations:
            for _item in self.variations:
                if _item:
                    _items.append(_item.to_dict())
            _dict['variations'] = _items
        # set to None if type (nullable) is None
        # and model_fields_set contains the field
        if self.type is None and "type" in self.model_fields_set:
            _dict['type'] = None

        # set to None if rank_group (nullable) is None
        # and model_fields_set contains the field
        if self.rank_group is None and "rank_group" in self.model_fields_set:
            _dict['rank_group'] = None

        # set to None if rank_absolute (nullable) is None
        # and model_fields_set contains the field
        if self.rank_absolute is None and "rank_absolute" in self.model_fields_set:
            _dict['rank_absolute'] = None

        # set to None if position (nullable) is None
        # and model_fields_set contains the field
        if self.position is None and "position" in self.model_fields_set:
            _dict['position'] = None

        # set to None if product_id (nullable) is None
        # and model_fields_set contains the field
        if self.product_id is None and "product_id" in self.model_fields_set:
            _dict['product_id'] = None

        # set to None if title (nullable) is None
        # and model_fields_set contains the field
        if self.title is None and "title" in self.model_fields_set:
            _dict['title'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if url (nullable) is None
        # and model_fields_set contains the field
        if self.url is None and "url" in self.model_fields_set:
            _dict['url'] = None

        # set to None if images (nullable) is None
        # and model_fields_set contains the field
        if self.images is None and "images" in self.model_fields_set:
            _dict['images'] = None

        # set to None if features (nullable) is None
        # and model_fields_set contains the field
        if self.features is None and "features" in self.model_fields_set:
            _dict['features'] = None

        # set to None if seller_reviews_count (nullable) is None
        # and model_fields_set contains the field
        if self.seller_reviews_count is None and "seller_reviews_count" in self.model_fields_set:
            _dict['seller_reviews_count'] = None

        # set to None if sellers (nullable) is None
        # and model_fields_set contains the field
        if self.sellers is None and "sellers" in self.model_fields_set:
            _dict['sellers'] = None

        # set to None if variations (nullable) is None
        # and model_fields_set contains the field
        if self.variations is None and "variations" in self.model_fields_set:
            _dict['variations'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ProductInfoElementMerchantSerpElementItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "type": obj.get("type"),
            "rank_group": obj.get("rank_group"),
            "rank_absolute": obj.get("rank_absolute"),
            "position": obj.get("position"),
            "product_id": obj.get("product_id"),
            "title": obj.get("title"),
            "description": obj.get("description"),
            "url": obj.get("url"),
            "images": obj.get("images"),
            "features": obj.get("features"),
            "rating": RatingElement.from_dict(obj["rating"]) if obj.get("rating") is not None else None,
            "seller_reviews_count": obj.get("seller_reviews_count"),
            "sellers": [ProductSeller.from_dict(_item) for _item in obj["sellers"]] if obj.get("sellers") is not None else None,
            "variations": [ProductVariation.from_dict(_item) for _item in obj["variations"]] if obj.get("variations") is not None else None
        })
        return _obj


