# coding: utf-8

"""
    DataForSEO API documentation

    DataForSEO API is the starting point on your journey towards building powerful SEO software. With DataForSEO you can get all the data you need to build an efficient application while also saving your time and budget. DataForSEO API is using the REST technology for interchanging data between your application and our service. The data exchange is made through the widely used HTTP protocol, which allows applying our API to almost all programming languages.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class ScoreByCategories(BaseModel):
    """
    ScoreByCategories
    """ # noqa: E501
    overall: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="overall score of the hotel location indicates the overall score of the hotel’s location in the range from 1 to 5; calculated based on data from the hotel’s proximity to nearby things to do and restaurants, transportation, and airports; note that the criteria are not weighted equally in the overall score")
    things_to_do: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="score relative to nearby things to do indicates the score of the hotel’s location in the range from 1 to 5; calculated based on data from the hotel’s proximity to nearby things to do")
    restaurants: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="score relative to nearby restaurants indicates the score of the hotel’s location in the range from 1 to 5; calculated based on data from the hotel’s proximity to nearby restaurants")
    transit: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="score relative to nearby transit options indicates the score of the hotel’s location in the range from 1 to 5; calculated based on data from the hotel’s proximity to nearby transit options")
    airport_access: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="score relative to nearby airports indicates the score of the hotel’s location in the range from 1 to 5; calculated based on data from the hotel’s proximity to nearby airports")
    __properties: ClassVar[List[str]] = ["overall", "things_to_do", "restaurants", "transit", "airport_access"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ScoreByCategories from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if overall (nullable) is None
        # and model_fields_set contains the field
        if self.overall is None and "overall" in self.model_fields_set:
            _dict['overall'] = None

        # set to None if things_to_do (nullable) is None
        # and model_fields_set contains the field
        if self.things_to_do is None and "things_to_do" in self.model_fields_set:
            _dict['things_to_do'] = None

        # set to None if restaurants (nullable) is None
        # and model_fields_set contains the field
        if self.restaurants is None and "restaurants" in self.model_fields_set:
            _dict['restaurants'] = None

        # set to None if transit (nullable) is None
        # and model_fields_set contains the field
        if self.transit is None and "transit" in self.model_fields_set:
            _dict['transit'] = None

        # set to None if airport_access (nullable) is None
        # and model_fields_set contains the field
        if self.airport_access is None and "airport_access" in self.model_fields_set:
            _dict['airport_access'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ScoreByCategories from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "overall": obj.get("overall"),
            "things_to_do": obj.get("things_to_do"),
            "restaurants": obj.get("restaurants"),
            "transit": obj.get("transit"),
            "airport_access": obj.get("airport_access")
        })
        return _obj


