# coding: utf-8

"""
    DataForSEO API documentation

    DataForSEO API is the starting point on your journey towards building powerful SEO software. With DataForSEO you can get all the data you need to build an efficient application while also saving your time and budget. DataForSEO API is using the REST technology for interchanging data between your application and our service. The data exchange is made through the widely used HTTP protocol, which allows applying our API to almost all programming languages.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, Field
from typing import Any, ClassVar, Dict, List, Optional
from dataforseo_client.models.search_volume_history_item_info import SearchVolumeHistoryItemInfo
from typing import Optional, Set
from typing_extensions import Self

class SearchVolumeHistorySearchInfo(BaseModel):
    """
    SearchVolumeHistorySearchInfo
    """ # noqa: E501
    desktop: Optional[List[SearchVolumeHistoryItemInfo]] = Field(default=None, description="device type = desktop contains historical search volume data for searches made from desktop devices")
    non_smartphones: Optional[List[SearchVolumeHistoryItemInfo]] = Field(default=None, description="device type = non-smartphones contains historical search volume data for searches made from feature phones (non-smartphone mobile devices)")
    mobile: Optional[List[SearchVolumeHistoryItemInfo]] = Field(default=None, description="device type = mobile contains historical search volume data for searches made from mobile devices")
    tablet: Optional[List[SearchVolumeHistoryItemInfo]] = Field(default=None, description="device type = tablet contains historical search volume data for searches made from tablets")
    __properties: ClassVar[List[str]] = ["desktop", "non_smartphones", "mobile", "tablet"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SearchVolumeHistorySearchInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in desktop (list)
        _items = []
        if self.desktop:
            for _item in self.desktop:
                if _item:
                    _items.append(_item.to_dict())
            _dict['desktop'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in non_smartphones (list)
        _items = []
        if self.non_smartphones:
            for _item in self.non_smartphones:
                if _item:
                    _items.append(_item.to_dict())
            _dict['non_smartphones'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in mobile (list)
        _items = []
        if self.mobile:
            for _item in self.mobile:
                if _item:
                    _items.append(_item.to_dict())
            _dict['mobile'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in tablet (list)
        _items = []
        if self.tablet:
            for _item in self.tablet:
                if _item:
                    _items.append(_item.to_dict())
            _dict['tablet'] = _items
        # set to None if desktop (nullable) is None
        # and model_fields_set contains the field
        if self.desktop is None and "desktop" in self.model_fields_set:
            _dict['desktop'] = None

        # set to None if non_smartphones (nullable) is None
        # and model_fields_set contains the field
        if self.non_smartphones is None and "non_smartphones" in self.model_fields_set:
            _dict['non_smartphones'] = None

        # set to None if mobile (nullable) is None
        # and model_fields_set contains the field
        if self.mobile is None and "mobile" in self.model_fields_set:
            _dict['mobile'] = None

        # set to None if tablet (nullable) is None
        # and model_fields_set contains the field
        if self.tablet is None and "tablet" in self.model_fields_set:
            _dict['tablet'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SearchVolumeHistorySearchInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "desktop": [SearchVolumeHistoryItemInfo.from_dict(_item) for _item in obj["desktop"]] if obj.get("desktop") is not None else None,
            "non_smartphones": [SearchVolumeHistoryItemInfo.from_dict(_item) for _item in obj["non_smartphones"]] if obj.get("non_smartphones") is not None else None,
            "mobile": [SearchVolumeHistoryItemInfo.from_dict(_item) for _item in obj["mobile"]] if obj.get("mobile") is not None else None,
            "tablet": [SearchVolumeHistoryItemInfo.from_dict(_item) for _item in obj["tablet"]] if obj.get("tablet") is not None else None
        })
        return _obj


