# coding: utf-8

"""
    DataForSEO API documentation

    DataForSEO API is the starting point on your journey towards building powerful SEO software. With DataForSEO you can get all the data you need to build an efficient application while also saving your time and budget. DataForSEO API is using the REST technology for interchanging data between your application and our service. The data exchange is made through the widely used HTTP protocol, which allows applying our API to almost all programming languages.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class SerpAiSummaryRequestInfo(BaseModel):
    """
    SerpAiSummaryRequestInfo
    """ # noqa: E501
    task_id: Optional[StrictStr] = Field(default=None, description="task identifier required field unique identifier of the associated task in the UUID format you will be able to use it within 30 days to request the results of the task at any time")
    prompt: Optional[StrictStr] = Field(default=None, description="AI prompt optional field additional task for AI summariser; any form of text, question or information that communicates to AI what response you’re looking for; max number of symbols or characters you can specify: 2000; note: your prompt has to be relevant to the keyword specified in the POST request to SERP API")
    support_extra: Optional[StrictBool] = Field(default=None, description="support extra SERP features optional field if set to true, the AI model will consider the following extra SERP features, in addition to organic results: answer_box, knowledge_graph, featured_snippet; default value: true")
    fetch_content: Optional[StrictBool] = Field(default=None, description="fetch content from pages in SERPs optional field if set to true, the API will fetch the content from pages featured in SERP results, and the AI model will consider this content when generating the summary in the result; default value: false")
    include_links: Optional[StrictBool] = Field(default=None, description="include source links in the summary optional field if set to true, the summary field in the API response will contain links to sources of the generated summary; default value: false")
    __properties: ClassVar[List[str]] = ["task_id", "prompt", "support_extra", "fetch_content", "include_links"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SerpAiSummaryRequestInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if prompt (nullable) is None
        # and model_fields_set contains the field
        if self.prompt is None and "prompt" in self.model_fields_set:
            _dict['prompt'] = None

        # set to None if support_extra (nullable) is None
        # and model_fields_set contains the field
        if self.support_extra is None and "support_extra" in self.model_fields_set:
            _dict['support_extra'] = None

        # set to None if fetch_content (nullable) is None
        # and model_fields_set contains the field
        if self.fetch_content is None and "fetch_content" in self.model_fields_set:
            _dict['fetch_content'] = None

        # set to None if include_links (nullable) is None
        # and model_fields_set contains the field
        if self.include_links is None and "include_links" in self.model_fields_set:
            _dict['include_links'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SerpAiSummaryRequestInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "task_id": obj.get("task_id"),
            "prompt": obj.get("prompt"),
            "support_extra": obj.get("support_extra"),
            "fetch_content": obj.get("fetch_content"),
            "include_links": obj.get("include_links")
        })
        return _obj


