# coding: utf-8

"""
    DataForSEO API documentation

    DataForSEO API is the starting point on your journey towards building powerful SEO software. With DataForSEO you can get all the data you need to build an efficient application while also saving your time and budget. DataForSEO API is using the REST technology for interchanging data between your application and our service. The data exchange is made through the widely used HTTP protocol, which allows applying our API to almost all programming languages.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, Field
from typing import Any, ClassVar, Dict, List, Optional
from dataforseo_client.models.table_content_item_info import TableContentItemInfo
from typing import Optional, Set
from typing_extensions import Self

class TableContent(BaseModel):
    """
    TableContent
    """ # noqa: E501
    header: Optional[List[TableContentItemInfo]] = Field(default=None, description="parsed content of the header")
    body: Optional[List[TableContentItemInfo]] = Field(default=None, description="content of the body of the table")
    footer: Optional[List[TableContentItemInfo]] = Field(default=None, description="content of the footer of the table")
    __properties: ClassVar[List[str]] = ["header", "body", "footer"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TableContent from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in header (list)
        _items = []
        if self.header:
            for _item in self.header:
                if _item:
                    _items.append(_item.to_dict())
            _dict['header'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in body (list)
        _items = []
        if self.body:
            for _item in self.body:
                if _item:
                    _items.append(_item.to_dict())
            _dict['body'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in footer (list)
        _items = []
        if self.footer:
            for _item in self.footer:
                if _item:
                    _items.append(_item.to_dict())
            _dict['footer'] = _items
        # set to None if header (nullable) is None
        # and model_fields_set contains the field
        if self.header is None and "header" in self.model_fields_set:
            _dict['header'] = None

        # set to None if body (nullable) is None
        # and model_fields_set contains the field
        if self.body is None and "body" in self.model_fields_set:
            _dict['body'] = None

        # set to None if footer (nullable) is None
        # and model_fields_set contains the field
        if self.footer is None and "footer" in self.model_fields_set:
            _dict['footer'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TableContent from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "header": [TableContentItemInfo.from_dict(_item) for _item in obj["header"]] if obj.get("header") is not None else None,
            "body": [TableContentItemInfo.from_dict(_item) for _item in obj["body"]] if obj.get("body") is not None else None,
            "footer": [TableContentItemInfo.from_dict(_item) for _item in obj["footer"]] if obj.get("footer") is not None else None
        })
        return _obj


