# coding: utf-8

"""
    DataForSEO API documentation

    DataForSEO API is the starting point on your journey towards building powerful SEO software. With DataForSEO you can get all the data you need to build an efficient application while also saving your time and budget. DataForSEO API is using the REST technology for interchanging data between your application and our service. The data exchange is made through the widely used HTTP protocol, which allows applying our API to almost all programming languages.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class TargetInfo(BaseModel):
    """
    TargetInfo
    """ # noqa: E501
    server: Optional[StrictStr] = Field(default=None, description="server")
    cms: Optional[StrictStr] = Field(default=None, description="content management system")
    platform_type: Optional[List[Optional[StrictStr]]] = Field(default=None, description="platform type")
    ip_address: Optional[StrictStr] = Field(default=None, description="IP address of the target")
    country: Optional[StrictStr] = Field(default=None, description="country code that the target domain is determined to belong to")
    is_ip: Optional[StrictBool] = Field(default=None, description="indicates if the target is IP if true, the domain, subdomain or webpage functions as an IP address and does not have a domain name")
    target_spam_score: Optional[StrictInt] = Field(default=None, description="spam score of the target if the target is a domain/subdomain, this fields indicates the average spam score of all pages of that domain/subdomain; learn more about how the metric is calculated on this help center page")
    __properties: ClassVar[List[str]] = ["server", "cms", "platform_type", "ip_address", "country", "is_ip", "target_spam_score"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TargetInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if server (nullable) is None
        # and model_fields_set contains the field
        if self.server is None and "server" in self.model_fields_set:
            _dict['server'] = None

        # set to None if cms (nullable) is None
        # and model_fields_set contains the field
        if self.cms is None and "cms" in self.model_fields_set:
            _dict['cms'] = None

        # set to None if platform_type (nullable) is None
        # and model_fields_set contains the field
        if self.platform_type is None and "platform_type" in self.model_fields_set:
            _dict['platform_type'] = None

        # set to None if ip_address (nullable) is None
        # and model_fields_set contains the field
        if self.ip_address is None and "ip_address" in self.model_fields_set:
            _dict['ip_address'] = None

        # set to None if country (nullable) is None
        # and model_fields_set contains the field
        if self.country is None and "country" in self.model_fields_set:
            _dict['country'] = None

        # set to None if is_ip (nullable) is None
        # and model_fields_set contains the field
        if self.is_ip is None and "is_ip" in self.model_fields_set:
            _dict['is_ip'] = None

        # set to None if target_spam_score (nullable) is None
        # and model_fields_set contains the field
        if self.target_spam_score is None and "target_spam_score" in self.model_fields_set:
            _dict['target_spam_score'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TargetInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "server": obj.get("server"),
            "cms": obj.get("cms"),
            "platform_type": obj.get("platform_type"),
            "ip_address": obj.get("ip_address"),
            "country": obj.get("country"),
            "is_ip": obj.get("is_ip"),
            "target_spam_score": obj.get("target_spam_score")
        })
        return _obj


