# coding: utf-8

"""
    DataForSEO API documentation

    DataForSEO API is the starting point on your journey towards building powerful SEO software. With DataForSEO you can get all the data you need to build an efficient application while also saving your time and budget. DataForSEO API is using the REST technology for interchanging data between your application and our service. The data exchange is made through the widely used HTTP protocol, which allows applying our API to almost all programming languages.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class TechnologiesInfo(BaseModel):
    """
    TechnologiesInfo
    """ # noqa: E501
    add_ons: Optional[Dict[str, Optional[List[Optional[StrictStr]]]]] = None
    analytics: Optional[Dict[str, Optional[List[Optional[StrictStr]]]]] = None
    web_development: Optional[Dict[str, Optional[List[Optional[StrictStr]]]]] = None
    security: Optional[Dict[str, Optional[List[Optional[StrictStr]]]]] = None
    business_tools: Optional[Dict[str, Optional[List[Optional[StrictStr]]]]] = None
    sales: Optional[Dict[str, Optional[List[Optional[StrictStr]]]]] = None
    other: Optional[Dict[str, Optional[List[Optional[StrictStr]]]]] = None
    user_generated_content: Optional[Dict[str, Optional[List[Optional[StrictStr]]]]] = None
    privacy: Optional[Dict[str, Optional[List[Optional[StrictStr]]]]] = None
    servers: Optional[Dict[str, Optional[List[Optional[StrictStr]]]]] = None
    location: Optional[Dict[str, Optional[List[Optional[StrictStr]]]]] = None
    content: Optional[Dict[str, Optional[List[Optional[StrictStr]]]]] = None
    media: Optional[Dict[str, Optional[List[Optional[StrictStr]]]]] = None
    marketing: Optional[Dict[str, Optional[List[Optional[StrictStr]]]]] = None
    communication: Optional[Dict[str, Optional[List[Optional[StrictStr]]]]] = None
    utilities: Optional[Dict[str, Optional[List[Optional[StrictStr]]]]] = None
    __properties: ClassVar[List[str]] = ["add_ons", "analytics", "web_development", "security", "business_tools", "sales", "other", "user_generated_content", "privacy", "servers", "location", "content", "media", "marketing", "communication", "utilities"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TechnologiesInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if add_ons (nullable) is None
        # and model_fields_set contains the field
        if self.add_ons is None and "add_ons" in self.model_fields_set:
            _dict['add_ons'] = None

        # set to None if analytics (nullable) is None
        # and model_fields_set contains the field
        if self.analytics is None and "analytics" in self.model_fields_set:
            _dict['analytics'] = None

        # set to None if web_development (nullable) is None
        # and model_fields_set contains the field
        if self.web_development is None and "web_development" in self.model_fields_set:
            _dict['web_development'] = None

        # set to None if security (nullable) is None
        # and model_fields_set contains the field
        if self.security is None and "security" in self.model_fields_set:
            _dict['security'] = None

        # set to None if business_tools (nullable) is None
        # and model_fields_set contains the field
        if self.business_tools is None and "business_tools" in self.model_fields_set:
            _dict['business_tools'] = None

        # set to None if sales (nullable) is None
        # and model_fields_set contains the field
        if self.sales is None and "sales" in self.model_fields_set:
            _dict['sales'] = None

        # set to None if other (nullable) is None
        # and model_fields_set contains the field
        if self.other is None and "other" in self.model_fields_set:
            _dict['other'] = None

        # set to None if user_generated_content (nullable) is None
        # and model_fields_set contains the field
        if self.user_generated_content is None and "user_generated_content" in self.model_fields_set:
            _dict['user_generated_content'] = None

        # set to None if privacy (nullable) is None
        # and model_fields_set contains the field
        if self.privacy is None and "privacy" in self.model_fields_set:
            _dict['privacy'] = None

        # set to None if servers (nullable) is None
        # and model_fields_set contains the field
        if self.servers is None and "servers" in self.model_fields_set:
            _dict['servers'] = None

        # set to None if location (nullable) is None
        # and model_fields_set contains the field
        if self.location is None and "location" in self.model_fields_set:
            _dict['location'] = None

        # set to None if content (nullable) is None
        # and model_fields_set contains the field
        if self.content is None and "content" in self.model_fields_set:
            _dict['content'] = None

        # set to None if media (nullable) is None
        # and model_fields_set contains the field
        if self.media is None and "media" in self.model_fields_set:
            _dict['media'] = None

        # set to None if marketing (nullable) is None
        # and model_fields_set contains the field
        if self.marketing is None and "marketing" in self.model_fields_set:
            _dict['marketing'] = None

        # set to None if communication (nullable) is None
        # and model_fields_set contains the field
        if self.communication is None and "communication" in self.model_fields_set:
            _dict['communication'] = None

        # set to None if utilities (nullable) is None
        # and model_fields_set contains the field
        if self.utilities is None and "utilities" in self.model_fields_set:
            _dict['utilities'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TechnologiesInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "add_ons": obj.get("add_ons"),
            "analytics": obj.get("analytics"),
            "web_development": obj.get("web_development"),
            "security": obj.get("security"),
            "business_tools": obj.get("business_tools"),
            "sales": obj.get("sales"),
            "other": obj.get("other"),
            "user_generated_content": obj.get("user_generated_content"),
            "privacy": obj.get("privacy"),
            "servers": obj.get("servers"),
            "location": obj.get("location"),
            "content": obj.get("content"),
            "media": obj.get("media"),
            "marketing": obj.get("marketing"),
            "communication": obj.get("communication"),
            "utilities": obj.get("utilities")
        })
        return _obj


