# coding: utf-8

"""
    DataForSEO API documentation

    DataForSEO API is the starting point on your journey towards building powerful SEO software. With DataForSEO you can get all the data you need to build an efficient application while also saving your time and budget. DataForSEO API is using the REST technology for interchanging data between your application and our service. The data exchange is made through the widely used HTTP protocol, which allows applying our API to almost all programming languages.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class TrendsMapDataInfo(BaseModel):
    """
    TrendsMapDataInfo
    """ # noqa: E501
    geo_id: Optional[StrictStr] = Field(default=None, description="Google Trends location identifier you can use this field for matching obtained results with location parameters specified in the request example: US-NY")
    geo_name: Optional[StrictStr] = Field(default=None, description="Google Trends location name you can use this field for matching obtained results with location parameters specified in the request")
    values: Optional[List[Optional[Dict[str, Any]]]] = Field(default=None, description="relative keyword popularity rate in a given location represents the location-specific keyword popularity rate over the given time range if you specify more than one keyword, the values will be averaged to the highest value across all specified keywords a value of 100 is the peak popularity for the term a value of 50 means that the term is half as popular a value of 0 means there was not enough data for this term")
    max_value_index: Optional[StrictInt] = Field(default=None, description="max value among comparable terms represents the maximum value if you specified more than two keywords in a POST array if you specified only one keyword, the value will be null")
    __properties: ClassVar[List[str]] = ["geo_id", "geo_name", "values", "max_value_index"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TrendsMapDataInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if geo_id (nullable) is None
        # and model_fields_set contains the field
        if self.geo_id is None and "geo_id" in self.model_fields_set:
            _dict['geo_id'] = None

        # set to None if geo_name (nullable) is None
        # and model_fields_set contains the field
        if self.geo_name is None and "geo_name" in self.model_fields_set:
            _dict['geo_name'] = None

        # set to None if values (nullable) is None
        # and model_fields_set contains the field
        if self.values is None and "values" in self.model_fields_set:
            _dict['values'] = None

        # set to None if max_value_index (nullable) is None
        # and model_fields_set contains the field
        if self.max_value_index is None and "max_value_index" in self.model_fields_set:
            _dict['max_value_index'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TrendsMapDataInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "geo_id": obj.get("geo_id"),
            "geo_name": obj.get("geo_name"),
            "values": obj.get("values"),
            "max_value_index": obj.get("max_value_index")
        })
        return _obj


