# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetClientsResult',
    'AwaitableGetClientsResult',
    'get_clients',
    'get_clients_output',
]

@pulumi.output_type
class GetClientsResult:
    """
    A collection of values returned by getClients.
    """
    def __init__(__self__, app_types=None, clients=None, id=None, is_first_party=None, name_filter=None):
        if app_types and not isinstance(app_types, list):
            raise TypeError("Expected argument 'app_types' to be a list")
        pulumi.set(__self__, "app_types", app_types)
        if clients and not isinstance(clients, list):
            raise TypeError("Expected argument 'clients' to be a list")
        pulumi.set(__self__, "clients", clients)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_first_party and not isinstance(is_first_party, bool):
            raise TypeError("Expected argument 'is_first_party' to be a bool")
        pulumi.set(__self__, "is_first_party", is_first_party)
        if name_filter and not isinstance(name_filter, str):
            raise TypeError("Expected argument 'name_filter' to be a str")
        pulumi.set(__self__, "name_filter", name_filter)

    @_builtins.property
    @pulumi.getter(name="appTypes")
    def app_types(self) -> Optional[Sequence[_builtins.str]]:
        """
        Filter clients by application types.
        """
        return pulumi.get(self, "app_types")

    @_builtins.property
    @pulumi.getter
    def clients(self) -> Sequence['outputs.GetClientsClientResult']:
        """
        List of clients matching the filter criteria.
        """
        return pulumi.get(self, "clients")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isFirstParty")
    def is_first_party(self) -> Optional[_builtins.bool]:
        """
        Filter clients by first party status.
        """
        return pulumi.get(self, "is_first_party")

    @_builtins.property
    @pulumi.getter(name="nameFilter")
    def name_filter(self) -> Optional[_builtins.str]:
        """
        Filter clients by name (partial matches supported).
        """
        return pulumi.get(self, "name_filter")


class AwaitableGetClientsResult(GetClientsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetClientsResult(
            app_types=self.app_types,
            clients=self.clients,
            id=self.id,
            is_first_party=self.is_first_party,
            name_filter=self.name_filter)


def get_clients(app_types: Optional[Sequence[_builtins.str]] = None,
                is_first_party: Optional[_builtins.bool] = None,
                name_filter: Optional[_builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetClientsResult:
    """
    Data source to retrieve a list of Auth0 application clients with optional filtering.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_auth0 as auth0

    # Auth0 clients with "External" in the name
    external_apps = auth0.get_clients(name_filter="External")
    # Auth0 clients filtered by non_interactive or spa app type
    m2m_apps = auth0.get_clients(app_types=[
        "non_interactive",
        "spa",
    ])
    # Auth0 clients filtered by is_first_party equal to true
    first_party_apps = auth0.get_clients(is_first_party=True)
    ```


    :param Sequence[_builtins.str] app_types: Filter clients by application types.
    :param _builtins.bool is_first_party: Filter clients by first party status.
    :param _builtins.str name_filter: Filter clients by name (partial matches supported).
    """
    __args__ = dict()
    __args__['appTypes'] = app_types
    __args__['isFirstParty'] = is_first_party
    __args__['nameFilter'] = name_filter
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('auth0:index/getClients:getClients', __args__, opts=opts, typ=GetClientsResult).value

    return AwaitableGetClientsResult(
        app_types=pulumi.get(__ret__, 'app_types'),
        clients=pulumi.get(__ret__, 'clients'),
        id=pulumi.get(__ret__, 'id'),
        is_first_party=pulumi.get(__ret__, 'is_first_party'),
        name_filter=pulumi.get(__ret__, 'name_filter'))
def get_clients_output(app_types: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                       is_first_party: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                       name_filter: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetClientsResult]:
    """
    Data source to retrieve a list of Auth0 application clients with optional filtering.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_auth0 as auth0

    # Auth0 clients with "External" in the name
    external_apps = auth0.get_clients(name_filter="External")
    # Auth0 clients filtered by non_interactive or spa app type
    m2m_apps = auth0.get_clients(app_types=[
        "non_interactive",
        "spa",
    ])
    # Auth0 clients filtered by is_first_party equal to true
    first_party_apps = auth0.get_clients(is_first_party=True)
    ```


    :param Sequence[_builtins.str] app_types: Filter clients by application types.
    :param _builtins.bool is_first_party: Filter clients by first party status.
    :param _builtins.str name_filter: Filter clients by name (partial matches supported).
    """
    __args__ = dict()
    __args__['appTypes'] = app_types
    __args__['isFirstParty'] = is_first_party
    __args__['nameFilter'] = name_filter
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('auth0:index/getClients:getClients', __args__, opts=opts, typ=GetClientsResult)
    return __ret__.apply(lambda __response__: GetClientsResult(
        app_types=pulumi.get(__response__, 'app_types'),
        clients=pulumi.get(__response__, 'clients'),
        id=pulumi.get(__response__, 'id'),
        is_first_party=pulumi.get(__response__, 'is_first_party'),
        name_filter=pulumi.get(__response__, 'name_filter')))
