# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetConnectionKeysResult',
    'AwaitableGetConnectionKeysResult',
    'get_connection_keys',
    'get_connection_keys_output',
]

@pulumi.output_type
class GetConnectionKeysResult:
    """
    A collection of values returned by getConnectionKeys.
    """
    def __init__(__self__, connection_id=None, id=None, keys=None):
        if connection_id and not isinstance(connection_id, str):
            raise TypeError("Expected argument 'connection_id' to be a str")
        pulumi.set(__self__, "connection_id", connection_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if keys and not isinstance(keys, list):
            raise TypeError("Expected argument 'keys' to be a list")
        pulumi.set(__self__, "keys", keys)

    @_builtins.property
    @pulumi.getter(name="connectionId")
    def connection_id(self) -> _builtins.str:
        """
        The ID of the connection to retrieve keys for.
        """
        return pulumi.get(self, "connection_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def keys(self) -> Sequence['outputs.GetConnectionKeysKeyResult']:
        """
        List of signing keys associated with the connection.
        """
        return pulumi.get(self, "keys")


class AwaitableGetConnectionKeysResult(GetConnectionKeysResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetConnectionKeysResult(
            connection_id=self.connection_id,
            id=self.id,
            keys=self.keys)


def get_connection_keys(connection_id: Optional[_builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetConnectionKeysResult:
    """
    Retrieve the list of signing keys for a specific Auth0 connection. (Okta/OIDC only)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_auth0 as auth0

    # An Auth0 Connection Keys loaded using its Connection ID.
    my_keys = auth0.get_connection_keys(connection_id="con_xxxxxxxxxxxxx")
    ```


    :param _builtins.str connection_id: The ID of the connection to retrieve keys for.
    """
    __args__ = dict()
    __args__['connectionId'] = connection_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('auth0:index/getConnectionKeys:getConnectionKeys', __args__, opts=opts, typ=GetConnectionKeysResult).value

    return AwaitableGetConnectionKeysResult(
        connection_id=pulumi.get(__ret__, 'connection_id'),
        id=pulumi.get(__ret__, 'id'),
        keys=pulumi.get(__ret__, 'keys'))
def get_connection_keys_output(connection_id: Optional[pulumi.Input[_builtins.str]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetConnectionKeysResult]:
    """
    Retrieve the list of signing keys for a specific Auth0 connection. (Okta/OIDC only)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_auth0 as auth0

    # An Auth0 Connection Keys loaded using its Connection ID.
    my_keys = auth0.get_connection_keys(connection_id="con_xxxxxxxxxxxxx")
    ```


    :param _builtins.str connection_id: The ID of the connection to retrieve keys for.
    """
    __args__ = dict()
    __args__['connectionId'] = connection_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('auth0:index/getConnectionKeys:getConnectionKeys', __args__, opts=opts, typ=GetConnectionKeysResult)
    return __ret__.apply(lambda __response__: GetConnectionKeysResult(
        connection_id=pulumi.get(__response__, 'connection_id'),
        id=pulumi.get(__response__, 'id'),
        keys=pulumi.get(__response__, 'keys')))
