# coding: utf-8

"""
    VRt.Agro [AG]

    The version of the OpenAPI document: 6.14.2133

    Generated by OpenAPI Generator: 6.6.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List
from pydantic import BaseModel, Field, conlist, constr
from vrt_lss_agro.models.capacity_forecast_element import CapacityForecastElement
from vrt_lss_agro.models.stock_forecast_element import StockForecastElement

class Consumer(BaseModel):
    """
    Grain process. 
    """
    key: constr(strict=True, max_length=1024, min_length=1) = Field(..., description="Key, unique identifier.")
    crop_key: constr(strict=True, max_length=1024, min_length=1) = Field(..., description="Crop key.")
    consumption_forecast: conlist(CapacityForecastElement, max_items=3653, min_items=0) = Field(..., description="Capacity forecast.")
    stock_forecast: conlist(StockForecastElement, max_items=3653, min_items=0) = Field(..., description="Guaranteed balance requirement forecast.")
    __properties = ["key", "crop_key", "consumption_forecast", "stock_forecast"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Consumer:
        """Create an instance of Consumer from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in consumption_forecast (list)
        _items = []
        if self.consumption_forecast:
            for _item in self.consumption_forecast:
                if _item:
                    _items.append(_item.to_dict())
            _dict['consumption_forecast'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in stock_forecast (list)
        _items = []
        if self.stock_forecast:
            for _item in self.stock_forecast:
                if _item:
                    _items.append(_item.to_dict())
            _dict['stock_forecast'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Consumer:
        """Create an instance of Consumer from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return Consumer.parse_obj(obj)

        _obj = Consumer.parse_obj({
            "key": obj.get("key"),
            "crop_key": obj.get("crop_key"),
            "consumption_forecast": [CapacityForecastElement.from_dict(_item) for _item in obj.get("consumption_forecast")] if obj.get("consumption_forecast") is not None else None,
            "stock_forecast": [StockForecastElement.from_dict(_item) for _item in obj.get("stock_forecast")] if obj.get("stock_forecast") is not None else None
        })
        return _obj

