# coding: utf-8

"""
    VRt.Agro [AG]

    The version of the OpenAPI document: 6.14.2133

    Generated by OpenAPI Generator: 6.6.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, conlist, constr
from vrt_lss_agro.models.attribute import Attribute
from vrt_lss_agro.models.chamber import Chamber

class Dryer(BaseModel):
    """
    A dryer. 
    """
    key: constr(strict=True, max_length=1024, min_length=1) = Field(..., description="Key, unique identifier.")
    chamber_variants: conlist(Chamber, max_items=501, min_items=1, unique_items=True) = Field(..., description="List of chambers.")
    attributes: Optional[conlist(Attribute, max_items=1000, min_items=0, unique_items=True)] = Field(None, description="Attributes. Used to add service information.")
    __properties = ["key", "chamber_variants", "attributes"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Dryer:
        """Create an instance of Dryer from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in chamber_variants (list)
        _items = []
        if self.chamber_variants:
            for _item in self.chamber_variants:
                if _item:
                    _items.append(_item.to_dict())
            _dict['chamber_variants'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in attributes (list)
        _items = []
        if self.attributes:
            for _item in self.attributes:
                if _item:
                    _items.append(_item.to_dict())
            _dict['attributes'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Dryer:
        """Create an instance of Dryer from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return Dryer.parse_obj(obj)

        _obj = Dryer.parse_obj({
            "key": obj.get("key"),
            "chamber_variants": [Chamber.from_dict(_item) for _item in obj.get("chamber_variants")] if obj.get("chamber_variants") is not None else None,
            "attributes": [Attribute.from_dict(_item) for _item in obj.get("attributes")] if obj.get("attributes") is not None else None
        })
        return _obj

