# coding: utf-8

"""
    VRt.Agro [AG]

    The version of the OpenAPI document: 6.14.2133

    Generated by OpenAPI Generator: 6.6.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, conint, conlist, constr
from vrt_lss_agro.models.attribute import Attribute
from vrt_lss_agro.models.capacity_forecast_element import CapacityForecastElement
from vrt_lss_agro.models.humidity_forecast_element import HumidityForecastElement

class Field(BaseModel):
    """
    The field is a producer of grain. 
    """
    key: constr(strict=True, max_length=1024, min_length=1) = Field(..., description="Key, unique identifier.")
    crop_key: constr(strict=True, max_length=1024, min_length=1) = Field(..., description="Crop key.")
    amount: conint(strict=True, le=10000000, ge=0) = Field(..., description="The total amount of grain (in tons) to be harvested from the field.")
    capacity_forecast: conlist(CapacityForecastElement, max_items=3653, min_items=0) = Field(..., description="Capacity forecast.")
    humidity_forecast: Optional[conlist(HumidityForecastElement, max_items=3653, min_items=0)] = Field(None, description="Forecast on grain humidity in the field. If the humidity for a specific day is not specified, then the base crop humidity is used for this. ")
    attributes: Optional[conlist(Attribute, max_items=1000, min_items=0, unique_items=True)] = Field(None, description="Attributes. Used to add service information.")
    __properties = ["key", "crop_key", "amount", "capacity_forecast", "humidity_forecast", "attributes"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Field:
        """Create an instance of Field from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in capacity_forecast (list)
        _items = []
        if self.capacity_forecast:
            for _item in self.capacity_forecast:
                if _item:
                    _items.append(_item.to_dict())
            _dict['capacity_forecast'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in humidity_forecast (list)
        _items = []
        if self.humidity_forecast:
            for _item in self.humidity_forecast:
                if _item:
                    _items.append(_item.to_dict())
            _dict['humidity_forecast'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in attributes (list)
        _items = []
        if self.attributes:
            for _item in self.attributes:
                if _item:
                    _items.append(_item.to_dict())
            _dict['attributes'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Field:
        """Create an instance of Field from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return Field.parse_obj(obj)

        _obj = Field.parse_obj({
            "key": obj.get("key"),
            "crop_key": obj.get("crop_key"),
            "amount": obj.get("amount"),
            "capacity_forecast": [CapacityForecastElement.from_dict(_item) for _item in obj.get("capacity_forecast")] if obj.get("capacity_forecast") is not None else None,
            "humidity_forecast": [HumidityForecastElement.from_dict(_item) for _item in obj.get("humidity_forecast")] if obj.get("humidity_forecast") is not None else None,
            "attributes": [Attribute.from_dict(_item) for _item in obj.get("attributes")] if obj.get("attributes") is not None else None
        })
        return _obj

