# coding: utf-8

"""
    VRt.Agro [AG]

    The version of the OpenAPI document: 6.14.2133

    Generated by OpenAPI Generator: 6.6.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json



from pydantic import BaseModel, Field, conint, constr

class VersionResult(BaseModel):
    """
    Service version.
    """
    major: conint(strict=True, le=100, ge=1) = Field(..., description="Product version. Within a single version, compatibility of common data structures between services is guaranteed. A version change indicates changes that are incompatible with previous versions of the product (and all services). ")
    minor: conint(strict=True, le=111, ge=0) = Field(..., description="Minor version of the service. A version change indicates new functionality. The update is backward compatible with the major version of the service. ")
    build: constr(strict=True, max_length=64, min_length=1) = Field(..., description="Build version.       Contains backwards compatible bug fixes and docs update. ")
    __properties = ["major", "minor", "build"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> VersionResult:
        """Create an instance of VersionResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> VersionResult:
        """Create an instance of VersionResult from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return VersionResult.parse_obj(obj)

        _obj = VersionResult.parse_obj({
            "major": obj.get("major"),
            "minor": obj.get("minor"),
            "build": obj.get("build")
        })
        return _obj

