# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetWorkspaceApplicationScheduleResult',
    'AwaitableGetWorkspaceApplicationScheduleResult',
    'get_workspace_application_schedule',
    'get_workspace_application_schedule_output',
]

@pulumi.output_type
class GetWorkspaceApplicationScheduleResult:
    """
    A collection of values returned by getWorkspaceApplicationSchedule.
    """
    def __init__(__self__, application_key=None, description=None, frequency_details=None, id=None, identifier=None, is_daylight_adjustment_enabled=None, key=None, metadatas=None, model_type=None, model_version=None, name=None, object_status=None, object_version=None, parent_reves=None, registry_metadatas=None, schedule_key=None, timezone=None, workspace_id=None):
        if application_key and not isinstance(application_key, str):
            raise TypeError("Expected argument 'application_key' to be a str")
        pulumi.set(__self__, "application_key", application_key)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if frequency_details and not isinstance(frequency_details, list):
            raise TypeError("Expected argument 'frequency_details' to be a list")
        pulumi.set(__self__, "frequency_details", frequency_details)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identifier and not isinstance(identifier, str):
            raise TypeError("Expected argument 'identifier' to be a str")
        pulumi.set(__self__, "identifier", identifier)
        if is_daylight_adjustment_enabled and not isinstance(is_daylight_adjustment_enabled, bool):
            raise TypeError("Expected argument 'is_daylight_adjustment_enabled' to be a bool")
        pulumi.set(__self__, "is_daylight_adjustment_enabled", is_daylight_adjustment_enabled)
        if key and not isinstance(key, str):
            raise TypeError("Expected argument 'key' to be a str")
        pulumi.set(__self__, "key", key)
        if metadatas and not isinstance(metadatas, list):
            raise TypeError("Expected argument 'metadatas' to be a list")
        pulumi.set(__self__, "metadatas", metadatas)
        if model_type and not isinstance(model_type, str):
            raise TypeError("Expected argument 'model_type' to be a str")
        pulumi.set(__self__, "model_type", model_type)
        if model_version and not isinstance(model_version, str):
            raise TypeError("Expected argument 'model_version' to be a str")
        pulumi.set(__self__, "model_version", model_version)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if object_status and not isinstance(object_status, int):
            raise TypeError("Expected argument 'object_status' to be a int")
        pulumi.set(__self__, "object_status", object_status)
        if object_version and not isinstance(object_version, int):
            raise TypeError("Expected argument 'object_version' to be a int")
        pulumi.set(__self__, "object_version", object_version)
        if parent_reves and not isinstance(parent_reves, list):
            raise TypeError("Expected argument 'parent_reves' to be a list")
        pulumi.set(__self__, "parent_reves", parent_reves)
        if registry_metadatas and not isinstance(registry_metadatas, list):
            raise TypeError("Expected argument 'registry_metadatas' to be a list")
        pulumi.set(__self__, "registry_metadatas", registry_metadatas)
        if schedule_key and not isinstance(schedule_key, str):
            raise TypeError("Expected argument 'schedule_key' to be a str")
        pulumi.set(__self__, "schedule_key", schedule_key)
        if timezone and not isinstance(timezone, str):
            raise TypeError("Expected argument 'timezone' to be a str")
        pulumi.set(__self__, "timezone", timezone)
        if workspace_id and not isinstance(workspace_id, str):
            raise TypeError("Expected argument 'workspace_id' to be a str")
        pulumi.set(__self__, "workspace_id", workspace_id)

    @property
    @pulumi.getter(name="applicationKey")
    def application_key(self) -> str:
        return pulumi.get(self, "application_key")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the aggregator.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="frequencyDetails")
    def frequency_details(self) -> Sequence['outputs.GetWorkspaceApplicationScheduleFrequencyDetailResult']:
        """
        The model that holds the frequency details.
        """
        return pulumi.get(self, "frequency_details")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def identifier(self) -> str:
        """
        The identifier of the aggregator.
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter(name="isDaylightAdjustmentEnabled")
    def is_daylight_adjustment_enabled(self) -> bool:
        """
        A flag to indicate daylight saving.
        """
        return pulumi.get(self, "is_daylight_adjustment_enabled")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The key of the aggregator object.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def metadatas(self) -> Sequence['outputs.GetWorkspaceApplicationScheduleMetadataResult']:
        """
        A summary type containing information about the object including its key, name and when/who created/updated it.
        """
        return pulumi.get(self, "metadatas")

    @property
    @pulumi.getter(name="modelType")
    def model_type(self) -> str:
        """
        The type of the object.
        """
        return pulumi.get(self, "model_type")

    @property
    @pulumi.getter(name="modelVersion")
    def model_version(self) -> str:
        """
        This is a version number that is used by the service to upgrade objects if needed through releases of the service.
        """
        return pulumi.get(self, "model_version")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Free form text without any restriction on permitted characters. Name can have letters, numbers, and special characters. The value is editable and is restricted to 1000 characters.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="objectStatus")
    def object_status(self) -> int:
        """
        The status of an object that can be set to value 1 for shallow references across objects, other values reserved.
        """
        return pulumi.get(self, "object_status")

    @property
    @pulumi.getter(name="objectVersion")
    def object_version(self) -> int:
        """
        This is used by the service for optimistic locking of the object, to prevent multiple users from simultaneously updating the object.
        """
        return pulumi.get(self, "object_version")

    @property
    @pulumi.getter(name="parentReves")
    def parent_reves(self) -> Sequence['outputs.GetWorkspaceApplicationScheduleParentRefResult']:
        """
        A reference to the object's parent.
        """
        return pulumi.get(self, "parent_reves")

    @property
    @pulumi.getter(name="registryMetadatas")
    def registry_metadatas(self) -> Sequence['outputs.GetWorkspaceApplicationScheduleRegistryMetadataResult']:
        return pulumi.get(self, "registry_metadatas")

    @property
    @pulumi.getter(name="scheduleKey")
    def schedule_key(self) -> str:
        return pulumi.get(self, "schedule_key")

    @property
    @pulumi.getter
    def timezone(self) -> str:
        """
        The timezone for the schedule.
        """
        return pulumi.get(self, "timezone")

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> str:
        return pulumi.get(self, "workspace_id")


class AwaitableGetWorkspaceApplicationScheduleResult(GetWorkspaceApplicationScheduleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWorkspaceApplicationScheduleResult(
            application_key=self.application_key,
            description=self.description,
            frequency_details=self.frequency_details,
            id=self.id,
            identifier=self.identifier,
            is_daylight_adjustment_enabled=self.is_daylight_adjustment_enabled,
            key=self.key,
            metadatas=self.metadatas,
            model_type=self.model_type,
            model_version=self.model_version,
            name=self.name,
            object_status=self.object_status,
            object_version=self.object_version,
            parent_reves=self.parent_reves,
            registry_metadatas=self.registry_metadatas,
            schedule_key=self.schedule_key,
            timezone=self.timezone,
            workspace_id=self.workspace_id)


def get_workspace_application_schedule(application_key: Optional[str] = None,
                                       schedule_key: Optional[str] = None,
                                       workspace_id: Optional[str] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWorkspaceApplicationScheduleResult:
    """
    This data source provides details about a specific Workspace Application Schedule resource in Oracle Cloud Infrastructure Data Integration service.

    Retrieves schedule by schedule key

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_workspace_application_schedule = oci.DataIntegration.get_workspace_application_schedule(application_key=workspace_application_schedule_application_key,
        schedule_key=workspace_application_schedule_schedule_key,
        workspace_id=test_workspace["id"])
    ```


    :param str application_key: The application key.
    :param str schedule_key: Schedule Key
    :param str workspace_id: The workspace ID.
    """
    __args__ = dict()
    __args__['applicationKey'] = application_key
    __args__['scheduleKey'] = schedule_key
    __args__['workspaceId'] = workspace_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataIntegration/getWorkspaceApplicationSchedule:getWorkspaceApplicationSchedule', __args__, opts=opts, typ=GetWorkspaceApplicationScheduleResult).value

    return AwaitableGetWorkspaceApplicationScheduleResult(
        application_key=pulumi.get(__ret__, 'application_key'),
        description=pulumi.get(__ret__, 'description'),
        frequency_details=pulumi.get(__ret__, 'frequency_details'),
        id=pulumi.get(__ret__, 'id'),
        identifier=pulumi.get(__ret__, 'identifier'),
        is_daylight_adjustment_enabled=pulumi.get(__ret__, 'is_daylight_adjustment_enabled'),
        key=pulumi.get(__ret__, 'key'),
        metadatas=pulumi.get(__ret__, 'metadatas'),
        model_type=pulumi.get(__ret__, 'model_type'),
        model_version=pulumi.get(__ret__, 'model_version'),
        name=pulumi.get(__ret__, 'name'),
        object_status=pulumi.get(__ret__, 'object_status'),
        object_version=pulumi.get(__ret__, 'object_version'),
        parent_reves=pulumi.get(__ret__, 'parent_reves'),
        registry_metadatas=pulumi.get(__ret__, 'registry_metadatas'),
        schedule_key=pulumi.get(__ret__, 'schedule_key'),
        timezone=pulumi.get(__ret__, 'timezone'),
        workspace_id=pulumi.get(__ret__, 'workspace_id'))


@_utilities.lift_output_func(get_workspace_application_schedule)
def get_workspace_application_schedule_output(application_key: Optional[pulumi.Input[str]] = None,
                                              schedule_key: Optional[pulumi.Input[str]] = None,
                                              workspace_id: Optional[pulumi.Input[str]] = None,
                                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetWorkspaceApplicationScheduleResult]:
    """
    This data source provides details about a specific Workspace Application Schedule resource in Oracle Cloud Infrastructure Data Integration service.

    Retrieves schedule by schedule key

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_workspace_application_schedule = oci.DataIntegration.get_workspace_application_schedule(application_key=workspace_application_schedule_application_key,
        schedule_key=workspace_application_schedule_schedule_key,
        workspace_id=test_workspace["id"])
    ```


    :param str application_key: The application key.
    :param str schedule_key: Schedule Key
    :param str workspace_id: The workspace ID.
    """
    ...
