import matplotlib
import matplotlib.pyplot as plt
from matplotlib.dates import MonthLocator, ConciseDateFormatter, AutoDateFormatter
import seaborn as sns
import os
from .config import get_stats_dir
import logging

logger = logging.getLogger(__name__)
logger.setLevel(logging.INFO)
logger.addHandler(logging.StreamHandler())


def rotate(l, n):
    return l[n:] + l[:n]


sns.set_theme()
sns.set_style("whitegrid")
sns.set_palette(rotate(sns.color_palette("deep"), 2))
plt.rcParams["figure.dpi"] = 140
plt.rcParams["figure.figsize"] = (12.8, 9.6)


def plot(repo_name, stat_name, stat_description, df, run_at):
    image_path = os.path.join(get_stats_dir(), f"{repo_name}/{stat_name}.png")
    ax = df.plot()
    last_date = df.index.values[-1]

    if len(df.columns) == 1:
        column_name = df.columns[0]
        last_value = df.iloc[-1][column_name]
        ax.annotate(last_value, (last_date, last_value))

    plt.xlabel("Date")
    plt.suptitle(stat_description, y=0.93, size="xx-large", weight="semibold")
    plt.title(
        f"{repo_name}:{stat_name} by repotracer at {run_at.strftime('%Y-%m-%d %H:%M:%S')}",
        loc="right",
        fontsize="small",
        weight="light",
        alpha=0.5,
    )
    # ax.xaxis.set_major_locator(MonthLocator())
    # todo set a formatter that displays either single letter month or full month name
    # ax.xaxis.set_major_formatter(ConciseDateFormatter(MonthLocator()))

    plt.savefig(image_path, bbox_inches="tight")
    logger.info(f"Plotting {stat_name} to {image_path}")
