import os
from typing import Union

# In most runs, the EPW assignment will be guessed from the CMakeLists file in the testfiles/ directory.
# However, when using an E+ install as a build directory, the EPW assignments are not known.
# In this case, or whenever an EPW assignment is not known for whatever reason, the pre-made list will be checked.
# If the EPW is still not known, a default will be used internally in the diff engine.

epw_map = {
    "1ZoneDataCenterCRAC_wApproachTemp.idf": "USA_CO_Golden-NREL.724666_TMY3.epw",
    "1ZoneDataCenterCRAC_wPumpedDXCoolingCoil.idf": "USA_CO_Golden-NREL.724666_TMY3.epw",
    "1ZoneEvapCooler.idf": "USA_CO_Golden-NREL.724666_TMY3.epw",
    "_1Zone_Heavy_AdiabaticX2.idf": "USA_CO_Golden-NREL.724666_TMY3.epw",
    "_1Zone_Heavy_MassX2.idf": "USA_CO_Golden-NREL.724666_TMY3.epw",
    "_1Zone_Heavy_SelfRef.idf": "USA_CO_Golden-NREL.724666_TMY3.epw",
    "1ZoneParameterAspect.idf": "USA_CO_Golden-NREL.724666_TMY3.epw",
    "1ZoneUncontrolled3SurfaceZone.idf": "USA_CO_Golden-NREL.724666_TMY3.epw",
    "1ZoneUncontrolledAnnualOutputs.idf": "USA_CO_Golden-NREL.724666_TMY3.epw",
    "1ZoneUncontrolledCondFDWithVariableKat24C.idf": "USA_CO_Golden-NREL.724666_TMY3.epw",
    "_1ZoneUncontrolled_customrange.idf": "94810-1953-1957.epw",
    "1ZoneUncontrolled_DD2009.idf": "94810-1953-1957.epw",
    "1ZoneUncontrolled_DDChanges.idf": "94810-1953-1957.epw",
    "1ZoneUncontrolled_FCfactor_Slab_UGWall.idf": "94810-1953-1957.epw",
    "_1ZoneUncontrolled_Feb29.idf": "94810-1956.epw",
    "1ZoneUncontrolledFourAlgorithms.idf": "94810-1956.epw",
    "1ZoneUncontrolled.idf": "USA_CO_Golden-NREL.724666_TMY3.epw",
    "1ZoneUncontrolled_OtherEquipmentWithFuel.idf": "USA_CO_Golden-NREL.724666_TMY3.epw",
    "1ZoneUncontrolledResLayers.idf": "94810-1956.epw",
    "_1ZoneUncontrolled_SineOSC.idf": "USA_CO_Golden-NREL.724666_TMY3.epw",
    "1ZoneUncontrolledUTF8.idf": "USA_CO_Golden-NREL.724666_TMY3.epw",
    "1ZoneUncontrolled_win_1.idf": "USA_CO_Golden-NREL.724666_TMY3.epw",
    "1ZoneUncontrolled_win_2.idf": "USA_CO_Golden-NREL.724666_TMY3.epw",
    "1ZoneUncontrolled_Win_ResilienceReports.idf": "USA_CO_Golden-NREL.724666_TMY3.epw",
    "1ZoneUncontrolledWithHysteresisPCM.idf": "USA_CO_Golden-NREL.724666_TMY3.epw",
    "1ZoneWith14ControlledHeat-CoolPanels.idf": "USA_CO_Golden-NREL.724666_TMY3.epw",
    "2ZoneDataCenterHVAC_wEconomizer.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "4ZoneWithShading_Simple_1.idf": "USA_CO_Golden-NREL.724666_TMY3.epw",
    "4ZoneWithShading_Simple_2.idf": "USA_CO_Golden-NREL.724666_TMY3.epw",
    "5ZoneAirCooled_AirBoundaries_Daylighting.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "5ZoneAirCooled_AirBoundaries.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "_5ZoneAirCooled_annual.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "5ZoneAirCooledConvCoef.idf": "USA_CO_Golden-NREL.724666_TMY3.epw",
    "5ZoneAirCooledConvCoefPIU.idf": "USA_CO_Golden-NREL.724666_TMY3.epw",
    "5ZoneAirCooledDemandLimiting_FixedRateVentilation.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "5ZoneAirCooledDemandLimiting.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "5ZoneAirCooledDemandLimiting_ReductionRatioVentilation.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "5ZoneAirCooled.idf": "USA_CO_Golden-NREL.724666_TMY3.epw",
    "_5ZoneAirCooled_LeapYear_annual.idf": "MadeUpLeapYear.epw",
    "5ZoneAirCooled_UniformLoading.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "5ZoneAirCooled_VAVBoxMinAirFlowTurnDown.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "5ZoneAirCooled_VRPSizing.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "5ZoneAirCooled_VRPSizing_MaxZd.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "5ZoneAirCooledWithCoupledInGradeSlab.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "5ZoneAirCooledWithDOASAirLoop.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "5ZoneAirCooledWithSlab.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "5ZoneAirCooled_ZoneAirMassFlowBalance.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "5ZoneAirCooled_ZoneAirMassFlowBalance_Pressurized.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "5ZoneAutoDXVAV.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "5ZoneBoilerOutsideAirReset.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "5ZoneBranchSupplyPumps.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "5ZoneCAV_MaxTemp.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "5ZoneCAV_MaxTemp_JSON_Outputs.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "5ZoneCAVtoVAVWarmestTempFlow.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "5ZoneCoolBeam.idf": "USA_CA_San.Francisco.Intl.AP.724940_TMY3.epw",
    "5ZoneCoolingPanelBaseboardAuto.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "5ZoneCoolingPanelBaseboard.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "5ZoneCoolingPanelBaseboardTotalLoad.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "5ZoneCoolingPanelBaseboardVarOff.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "5ZoneCostEst.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "5ZoneDDCycOnAny.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "5ZoneDDCycOnOne.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "5ZoneDesignInputCoolingCoil.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "5ZoneDetailedIceStorage2.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "5ZoneDetailedIceStorageCubicLinear.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "5ZoneDetailedIceStorage.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "5ZoneDetailedIceStorageSimpleCtrl.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "5ZoneEconomicsTariffAndLifeCycleCosts.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "5ZoneElectricBaseboard.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "5ZoneEndUses.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "5ZoneEngChill.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "_5ZoneEvapCooled.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "5ZoneFanCoilDOASCool.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "5ZoneFanCoilDOAS_ERVOnAirLoopMainBranch.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "5ZoneFanCoilDOAS_HumidifierOnOASystem.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "5ZoneFPIU.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "5ZoneGeometryTransform.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "5ZoneIceStorage.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "5Zone_IdealLoadsAirSystems_ReturnPlenum.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "5ZoneNightVent1.idf": "USA_CA_Fresno.Air.Terminal.723890_TMY3.epw",
    "5ZoneNightVent2.idf": "USA_CA_Fresno.Air.Terminal.723890_TMY3.epw",
    "5ZoneNightVent3.idf": "USA_CA_Fresno.Air.Terminal.723890_TMY3.epw",
    "5ZoneReturnFan.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "5ZoneSteamBaseboard.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "5ZoneSupRetPlenRAB.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "5ZoneSupRetPlenVSATU.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "5ZoneSwimmingPool.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "5ZoneSwimmingPoolZoneMultipliers.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "5ZoneTDV.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "5Zone_Transformer.idf": "CZ06RV2.epw",
    "5Zone_Unitary_HXAssistedCoil.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "5Zone_Unitary_VSDesuperheater.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "5Zone_Unitary_VSDesuperheatWaterHeater.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "5ZoneVAV-ChilledWaterStorage-Mixed_DCV_MaxZd.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "5ZoneVAV-ChilledWaterStorage-Mixed_DCV_MultiPath.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "5ZoneVAV-ChilledWaterStorage-Mixed.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "5ZoneVAV-ChilledWaterStorage-Stratified.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "5ZoneVAV-Pri-SecLoop.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "5ZoneWarmest.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "5ZoneWarmestMultDDSizBypass.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "5ZoneWarmestMultDDSizOnOff.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "5ZoneWarmestMultDDSizVAV.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "5ZoneWarmestMultDDSizVT.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "5ZoneWarmestVFD_FCMAuto.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "5ZoneWarmestVFD.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "5ZoneWaterCooled_Baseboard.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "5ZoneWaterCooled_BaseboardScalableSizing.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "5ZoneWaterCooled_GasFiredSteamHumidifier.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "5ZoneWaterCooled_HighRHControl.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "5ZoneWaterCooled_MultizoneAverageRHControl.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "5ZoneWaterCooled_MultizoneMinMaxRHControl.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "5ZoneWaterLoopHeatPump.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "5ZoneWaterSystems.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "5ZoneWLHPPlantLoopTower.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "AbsorptionChiller.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "AbsorptionChiller_Macro.imf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "ActiveTrombeWall.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "AdaptiveThermostatASH55_5Zone_Miami.idf": "USA_FL_Miami.Intl.AP.722020_TMY3.epw",
    "AdvancedOutput/ExerciseOutput1A-Solution.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "AdvancedOutput/ExerciseOutput1.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "AirCooledElectricChiller.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "AirEconomizerFaults_RefBldgLargeOfficeNew2004_Chicago.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "AirEconomizerWithMaxMinOAFractions.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "AirflowNetwork3zVentAutoWPC.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "AirflowNetwork3zVent.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "AirflowNetworkAdvanced_SingleSided_NV.idf": "USA_CA_San.Francisco.Intl.AP.724940_TMY3.epw",
    "AirflowNetwork_Attic_Duct.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "AirflowNetwork_MultiAirLoops.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "AirflowNetwork_Multizone_HorizontalOpening.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "AirflowNetwork_MultiZone_House_FanModel.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "AirflowNetwork_MultiZone_House.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "AirflowNetwork_MultiZone_House_OvercoolDehumid.idf": "USA_FL_Miami.Intl.AP.722020_TMY3.epw",
    "AirflowNetwork_MultiZone_House_TwoSpeed.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "AirflowNetwork_MultiZone_LocalNode.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "AirflowNetwork_MultiZone_SmallOffice_CoilHXAssistedDX.idf": "USA_FL_Miami.Intl.AP.722020_TMY3.epw",
    "AirflowNetwork_MultiZone_SmallOffice_GenericContam.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "AirflowNetwork_MultiZone_SmallOffice_HeatRecoveryHXSL.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "AirflowNetwork_MultiZone_SmallOffice.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "AirflowNetwork_MultiZone_SmallOffice_VAV.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "AirflowNetworkOccupantVentilationControl.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "AirflowNetwork_PressureControl.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "AirflowNetwork_Simple_House.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "AirflowNetwork_Simple_SmallOffice.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "AirflowWindowsAndBetweenGlassBlinds.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "AirflowWindowsAndBetweenGlassShades.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "_AllOffOpScheme.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "ASHRAE9012016_ApartmentHighRise_Denver.idf": "USA_CO_Golden-NREL.724666_TMY3.epw",
    "ASHRAE9012016_ApartmentMidRise_Denver.idf": "USA_CO_Golden-NREL.724666_TMY3.epw",
    "ASHRAE9012016_Hospital_Denver.idf": "USA_CO_Golden-NREL.724666_TMY3.epw",
    "ASHRAE9012016_HotelLarge_Denver.idf": "USA_CO_Golden-NREL.724666_TMY3.epw",
    "ASHRAE9012016_HotelSmall_Denver.idf": "USA_CO_Golden-NREL.724666_TMY3.epw",
    "ASHRAE9012016_OfficeLarge_Denver.idf": "USA_CO_Golden-NREL.724666_TMY3.epw",
    "ASHRAE9012016_OfficeMedium_Denver.idf": "USA_CO_Golden-NREL.724666_TMY3.epw",
    "ASHRAE9012016_OfficeSmall_Denver.idf": "USA_CO_Golden-NREL.724666_TMY3.epw",
    "ASHRAE9012016_OutPatientHealthCare_Denver.idf": "USA_CO_Golden-NREL.724666_TMY3.epw",
    "ASHRAE9012016_RestaurantFastFood_Denver.idf": "USA_CO_Golden-NREL.724666_TMY3.epw",
    "ASHRAE9012016_RestaurantSitDown_Denver.idf": "USA_CO_Golden-NREL.724666_TMY3.epw",
    "ASHRAE9012016_RetailStandalone_Denver.idf": "USA_CO_Golden-NREL.724666_TMY3.epw",
    "ASHRAE9012016_RetailStripmall_Denver.idf": "USA_CO_Golden-NREL.724666_TMY3.epw",
    "ASHRAE9012016_SchoolPrimary_Denver.idf": "USA_CO_Golden-NREL.724666_TMY3.epw",
    "ASHRAE9012016_SchoolSecondary_Denver.idf": "USA_CO_Golden-NREL.724666_TMY3.epw",
    "ASHRAE9012016_Warehouse_Denver.idf": "USA_CO_Golden-NREL.724666_TMY3.epw",
    "ASIHPMixedTank.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "BaseBoardElectric.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "BasicsFiles/AdultEducationCenter.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "BasicsFiles/Exercise1A.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "BasicsFiles/Exercise1B-Solution.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "BasicsFiles/Exercise1C-Solution.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "BasicsFiles/Exercise1D-Solution.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "BasicsFiles/Exercise2A-Solution.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "BasicsFiles/Exercise2B-Solution.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "BasicsFiles/Exercise2C-Solution.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "BasicsFiles/Exercise2.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "_BranchPumpsWithCommonPipe.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "CarrollMRT-RefBldgLargeOfficeNew2004_Chicago.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "CentralChillerHeaterSystem_Cooling_Heating.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "CentralChillerHeaterSystem_Simultaneous_Cooling_Heating.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "ChangeoverBypassVAV_AirToAirHeatPump.idf": "USA_FL_Miami.Intl.AP.722020_TMY3.epw",
    "ChangeoverBypassVAV_AirToAir.idf": "USA_FL_Miami.Intl.AP.722020_TMY3.epw",
    "ChangeoverBypassVAV.idf": "USA_FL_Miami.Intl.AP.722020_TMY3.epw",
    "ChangeoverBypassVAV_MaxTemp.idf": "USA_FL_Miami.Intl.AP.722020_TMY3.epw",
    "ChillerPartLoadCurve_RefBldgLargeOfficeNew2004_Chicago.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "CmplxGlz_Daylighting_SouthVB45deg.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "CmplxGlz_Daylighting_SouthVerticalVB45deg.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "CmplxGlz_InShadeGasMix.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "CmplxGlz_MeasuredDeflectionAndShading.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "CmplxGlz_SchedSurfGains.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "CmplxGlz_SingleZone_Deflection.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "CmplxGlz_SingleZone_DoubleClearAir.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "CmplxGlz_SingleZone_Vacuum.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "CmplxGlz_SmOff_IntExtShading.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "CoilWaterDesuperheating.idf": "USA_FL_Miami.Intl.AP.722020_TMY3.epw",
    "CommonPipe_Pri-Sec.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "CompSetPtControl.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "CondFD1ZonePurchAirAutoSizeWithPCM.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "ConstSpeedBranchPumpExercise.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "_ConvCoefftest.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "ConvectionAdaptiveSmallOffice.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "Convection.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "CoolingCoilFreezingPrevention.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "_CoolingTowerDewPointRangeOp.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "CoolingTowerDryBulbRangeOp.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "CoolingTower_FluidBypass.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "CoolingTower.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "CoolingTower_MerkelVariableSpeed.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "CoolingTowerNomCap.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "CoolingTowerRHRangeOp.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "CoolingTower_SingleSpeed_MultiCell.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "CoolingTower_TwoSpeed_CondEntTempReset.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "CoolingTower_TwoSpeed.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "CoolingTower_TwoSpeed_MultiCell.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "CoolingTower_VariableSpeed_CondEntTempReset.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "CoolingTower_VariableSpeed_CondEntTempReset_MultipleTowers.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "CoolingTower_VariableSpeed_IdealCondEntTempSetpoint.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "CoolingTower_VariableSpeed_IdealCondEntTempSetpoint_MultipleTowers.idf":
        "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "CoolingTower_VariableSpeed.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "CoolingTower_VariableSpeed_MultiCell.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "CoolingTowerWetBulbRangeOp.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "CoolingTowerWithDBDeltaTempOp.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "_CoolingTowerWithDPDeltaTempOp.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "CoolingTowerWithWBDeltaTempOp.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "CooltowerSimpleTest.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "CooltowerSimpleTestwithVentilation.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "CrossVent_1Zone_AirflowNetwork.idf": "USA_CA_San.Francisco.Intl.AP.724940_TMY3.epw",
    "CrossVent_1Zone_AirflowNetwork_with2CrossflowJets.idf": "USA_CA_San.Francisco.Intl.AP.724940_TMY3.epw",
    "_CTFTestsPart1.idf": "USA_CA_San.Francisco.Intl.AP.724940_TMY3.epw",
    "_CTFTestsPart2.idf": "USA_CA_San.Francisco.Intl.AP.724940_TMY3.epw",
    "CustomSolarVisibleSpectrum_RefBldgSmallOfficeNew2004_Chicago.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "CVRhMinHum.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "DaylightingDeviceShelf.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "DaylightingDeviceTubular.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "DDAutoSize.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "DElightCFSLightShelf.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "DElightCFSWindow.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "DElight-Detailed-Comparison.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "_DemandVentilationFixedRateAndHighPriority.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "_DemandVentilationReductionRatioAndHighPriority.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "_DemandVentilationReductionRatioAndLowPriority.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "DesiccantCVRh.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "DesiccantCVRhZoneRHCtrl_AddedAutosize.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "DesiccantCVRhZoneRHCtrl.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "DesiccantDehumidifierWithAirToAirCoil.idf": "USA_FL_Miami.Intl.AP.722020_TMY3.epw",
    "DesiccantDehumidifierWithCompanionCoil.idf": "USA_FL_Miami.Intl.AP.722020_TMY3.epw",
    "DirectIndirectEvapCoolers.idf": "USA_AZ_Phoenix-Sky.Harbor.Intl.AP.722780_TMY3.epw",
    "DirectIndirectEvapCoolersVSAS.idf": "USA_AZ_Phoenix-Sky.Harbor.Intl.AP.722780_TMY3.epw",
    "DisplacementVent_1ZoneOffice.idf": "USA_CA_San.Francisco.Intl.AP.724940_TMY3.epw",
    "DisplacementVent_Nat_AirflowNetwork_AdaptiveComfort.idf": "USA_CA_San.Francisco.Intl.AP.724940_TMY3.epw",
    "DisplacementVent_Nat_AirflowNetwork.idf": "USA_CA_San.Francisco.Intl.AP.724940_TMY3.epw",
    "DisplacementVent_VAV.idf": "USA_CA_San.Francisco.Intl.AP.724940_TMY3.epw",
    "DOASDualDuctSchool.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "DOASDXCOIL_wADPBFMethod.idf": "USA_FL_Miami.Intl.AP.722020_TMY3.epw",
    "DOASDXCOIL_wADPBFMethod_NoReturnPath.idf": "USA_FL_Miami.Intl.AP.722020_TMY3.epw",
    "_DOASDXCOIL_wUserSHRMethod.idf": "USA_FL_Miami.Intl.AP.722020_TMY3.epw",
    "DOAS_wNeutralSupplyAir_wFanCoilUnits.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "DOAToFanCoilInlet.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "DOAToFanCoilSupply.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "DOAToPTAC.idf": "USA_FL_Miami.Intl.AP.722020_TMY3.epw",
    "DOAToPTHP.idf": "USA_FL_Miami.Intl.AP.722020_TMY3.epw",
    "DOAToUnitarySystem.idf": "USA_FL_Miami.Intl.AP.722020_TMY3.epw",
    "DOAToUnitVentilator.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "DOAToVRF.idf": "USA_FL_Miami.Intl.AP.722020_TMY3.epw",
    "DOAToWaterToAirHPInlet.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "DOAToWaterToAirHPSupply.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "DualDuctConstVolDamper.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "_DualDuctConstVolDamperMultizoneAverageSetPointManager.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "DualDuctConstVolGasHC.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "DualDuctVarVolDamper.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "DualDuctWaterCoils.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "DXCoilSystemAuto.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "DynamicClothing.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "EarthTubeSimpleTest.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "EcoroofOrlando.idf": "USA_FL_Orlando.Intl.AP.722050_TMY3.epw",
    "ElectricChiller.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "ElectricEIRChiller_EvapCooledCondenser.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "ElectricEIRChillerHeatRecoveryAuto.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "ElectricEIRChiller.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "_ElectricREformulatedEIRChiller.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "EMPD5ZoneWaterCooled_HighRHControl.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "EMSAirflowNetworkOpeningControlByHumidity.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "EMSConstantVolumePurchasedAir.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "EMSCurveOverride_PackagedTerminalHeatPump.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "EMSCustomOutputVariable.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "EMSCustomSchedule.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "EMSDemandManager_LargeOffice.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "EMSDiscreteAirSystemSizes.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "EMSPlantLoopOverrideControl.idf": "USA_FL_Orlando.Intl.AP.722050_TMY3.epw",
    "EMSPlantOperation_largeOff.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "EMSReplaceTraditionalManagers_LargeOffice.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "EMSTestMathAndKill.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "EMSThermochromicWindow.idf": "USA_NV_Las.Vegas-McCarran.Intl.AP.723860_TMY3.epw",
    "EMSUserDefined5ZoneAirCooled.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "EMSUserDefinedWindACAuto.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "EMSWindowShadeControl.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "EngineChiller.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "EquivalentLayerWindow.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "EvaporativeFluidCooler.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "EvaporativeFluidCooler_TwoSpeed.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "ExhFiredAbsorptionChiller.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "ExteriorLightsAndEq.idf": "USA_CO_Golden-NREL.724666_TMY3.epw",
    "_ExternalInterface-functionalmockupunit-to-actuator.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "_ExternalInterface-functionalmockupunit-to-schedule.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "_ExternalInterface-functionalmockupunit-to-variable.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "FanCoilAutoSize_ASHRAE90VariableFan.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "FanCoilAutoSize.idf": "USA_CO_Golden-NREL.724666_TMY3.epw",
    "FanCoilAutoSize_MultiSpeedFan.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "FanCoilAutoSizeScalableSizing.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "_FanCoilHybridVentAFN.idf": "USA_CO_Golden-NREL.724666_TMY3.epw",
    "FanCoil_HybridVent_VentSch.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "Fault_ChillerSWTSensorOffset_RefBldgLargeOfficeNew2004.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "Fault_CoilSATSensorOffset.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "Fault_CondenserSWTSensorOffset.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "Fault_FoulingAirFilter_RefBldgMediumOfficeNew2004.idf": "USA_CO_Golden-NREL.724666_TMY3.epw",
    "Fault_FoulingChillerBoiler_RefBldgLargeOfficeNew2004.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "Fault_FoulingCoil.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "Fault_FoulingCoolingTower.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "Fault_FoulingEvapCooler_StripMallZoneEvapCooler.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "Fault_HumidistatOffset_Supermarket.idf": "USA_CO_Golden-NREL.724666_TMY3.epw",
    "Fault_HumidistatOffset_ThermostatOffset_Supermarket.idf": "USA_CO_Golden-NREL.724666_TMY3.epw",
    "Fault_ThermostatOffset_RefBldgMediumOfficeNew2004.idf": "USA_CO_Golden-NREL.724666_TMY3.epw",
    "Flr_Rf_8Sides.idf": "USA_CO_Golden-NREL.724666_TMY3.epw",
    "FluidCooler.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "FluidCoolerTwoSpeed.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "_FollowSysNodeTemp.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "FourPipeBeamLargeOffice.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "FreeCoolingChiller.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "_FuelCellTest200.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "FurnaceFuelOil.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "Furnace.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "FurnacePLRHeatingCoil.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "FurnaceWithDXSystemComfortControl.idf": "USA_FL_Miami.Intl.AP.722020_TMY3.epw",
    "FurnaceWithDXSystem_CoolingHXAssisted.idf": "USA_FL_Miami.Intl.AP.722020_TMY3.epw",
    "FurnaceWithDXSystem.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "FurnaceWithDXSystemRHcontrol_cyclingfan.idf": "USA_FL_Miami.Intl.AP.722020_TMY3.epw",
    "FurnaceWithDXSystemRHcontrol.idf": "USA_FL_Miami.Intl.AP.722020_TMY3.epw",
    "gasAbsorptionChillerHeater.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "GasTurbChillerHeatRecoveryAuto.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "GasTurbChiller.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "Generator_PVWatts.idf": "USA_AZ_Phoenix-Sky.Harbor.Intl.AP.722780_TMY3.epw",
    "Generators.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "Generators_Transformer.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "GeneratorswithPV.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "GeneratorwithWindTurbine.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "GeometryTest.idf": "USA_CO_Colorado.Springs-Peterson.Field.724660_TMY3.epw",
    "GroundTempOSCCompactSched.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "GSHP-GLHE-CalcGFunctions.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "GSHP-GLHE.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "GSHPSimple-GLHE.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "GSHP-Slinky.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "HAMT_DailyProfileReport.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "HAMT_HourlyProfileReport.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "HeaderedPumpsConSpeed.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "HeaderedPumpsVarSpeed.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "HeatPumpAirToAirWithRHcontrol.idf": "USA_FL_Miami.Intl.AP.722020_TMY3.epw",
    "HeatPumpAuto.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "HeatPumpCycFanWithEcono.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "HeatPumpIAQP_DCV.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "HeatPumpIAQP_GenericContamControl.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "HeatPump.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "HeatPumpProportionalControl_DCVDesignRate.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "HeatPumpProportionalControl_DCV.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "HeatPumpSecondaryCoil.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "HeatPumpSimpleDCV.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "HeatPumpVRP_DCV.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "HeatPumpVSAS.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "HeatPumpWaterHeater.idf": "USA_FL_Miami.Intl.AP.722020_TMY3.epw",
    "HeatPumpWaterHeaterStratified.idf": "USA_FL_Miami.Intl.AP.722020_TMY3.epw",
    "HeatPumpWaterToAirEquationFit.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "HeatPumpWaterToAirEquationFit_WaterHeatingDesuperheater_StratifiedTank.idf":
        "USA_FL_Miami.Intl.AP.722020_TMY3.epw",
    "HeatPumpWaterToAir.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "HeatPumpWaterToAirWithAntifreezeAndLatentModel2.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "HeatPumpWaterToAirWithAntifreezeAndLatentModel.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "HeatPumpWaterToAirWithRHControl.idf": "USA_FL_Miami.Intl.AP.722020_TMY3.epw",
    "HeatPumpwithBiquadraticCurves.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "HeatRecoveryElectricChiller.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "HeatRecoveryPlantLoopAuto.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "HeatRecoveryPlantLoop.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "HeatRecoverywithStorageTank.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "HospitalBaseline.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "HospitalBaselineReheatReportEMS.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "HospitalLowEnergy.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "House-2FurnaceAC-SequentialLoadFractions.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "House-2FurnaceAC-SequentialLoad.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "House-2FurnaceAC-SequentialUniformPLR.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "House-2FurnaceAC-UniformLoad.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "House-2FurnaceAC-UniformPLR.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "HPAirToAir_wSolarCollectorHWCoil.idf": "USA_FL_Miami.Intl.AP.722020_TMY3.epw",
    "HP_wICSSolarCollector.idf": "USA_FL_Miami.Intl.AP.722020_TMY3.epw",
    "HVACStandAloneERV_Economizer.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "HVACTemplate-5ZoneBaseboardHeat.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "HVACTemplate-5ZoneConstantVolumeChillerBoiler.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "HVACTemplate-5ZoneDualDuct.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "HVACTemplate-5ZoneFanCoil-DOAS.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "HVACTemplate-5ZoneFanCoil.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "HVACTemplate-5ZoneFurnaceDX.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "HVACTemplate-5ZonePackagedVAV.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "HVACTemplate-5ZonePTAC-DOAS.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "HVACTemplate-5ZonePTAC.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "HVACTemplate-5ZonePTHP.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "HVACTemplate-5ZonePurchAir.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "HVACTemplate-5ZoneUnitaryHeatPump.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "HVACTemplate-5ZoneUnitarySystem.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "HVACTemplate-5ZoneVAVFanPowered.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "HVACTemplate-5ZoneVAVWaterCooled.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "HVACTemplate-5ZoneVAVWaterCooled-ObjectReference.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "HVACTemplate-5ZoneVRF.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "HVACTemplate-5ZoneWaterToAirHeatPumpTowerBoiler.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "HybridModel_4Zone_Solve_Infiltration_free_floating.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "HybridModel_4Zone_Solve_PeopleCount_with_HVAC.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "_HybridVentilationControlGlobalAN.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "HybridVentilationControlGlobalSimple.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "HybridVentilationControl.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "_HybridVentilationControl_MinTime.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "HybridZoneModel.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "IceStorage-Parallel.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "IceStorage-Series-ChillerDownstream.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "IceStorage-Series-ChillerUpstream.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "IndEvapCoolerRTUoffice.idf": "USA_AZ_Phoenix-Sky.Harbor.Intl.AP.722780_TMY3.epw",
    "IndirectAbsorptionChiller.idf": "USA_FL_Miami.Intl.AP.722020_TMY3.epw",
    "InternalMass_wZoneList.idf": "USA_FL_Miami.Intl.AP.722020_TMY3.epw",
    "LBuildingAppGRotPar.idf": "USA_FL_Miami.Intl.AP.722020_TMY3.epw",
    "LBuilding-G000.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "LBuilding-G090.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "LBuilding-G180.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "LBuilding-G270.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "LgOffVAV.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "LgOffVAVusingBasement.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "LookupTables.idf": "USA_FL_Miami.Intl.AP.722020_TMY3.epw",
    "LrgOff_GridStorageDemandLeveling.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "LrgOff_GridStorageEMSSmoothing.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "LrgOff_GridStorageScheduled.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "_MaterialTest.idf": "USA_FL_Miami.Intl.AP.722020_TMY3.epw",
    "_MicroCHPTest301.idf": "USA_FL_Miami.Intl.AP.722020_TMY3.epw",
    "MicroCogeneration.idf": "USA_NJ_Newark.Intl.AP.725020_TMY3.epw",
    "Minimal.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "MovableExtInsulationSimple.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "MovableIntInsulationLights.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "MovableIntInsulationLightsLowE.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "MovableIntInsulationSimple.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "_MultiSpeedACElecFurnace.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "MultiSpeedACFurnace.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "MultiSpeedHeatPump_DirectSolution.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "MultiSpeedHeatPump.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "MultiSpeedHeatPump_MultiSolvers.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "MultiSpeedHP_StagedThermostat.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "MultiStory.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "Mundt_System_Always_On.idf": "USA_FL_Tampa.Intl.AP.722110_TMY3.epw",
    "Mundt_System_On_During_the_Day.idf": "USA_FL_Tampa.Intl.AP.722110_TMY3.epw",
    "OptimalStart_RefBldgLargeOfficeNew2004_Chicago.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "OutdoorAirUnit.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "OutdoorAirUnitwithAirloopHVAC.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "PackagedTerminalAirConditioner.idf": "USA_FL_Miami.Intl.AP.722020_TMY3.epw",
    "PackagedTerminalAirConditionerVSAS.idf": "USA_FL_Miami.Intl.AP.722020_TMY3.epw",
    "PackagedTerminalHeatPump.idf": "USA_FL_Miami.Intl.AP.722020_TMY3.epw",
    "PackagedTerminalHeatPumpVSAS.idf": "USA_FL_Miami.Intl.AP.722020_TMY3.epw",
    "ParametricInsulation-5ZoneAirCooled.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "PassiveTrombeWall.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "PipeHeatTransfer_Outair.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "PipeHeatTransfer_Schedule.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "PipeHeatTransfer_Underground.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "PipeHeatTransfer_Zone.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "PipingSystem_Underground_FHX.idf": "USA_CO_Golden-NREL.724666_TMY3.epw",
    "PipingSystem_Underground_TwoPipe_FD_GroundTemps.idf": "USA_CO_Golden-NREL.724666_TMY3.epw",
    "PipingSystem_Underground_TwoPipe.idf": "USA_CO_Golden-NREL.724666_TMY3.epw",
    "PipingSystem_Underground_TwoPipe_Xing_GroundTemps.idf": "USA_CO_Golden-NREL.724666_TMY3.epw",
    "PIUAuto.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "PlantApplicationsGuide_Example1.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "PlantApplicationsGuide_Example2.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "PlantApplicationsGuide_Example3.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "PlantComponentTemperatureSource.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "PlantHorizontalGroundHX.idf": "USA_CO_Golden-NREL.724666_TMY3.epw",
    "PlantLoadProfile_AutosizedDistrictHeating.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "PlantLoadProfileCoolingReturnReset.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "PlantLoadProfileCoolingReturnResetLookup.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "PlantLoadProfile.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "PlantLoopChainCooling.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "PlantLoopChainDeadband.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "PlantLoopChainDualDeadband.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "PlantLoopChainHeating.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "PlantLoopHeatPump_EIR_AirSource.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "PlantLoopHeatPump_EIR_WaterSource.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "PlantPressureDrop.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "PlantPressure_PumpCurve.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "PlantPressure_VFD_Scheduled.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "PlateHeatExchanger.idf": "USA_FL_Tampa.Intl.AP.722110_TMY3.epw",
    "Plenum.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "PlenumwithRetAirHeatGain.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "PondGroundHeatExchanger.idf": "USA_AZ_Phoenix-Sky.Harbor.Intl.AP.722780_TMY3.epw",
    "PurchAirTables.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "PurchAirTables_SQL.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "PurchAirTables_wAnnual.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "_PurchAirWindowBlind2.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "_PurchAirWindowBlind3.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "_PurchAirWindowBlind4.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "PurchAirWindowBlind_BlockBeamSolar.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "PurchAirWindowBlind.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "PurchAirWithDaylightingAndShadeControl.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "PurchAirWithDaylightingAngleFac.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "PurchAirWithDaylighting.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "PurchAirWithDoubleFacadeDaylighting.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "PythonPluginAirflowNetworkOpeningControlByHumidity.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "PythonPluginConstantVolumePurchasedAir.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "PythonPluginCurveOverride_PackagedTerminalHeatPump.idf": "USA_FL_Miami.Intl.AP.722020_TMY3.epw",
    "PythonPluginCustomOutputVariable.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "PythonPluginCustomSchedule.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "PythonPluginCustomTrendVariable.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "PythonPluginDemandManager_LargeOffice.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "PythonPluginDiscreteAirSystemSizes.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "PythonPluginLrgOff_GridStorageSmoothing.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "PythonPluginPlantLoopOverrideControl.idf": "USA_FL_Orlando.Intl.AP.722050_TMY3.epw",
    "PythonPluginPlantOperation_largeOff.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "PythonPluginReplaceTraditionalManagers_LargeOffice.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "PythonPluginTestMathAndKill.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "PythonPluginThermochromicWindow.idf": "USA_NV_Las.Vegas-McCarran.Intl.AP.723860_TMY3.epw",
    "PythonPluginUserDefined5ZoneAirCooled.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "PythonPluginUserDefinedWindACAuto.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "PythonPluginWindowShadeControl.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "QTFtest.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "RadHiTempElecTermReheat.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "RadHiTempGasCtrlOpt.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "RadHiTempGasTermReheat.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "RadLoHydrHeatCoolAutoCondFD.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "RadLoHydrHeatCoolAuto.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "RadLoTempCFloChangeoverDelay.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "RadLoTempCFloCtrlOpt2.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "RadLoTempCFloCtrlOpt3.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "RadLoTempCFloHeatCool_AddedAutosizing.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "RadLoTempCFloHeatCoolCondFD.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "RadLoTempCFloHeatCool.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "RadLoTempCFloHeatCoolRMT.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "RadLoTempCFloISOPipeHT.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "RadLoTempCFloTermReheat.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "RadLoTempElecCtrlOpt2.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "RadLoTempElecTermReheatCondFD.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "RadLoTempElecTermReheat.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "RadLoTempHydrChangeoverDelay.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "RadLoTempHydrCoolTowerCondFD.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "RadLoTempHydrCoolTower.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "RadLoTempHydrCtrlOpt2.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "RadLoTempHydrCtrlOpt3.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "RadLoTempHydrCtrlOpt.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "RadLoTempHydrHeatCool2D.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "RadLoTempHydrHeatCoolDryCondFD.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "RadLoTempHydrHeatCoolDry.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "RadLoTempHydrHeatCool.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "RadLoTempHydrHeatCoolMultiZone.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "RadLoTempHydrInterMulti.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "RadLoTempHydrISOPipeHT.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "RadLoTempHydrMulti10.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "RadLoTempHydrTermReheat.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "RefBldgFullServiceRestaurantNew2004_Chicago.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "RefBldgHospitalNew2004_Chicago.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "RefBldgLargeHotelNew2004_Chicago.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "RefBldgLargeOfficeNew2004_Chicago.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "RefBldgLargeOfficeNew2004_Chicago-ReturnReset.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "RefBldgMediumOfficeNew2004_Chicago_epJSON.epJSON": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "RefBldgMediumOfficeNew2004_Chicago.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "RefBldgMediumOfficeNew2004_Chicago_JSON_Outputs.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "RefBldgMediumOfficeNew2004_Chicago_OutputControl.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "RefBldgMidriseApartmentNew2004_Chicago.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "RefBldgOutPatientNew2004_Chicago.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "RefBldgPrimarySchoolNew2004_Chicago.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "RefBldgQuickServiceRestaurantNew2004_Chicago.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "RefBldgSecondarySchoolNew2004_Chicago.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "RefBldgSmallHotelNew2004_Chicago.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "RefBldgSmallOfficeNew2004_Chicago.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "RefBldgStand-aloneRetailNew2004_Chicago.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "RefBldgStripMallNew2004_Chicago.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "RefBldgSuperMarketNew2004_Chicago.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "RefBldgWarehouseNew2004_Chicago.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "ReflectiveAdjacentBuilding.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "RefMedOffVAVAllDefVRP.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "RefrigeratedWarehouse.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "ReliefIndEvapCoolerRTUoffice.idf": "USA_AZ_Phoenix-Sky.Harbor.Intl.AP.722780_TMY3.epw",
    "ReportDaylightFactors.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "ReportHeatEmission_RefFSRestaurant.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "RetailPackagedTESCoil.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "RoomAirflowNetwork.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "SeriesActiveBranch.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "ShopWithPVandBattery.idf": "USA_OK_Oklahoma.City-Will.Rogers.World.AP.723530_TMY3.epw",
    "ShopWithPVandStorage.idf": "USA_OK_Oklahoma.City-Will.Rogers.World.AP.723530_TMY3.epw",
    "ShopWithSimplePVT.idf": "USA_OK_Oklahoma.City-Will.Rogers.World.AP.723530_TMY3.epw",
    "SingleFamilyHouse_TwoSpeed_CutoutTemperature.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "SingleFamilyHouse_TwoSpeed_ZoneAirBalance.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "_SingleZoneTestCondFDTwoDD.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "_SingleZoneTestCTFTwoDD.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "SmallOffice_CentralDOAS.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "_SmallOffice_Dulles.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "SmOffPSZ.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "SmOffPSZ-MultiModeDX.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "SmOffPSZ_OnOffStagedControl.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "SolarCollectorFlatPlateWater.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "SolarShadingTest_DisableSelfShadingGroup.idf": "USA_AZ_Phoenix-Sky.Harbor.Intl.AP.722780_TMY3.epw",
    "SolarShadingTest_DisableSelfShading.idf": "USA_AZ_Phoenix-Sky.Harbor.Intl.AP.722780_TMY3.epw",
    "SolarShadingTest_ExternalFraction.idf": "USA_AZ_Phoenix-Sky.Harbor.Intl.AP.722780_TMY3.epw",
    "SolarShadingTestGPU.idf": "USA_AZ_Phoenix-Sky.Harbor.Intl.AP.722780_TMY3.epw",
    "SolarShadingTest.idf": "USA_AZ_Phoenix-Sky.Harbor.Intl.AP.722780_TMY3.epw",
    "SolarShadingTest_ImportedShading.idf": "USA_AZ_Phoenix-Sky.Harbor.Intl.AP.722780_TMY3.epw",
    "SolarShadingTest_SQL.idf": "USA_AZ_Phoenix-Sky.Harbor.Intl.AP.722780_TMY3.epw",
    "SpectralAngularOpticalProperties_TableData.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "StackedZonesWithInterzoneIRTLayers.idf": "USA_IL_University.of.Illinois-Willard.AP.725315_TMY3.epw",
    "SteamSystemAutoSize.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "StormWindow.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "StripMallZoneEvapCoolerAutosized.idf": "USA_CO_Boulder-Broomfield-Jefferson.County.AP.724699_TMY3.epw",
    "StripMallZoneEvapCooler.idf": "USA_CO_Boulder-Broomfield-Jefferson.County.AP.724699_TMY3.epw",
    "Supermarket_CascadeCond.idf": "USA_FL_Miami.Intl.AP.722020_TMY3.epw",
    "SuperMarket_DesuperHeatingCoil.idf": "USA_FL_Miami.Intl.AP.722020_TMY3.epw",
    "SuperMarketDetailed_DesuperHeatingCoil.idf": "USA_FL_Miami.Intl.AP.722020_TMY3.epw",
    "SuperMarket_DetailedEvapCondenser.idf": "USA_AZ_Phoenix-Sky.Harbor.Intl.AP.722780_TMY3.epw",
    "Supermarket_Detailed.idf": "USA_FL_Miami.Intl.AP.722020_TMY3.epw",
    "SuperMarket_DetailedWaterCondenser.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "SuperMarket_EvapCondenser.idf": "USA_AZ_Phoenix-Sky.Harbor.Intl.AP.722780_TMY3.epw",
    "Supermarket.idf": "USA_FL_Miami.Intl.AP.722020_TMY3.epw",
    "SupermarketSecondary.idf": "USA_AZ_Phoenix-Sky.Harbor.Intl.AP.722780_TMY3.epw",
    "Supermarket_SharedAirCondenser.idf": "USA_FL_Miami.Intl.AP.722020_TMY3.epw",
    "SuperMarket_SharedEvapCondenser.idf": "USA_FL_Miami.Intl.AP.722020_TMY3.epw",
    "SupermarketSubCoolersVariableSuction.idf": "USA_FL_Miami.Intl.AP.722020_TMY3.epw",
    "SupermarketTranscriticalCO2.idf": "USA_FL_Miami.Intl.AP.722020_TMY3.epw",
    "SupermarketTwoStageFlashIntercooler.idf": "USA_FL_Miami.Intl.AP.722020_TMY3.epw",
    "SupermarketTwoStageShellCoilIntercooler.idf": "USA_FL_Miami.Intl.AP.722020_TMY3.epw",
    "SuperMarket_WaterCondenser.idf": "USA_FL_Miami.Intl.AP.722020_TMY3.epw",
    "SupplyPlenumVAV.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "SurfaceGroundHeatExchanger.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "SurfaceHeatSourceTerm_RefBldgSmallOfficeNew2004.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "SurfacePropTest_SurfLWR.idf": "USA_AZ_Phoenix-Sky.Harbor.Intl.AP.722780_TMY3.epw",
    "SurfaceTest.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "SurfaceZonePropTest_LocalEnv.idf": "USA_AZ_Phoenix-Sky.Harbor.Intl.AP.722780_TMY3.epw",
    "TermReheat.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "TermReheatPri-SecLoop.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "TermReheatScheduledPump.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "TermReheatSurfTC.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "TermReheatZoneExh.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "TermRhDualSetpointWithDB.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "TermRHDXSystem.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "TermRHGasElecCoils.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "TermRhGenericOAHeatRecMinExh.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "TermRhGenericOAHeatRecPreheat.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "TermRhSingleHeatCoolNoDB.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "ThermalChimneyTest.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "ThermochromicWindow.idf": "USA_NV_Las.Vegas-McCarran.Intl.AP.723860_TMY3.epw",
    "TransparentInsulationSimple.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "TranspiredCollectors.idf": "USA_CO_Boulder-Broomfield-Jefferson.County.AP.724699_TMY3.epw",
    "TRHConstFlowChillerOneBranch.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "TRHEvapCoolerOAStaged.idf": "USA_AZ_Phoenix-Sky.Harbor.Intl.AP.722780_TMY3.epw",
    "TRHEvapCoolerOAStagedWetCoil.idf": "USA_AZ_Phoenix-Sky.Harbor.Intl.AP.722780_TMY3.epw",
    "TwoWayCommonPipe_Pri-Sec.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "UnitaryHybridAC_DedicatedOutsideAir.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "UnitarySystem_5ZoneWaterLoopHeatPump.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "UnitarySystem_DXCoilSystemAuto.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "UnitarySystem_FurnaceWithDXSystemRHcontrol.idf": "USA_FL_Miami.Intl.AP.722020_TMY3.epw",
    "UnitarySystem_HeatPumpAuto.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "UnitarySystem_MultiSpeedCoils_SingleMode.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "UnitarySystem_MultiSpeedDX.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "UnitarySystem_SingleSpeedDX.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "UnitarySystem_SubcoolReheatDX.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "UnitarySystem_TwoSpeedDX.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "UnitarySystem_TwoStageDX.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "UnitarySystem_TwoStageDXWithHumidityControl.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "UnitarySystem_VSCoolingCoil.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "UnitarySystem_VSHeatPumpWaterToAirEquationFit.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "UnitarySystem_WaterCoils_wMultiSpeedFan.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "UnitHeaterAuto.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "UnitHeaterGasElec.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "UnitHeater.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "UnitVent5ZoneAuto-CycFan2-Variable-MinOAOn-Annual-SelectMonths-Detailed.idf":
        "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "UnitVent5ZoneAuto.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "UnitVent5ZoneFixedOANoCoilOpt.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "UnitVent5Zone.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "UserDefinedRoomAirPatterns.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "UserInputViewFactorFile-LshapedZone.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "VariableRefrigerantFlow_5Zone.idf": "USA_FL_Miami.Intl.AP.722020_TMY3.epw",
    "VariableRefrigerantFlow_5Zone_wAirloop.idf": "USA_FL_Miami.Intl.AP.722020_TMY3.epw",
    "VariableRefrigerantFlow_FluidTCtrl_5Zone.idf": "USA_FL_Miami.Intl.AP.722020_TMY3.epw",
    "VariableRefrigerantFlow_FluidTCtrl_HR_5Zone.idf": "USA_FL_Miami.Intl.AP.722020_TMY3.epw",
    "VariableRefrigerantFlow_FluidTCtrl_wSuppHeater_5Zone.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "VariableRefrigerantFlow_wSuppHeater_5Zone.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "VaryingLocationAndOrientation.idf": "USA_CO_Golden-NREL.724666_TMY3.epw",
    "VAVSingleDuctConstFlowBoiler.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "_VAVSingleDuctConstFlowBoiler_otherfuel.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "VAVSingleDuctReheatBaseboard.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "VAVSingleDuctReheat_DualMax.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "VAVSingleDuctReheat.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "VAVSingleDuctReheat_MaxSAT_ReverseActing.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "VAVSingleDuctReheatNoReheat.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "VAVSingleDuctVarFlowBoiler.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "VentilatedSlab.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "VentilatedSlab_SeriesSlabs.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "VentilationSimpleTest.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "VSDXCoilSystemAuto.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "VSHeatPumpWaterHeater.idf": "USA_FL_Miami.Intl.AP.722020_TMY3.epw",
    "VSHeatPumpWaterToAirEquationFit.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "VSHeatPumpWaterToAirWithRHControl.idf": "USA_FL_Miami.Intl.AP.722020_TMY3.epw",
    "VSWaterHeaterHeatPumpStratifiedTank.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "WaterHeaterDHWPlantLoop.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "WaterHeaterHeatPumpStratifiedTank.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "WaterHeaterHeatPumpWrappedCondenser.idf": "USA_FL_Miami.Intl.AP.722020_TMY3.epw",
    "WaterHeaterStandAlone.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "WaterSideEconomizer_Integrated.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "WaterSideEconomizer_NonIntegrated.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "WCE_Diffuse_Shade.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "WCE_DoubleClear_BSDF.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "WCE_Interior_VB_-45_deg.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "WeatherTimeBins.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "WindACAirtoAir.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "WindACAuto.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "WindACRHControl.idf": "USA_FL_Miami.Intl.AP.722020_TMY3.epw",
    "WindowTests.idf": "USA_CO_Golden-NREL.724666_TMY3.epw",
    "WindowTestsSimple.idf": "USA_CO_Golden-NREL.724666_TMY3.epw",
    "WWHPSimpleAuto.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "ZoneCoupledGroundHTBasement.idf": "USA_CO_Golden-NREL.724666_TMY3.epw",
    "ZoneCoupledGroundHTSlabInGrade.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "ZoneCoupledGroundHTSlabOnGrade.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "ZoneCoupledKivaBasementAdaptiveConvection.idf": "USA_CO_Golden-NREL.724666_TMY3.epw",
    "ZoneCoupledKivaBasement.idf": "USA_CO_Golden-NREL.724666_TMY3.epw",
    "ZoneCoupledKivaConvectionAdaptiveSmallOffice.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "ZoneCoupledKivaConvection.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "ZoneCoupledKivaRefBldgMediumOffice.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "ZoneCoupledKivaRefBldgMediumOfficeNoClg.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "ZoneCoupledKivaSlab.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
    "ZoneCoupledKivaWalkoutBasement.idf": "USA_CO_Golden-NREL.724666_TMY3.epw",
    "ZoneSysAvailManager.idf": "USA_CO_Golden-NREL.724666_TMY3.epw",
    "ZoneVSWSHP_wDOAS.idf": "USA_CO_Golden-NREL.724666_TMY3.epw",
    "ZoneWSHP_wDOAS.idf": "USA_IL_Chicago-OHare.Intl.AP.725300_TMY3.epw",
}


def get_epw_for_idf(repo_source_dir: str, idf: str) -> Union[None, str]:
    """
    Tries to get the correct EPW for an IDF.

    The repo source tree should be known based on the build type (VS, Make, Install).  If it contains a "testfiles"
    directory, then "testfiles/CMakeLists.txt" is searched for the correct EPW.  If not, the list above is used. If
    it still cannot be found, then None is returned, and the diff engine will use a default as needed.

    The IDF should be relative to the root of the testfiles directory, so like: "1ZoneEvapCooler.idf", or
    "BasicsFiles/ThisTest1.idf"

    :param repo_source_dir:
    :param idf:
    :return:
    """
    if not os.path.exists(repo_source_dir):
        return None
    test_files_dir = os.path.join(repo_source_dir, 'testfiles')
    if os.path.exists(test_files_dir):
        # it appears we have a build folder
        cmake_lists = os.path.join(test_files_dir, 'CMakeLists.txt')
        if os.path.exists(cmake_lists):
            # it appears we can look up the IDF in this file
            with open(cmake_lists) as f_cmake:
                lines = f_cmake.readlines()
            for line in lines:
                cleaned = line.strip()
                if cleaned.startswith('#'):
                    continue
                if idf in cleaned:
                    tokens = cleaned.split(" ")
                    if len(tokens) >= 4:
                        potential_epw_token = tokens[3]
                        if potential_epw_token.endswith(')'):
                            return potential_epw_token[:-1]
                        else:
                            return tokens[3]
        else:
            # something is weird, just return None
            return None
    else:
        # it appears we have an e+ install folder, try to look up the value, return None if not found
        return epw_map.get(idf, None)
    # if something went really awry, just return None to use to the default
    return None
