from asyncio import Protocol
from typing import Dict, Tuple

from tarsier.adapter import AnyDriver, BrowserAdapter, adapter_factory


class ITarsier(Protocol):
    async def page_to_image(self, driver: AnyDriver) -> Tuple[bytes, Dict[int, str]]:
        raise NotImplementedError()

    async def page_to_text(self, driver: AnyDriver) -> Tuple[str, Dict[int, str]]:
        raise NotImplementedError()
