# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WirelessSsidsArgs', 'WirelessSsids']

@pulumi.input_type
class WirelessSsidsArgs:
    def __init__(__self__, *,
                 network_id: pulumi.Input[_builtins.str],
                 number: pulumi.Input[_builtins.int],
                 active_directory: Optional[pulumi.Input['WirelessSsidsActiveDirectoryArgs']] = None,
                 adult_content_filtering_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ap_tags_and_vlan_ids: Optional[pulumi.Input[Sequence[pulumi.Input['WirelessSsidsApTagsAndVlanIdArgs']]]] = None,
                 auth_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 available_on_all_aps: Optional[pulumi.Input[_builtins.bool]] = None,
                 band_selection: Optional[pulumi.Input[_builtins.str]] = None,
                 concentrator_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 default_vlan_id: Optional[pulumi.Input[_builtins.int]] = None,
                 disassociate_clients_on_vpn_failover: Optional[pulumi.Input[_builtins.bool]] = None,
                 dns_rewrite: Optional[pulumi.Input['WirelessSsidsDnsRewriteArgs']] = None,
                 dot11r: Optional[pulumi.Input['WirelessSsidsDot11rArgs']] = None,
                 dot11w: Optional[pulumi.Input['WirelessSsidsDot11wArgs']] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_admin_access: Optional[pulumi.Input[_builtins.str]] = None,
                 gre: Optional[pulumi.Input['WirelessSsidsGreArgs']] = None,
                 ip_assignment_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 lan_isolation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ldap: Optional[pulumi.Input['WirelessSsidsLdapArgs']] = None,
                 local_radius: Optional[pulumi.Input['WirelessSsidsLocalRadiusArgs']] = None,
                 mandatory_dhcp_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 min_bitrate: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 named_vlans: Optional[pulumi.Input['WirelessSsidsNamedVlansArgs']] = None,
                 oauth: Optional[pulumi.Input['WirelessSsidsOauthArgs']] = None,
                 per_client_bandwidth_limit_down: Optional[pulumi.Input[_builtins.int]] = None,
                 per_client_bandwidth_limit_up: Optional[pulumi.Input[_builtins.int]] = None,
                 per_ssid_bandwidth_limit_down: Optional[pulumi.Input[_builtins.int]] = None,
                 per_ssid_bandwidth_limit_up: Optional[pulumi.Input[_builtins.int]] = None,
                 psk: Optional[pulumi.Input[_builtins.str]] = None,
                 radius_accounting_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 radius_accounting_interim_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 radius_accounting_servers: Optional[pulumi.Input[Sequence[pulumi.Input['WirelessSsidsRadiusAccountingServerArgs']]]] = None,
                 radius_attribute_for_group_policies: Optional[pulumi.Input[_builtins.str]] = None,
                 radius_authentication_nas_id: Optional[pulumi.Input[_builtins.str]] = None,
                 radius_called_station_id: Optional[pulumi.Input[_builtins.str]] = None,
                 radius_coa_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 radius_failover_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 radius_fallback_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 radius_guest_vlan_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 radius_guest_vlan_id: Optional[pulumi.Input[_builtins.int]] = None,
                 radius_load_balancing_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 radius_override: Optional[pulumi.Input[_builtins.bool]] = None,
                 radius_proxy_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 radius_server_attempts_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 radius_server_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 radius_servers: Optional[pulumi.Input[Sequence[pulumi.Input['WirelessSsidsRadiusServerArgs']]]] = None,
                 radius_testing_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 secondary_concentrator_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 speed_burst: Optional[pulumi.Input['WirelessSsidsSpeedBurstArgs']] = None,
                 splash_guest_sponsor_domains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 splash_page: Optional[pulumi.Input[_builtins.str]] = None,
                 use_vlan_tagging: Optional[pulumi.Input[_builtins.bool]] = None,
                 visible: Optional[pulumi.Input[_builtins.bool]] = None,
                 vlan_id: Optional[pulumi.Input[_builtins.int]] = None,
                 walled_garden_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 walled_garden_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 wpa_encryption_mode: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a WirelessSsids resource.
        :param pulumi.Input[_builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[_builtins.int] number: Unique identifier of the SSID
        :param pulumi.Input['WirelessSsidsActiveDirectoryArgs'] active_directory: The current setting for Active Directory. Only valid if splashPage is 'Password-protected with Active Directory'
        :param pulumi.Input[_builtins.bool] adult_content_filtering_enabled: Boolean indicating whether or not adult content will be blocked
        :param pulumi.Input[Sequence[pulumi.Input['WirelessSsidsApTagsAndVlanIdArgs']]] ap_tags_and_vlan_ids: The list of tags and VLAN IDs used for VLAN tagging. This param is only valid when the ipAssignmentMode is 'Bridge mode' or 'Layer 3 roaming'
        :param pulumi.Input[_builtins.str] auth_mode: The association control method for the SSID
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] availability_tags: List of tags for this SSID. If availableOnAllAps is false, then the SSID is only broadcast by APs with tags matching any of the tags in this list
        :param pulumi.Input[_builtins.bool] available_on_all_aps: Whether all APs broadcast the SSID or if it's restricted to APs matching any availability tags
        :param pulumi.Input[_builtins.str] band_selection: The client-serving radio frequencies of this SSID in the default indoor RF profile
        :param pulumi.Input[_builtins.str] concentrator_network_id: The concentrator to use when the ipAssignmentMode is 'Layer 3 roaming with a concentrator' or 'VPN'.
        :param pulumi.Input[_builtins.int] default_vlan_id: The default VLAN ID used for 'all other APs'. This param is only valid when the ipAssignmentMode is 'Bridge mode' or 'Layer 3 roaming'
        :param pulumi.Input[_builtins.bool] disassociate_clients_on_vpn_failover: Disassociate clients when 'VPN' concentrator failover occurs in order to trigger clients to re-associate and generate new DHCP requests. This param is only valid if ipAssignmentMode is 'VPN'.
        :param pulumi.Input['WirelessSsidsDnsRewriteArgs'] dns_rewrite: DNS servers rewrite settings
        :param pulumi.Input['WirelessSsidsDot11rArgs'] dot11r: The current setting for 802.11r
        :param pulumi.Input['WirelessSsidsDot11wArgs'] dot11w: The current setting for Protected Management Frames (802.11w).
        :param pulumi.Input[_builtins.bool] enabled: Whether or not the SSID is enabled
        :param pulumi.Input[_builtins.str] encryption_mode: The psk encryption mode for the SSID
        :param pulumi.Input[_builtins.str] enterprise_admin_access: Whether or not an SSID is accessible by 'enterprise' administrators ('access disabled' or 'access enabled')
        :param pulumi.Input['WirelessSsidsGreArgs'] gre: Ethernet over GRE settings
        :param pulumi.Input[_builtins.str] ip_assignment_mode: The client IP assignment mode
        :param pulumi.Input[_builtins.bool] lan_isolation_enabled: Boolean indicating whether Layer 2 LAN isolation should be enabled or disabled. Only configurable when ipAssignmentMode is 'Bridge mode'.
        :param pulumi.Input['WirelessSsidsLdapArgs'] ldap: The current setting for LDAP. Only valid if splashPage is 'Password-protected with LDAP'.
        :param pulumi.Input['WirelessSsidsLocalRadiusArgs'] local_radius: The current setting for Local Authentication, a built-in RADIUS server on the access point. Only valid if authMode is '8021x-localradius'.
        :param pulumi.Input[_builtins.bool] mandatory_dhcp_enabled: Whether clients connecting to this SSID must use the IP address assigned by the DHCP server
        :param pulumi.Input[_builtins.int] min_bitrate: The minimum bitrate in Mbps of this SSID in the default indoor RF profile
        :param pulumi.Input[_builtins.str] name: The name of the SSID
        :param pulumi.Input['WirelessSsidsNamedVlansArgs'] named_vlans: Named VLAN settings.
        :param pulumi.Input['WirelessSsidsOauthArgs'] oauth: The OAuth settings of this SSID. Only valid if splashPage is 'Google OAuth'.
        :param pulumi.Input[_builtins.int] per_client_bandwidth_limit_down: The download bandwidth limit in Kbps. (0 represents no limit.)
        :param pulumi.Input[_builtins.int] per_client_bandwidth_limit_up: The upload bandwidth limit in Kbps. (0 represents no limit.)
        :param pulumi.Input[_builtins.int] per_ssid_bandwidth_limit_down: The total download bandwidth limit in Kbps (0 represents no limit)
        :param pulumi.Input[_builtins.int] per_ssid_bandwidth_limit_up: The total upload bandwidth limit in Kbps (0 represents no limit)
        :param pulumi.Input[_builtins.str] psk: The passkey for the SSID. This param is only valid if the authMode is 'psk'
        :param pulumi.Input[_builtins.bool] radius_accounting_enabled: Whether or not RADIUS accounting is enabled
        :param pulumi.Input[_builtins.int] radius_accounting_interim_interval: The interval (in seconds) in which accounting information is updated and sent to the RADIUS accounting server.
        :param pulumi.Input[Sequence[pulumi.Input['WirelessSsidsRadiusAccountingServerArgs']]] radius_accounting_servers: List of RADIUS accounting 802.1X servers to be used for authentication
        :param pulumi.Input[_builtins.str] radius_attribute_for_group_policies: RADIUS attribute used to look up group policies
        :param pulumi.Input[_builtins.str] radius_authentication_nas_id: The template of the NAS identifier to be used for RADIUS authentication (ex. $NODE*MAC$:$VAP*NUM$).
        :param pulumi.Input[_builtins.str] radius_called_station_id: The template of the called station identifier to be used for RADIUS (ex. $NODE*MAC$:$VAP*NUM$).
        :param pulumi.Input[_builtins.bool] radius_coa_enabled: If true, Meraki devices will act as a RADIUS Dynamic Authorization Server and will respond to RADIUS Change-of-Authorization and Disconnect messages sent by the RADIUS server.
        :param pulumi.Input[_builtins.str] radius_failover_policy: Policy which determines how authentication requests should be handled in the event that all of the configured RADIUS servers are unreachable
        :param pulumi.Input[_builtins.bool] radius_fallback_enabled: Whether or not higher priority RADIUS servers should be retried after 60 seconds.
        :param pulumi.Input[_builtins.bool] radius_guest_vlan_enabled: Whether or not RADIUS Guest VLAN is enabled. This param is only valid if the authMode is 'open-with-radius' and addressing mode is not set to 'isolated' or 'nat' mode
        :param pulumi.Input[_builtins.int] radius_guest_vlan_id: VLAN ID of the RADIUS Guest VLAN. This param is only valid if the authMode is 'open-with-radius' and addressing mode is not set to 'isolated' or 'nat' mode
        :param pulumi.Input[_builtins.str] radius_load_balancing_policy: Policy which determines which RADIUS server will be contacted first in an authentication attempt, and the ordering of any necessary retry attempts
        :param pulumi.Input[_builtins.bool] radius_override: If true, the RADIUS response can override VLAN tag. This is not valid when ipAssignmentMode is 'NAT mode'.
        :param pulumi.Input[_builtins.bool] radius_proxy_enabled: If true, Meraki devices will proxy RADIUS messages through the Meraki cloud to the configured RADIUS auth and accounting servers.
        :param pulumi.Input[_builtins.int] radius_server_attempts_limit: The maximum number of transmit attempts after which a RADIUS server is failed over (must be between 1-5).
        :param pulumi.Input[_builtins.int] radius_server_timeout: The amount of time for which a RADIUS client waits for a reply from the RADIUS server (must be between 1-10 seconds).
        :param pulumi.Input[Sequence[pulumi.Input['WirelessSsidsRadiusServerArgs']]] radius_servers: The RADIUS 802.1X servers to be used for authentication. This param is only valid if the authMode is 'open-with-radius', '8021x-radius' or 'ipsk-with-radius'
        :param pulumi.Input[_builtins.bool] radius_testing_enabled: If true, Meraki devices will periodically send Access-Request messages to configured RADIUS servers using identity 'meraki*8021x*test' to ensure that the RADIUS servers are reachable.
        :param pulumi.Input[_builtins.str] secondary_concentrator_network_id: The secondary concentrator to use when the ipAssignmentMode is 'VPN'. If configured, the APs will switch to using this concentrator if the primary concentrator is unreachable. This param is optional. ('disabled' represents no secondary concentrator.)
        :param pulumi.Input['WirelessSsidsSpeedBurstArgs'] speed_burst: The SpeedBurst setting for this SSID'
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] splash_guest_sponsor_domains: Array of valid sponsor email domains for sponsored guest splash type.
        :param pulumi.Input[_builtins.str] splash_page: The type of splash page for the SSID
        :param pulumi.Input[_builtins.bool] use_vlan_tagging: Whether or not traffic should be directed to use specific VLANs. This param is only valid if the ipAssignmentMode is 'Bridge mode' or 'Layer 3 roaming'
        :param pulumi.Input[_builtins.bool] visible: Whether the SSID is advertised or hidden by the AP
        :param pulumi.Input[_builtins.int] vlan_id: The VLAN ID used for VLAN tagging. This param is only valid when the ipAssignmentMode is 'Layer 3 roaming with a concentrator' or 'VPN'
        :param pulumi.Input[_builtins.bool] walled_garden_enabled: Allow users to access a configurable list of IP ranges prior to sign-on
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] walled_garden_ranges: Domain names and IP address ranges available in Walled Garden mode
        :param pulumi.Input[_builtins.str] wpa_encryption_mode: The types of WPA encryption
        """
        pulumi.set(__self__, "network_id", network_id)
        pulumi.set(__self__, "number", number)
        if active_directory is not None:
            pulumi.set(__self__, "active_directory", active_directory)
        if adult_content_filtering_enabled is not None:
            pulumi.set(__self__, "adult_content_filtering_enabled", adult_content_filtering_enabled)
        if ap_tags_and_vlan_ids is not None:
            pulumi.set(__self__, "ap_tags_and_vlan_ids", ap_tags_and_vlan_ids)
        if auth_mode is not None:
            pulumi.set(__self__, "auth_mode", auth_mode)
        if availability_tags is not None:
            pulumi.set(__self__, "availability_tags", availability_tags)
        if available_on_all_aps is not None:
            pulumi.set(__self__, "available_on_all_aps", available_on_all_aps)
        if band_selection is not None:
            pulumi.set(__self__, "band_selection", band_selection)
        if concentrator_network_id is not None:
            pulumi.set(__self__, "concentrator_network_id", concentrator_network_id)
        if default_vlan_id is not None:
            pulumi.set(__self__, "default_vlan_id", default_vlan_id)
        if disassociate_clients_on_vpn_failover is not None:
            pulumi.set(__self__, "disassociate_clients_on_vpn_failover", disassociate_clients_on_vpn_failover)
        if dns_rewrite is not None:
            pulumi.set(__self__, "dns_rewrite", dns_rewrite)
        if dot11r is not None:
            pulumi.set(__self__, "dot11r", dot11r)
        if dot11w is not None:
            pulumi.set(__self__, "dot11w", dot11w)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if encryption_mode is not None:
            pulumi.set(__self__, "encryption_mode", encryption_mode)
        if enterprise_admin_access is not None:
            pulumi.set(__self__, "enterprise_admin_access", enterprise_admin_access)
        if gre is not None:
            pulumi.set(__self__, "gre", gre)
        if ip_assignment_mode is not None:
            pulumi.set(__self__, "ip_assignment_mode", ip_assignment_mode)
        if lan_isolation_enabled is not None:
            pulumi.set(__self__, "lan_isolation_enabled", lan_isolation_enabled)
        if ldap is not None:
            pulumi.set(__self__, "ldap", ldap)
        if local_radius is not None:
            pulumi.set(__self__, "local_radius", local_radius)
        if mandatory_dhcp_enabled is not None:
            pulumi.set(__self__, "mandatory_dhcp_enabled", mandatory_dhcp_enabled)
        if min_bitrate is not None:
            pulumi.set(__self__, "min_bitrate", min_bitrate)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if named_vlans is not None:
            pulumi.set(__self__, "named_vlans", named_vlans)
        if oauth is not None:
            pulumi.set(__self__, "oauth", oauth)
        if per_client_bandwidth_limit_down is not None:
            pulumi.set(__self__, "per_client_bandwidth_limit_down", per_client_bandwidth_limit_down)
        if per_client_bandwidth_limit_up is not None:
            pulumi.set(__self__, "per_client_bandwidth_limit_up", per_client_bandwidth_limit_up)
        if per_ssid_bandwidth_limit_down is not None:
            pulumi.set(__self__, "per_ssid_bandwidth_limit_down", per_ssid_bandwidth_limit_down)
        if per_ssid_bandwidth_limit_up is not None:
            pulumi.set(__self__, "per_ssid_bandwidth_limit_up", per_ssid_bandwidth_limit_up)
        if psk is not None:
            pulumi.set(__self__, "psk", psk)
        if radius_accounting_enabled is not None:
            pulumi.set(__self__, "radius_accounting_enabled", radius_accounting_enabled)
        if radius_accounting_interim_interval is not None:
            pulumi.set(__self__, "radius_accounting_interim_interval", radius_accounting_interim_interval)
        if radius_accounting_servers is not None:
            pulumi.set(__self__, "radius_accounting_servers", radius_accounting_servers)
        if radius_attribute_for_group_policies is not None:
            pulumi.set(__self__, "radius_attribute_for_group_policies", radius_attribute_for_group_policies)
        if radius_authentication_nas_id is not None:
            pulumi.set(__self__, "radius_authentication_nas_id", radius_authentication_nas_id)
        if radius_called_station_id is not None:
            pulumi.set(__self__, "radius_called_station_id", radius_called_station_id)
        if radius_coa_enabled is not None:
            pulumi.set(__self__, "radius_coa_enabled", radius_coa_enabled)
        if radius_failover_policy is not None:
            pulumi.set(__self__, "radius_failover_policy", radius_failover_policy)
        if radius_fallback_enabled is not None:
            pulumi.set(__self__, "radius_fallback_enabled", radius_fallback_enabled)
        if radius_guest_vlan_enabled is not None:
            pulumi.set(__self__, "radius_guest_vlan_enabled", radius_guest_vlan_enabled)
        if radius_guest_vlan_id is not None:
            pulumi.set(__self__, "radius_guest_vlan_id", radius_guest_vlan_id)
        if radius_load_balancing_policy is not None:
            pulumi.set(__self__, "radius_load_balancing_policy", radius_load_balancing_policy)
        if radius_override is not None:
            pulumi.set(__self__, "radius_override", radius_override)
        if radius_proxy_enabled is not None:
            pulumi.set(__self__, "radius_proxy_enabled", radius_proxy_enabled)
        if radius_server_attempts_limit is not None:
            pulumi.set(__self__, "radius_server_attempts_limit", radius_server_attempts_limit)
        if radius_server_timeout is not None:
            pulumi.set(__self__, "radius_server_timeout", radius_server_timeout)
        if radius_servers is not None:
            pulumi.set(__self__, "radius_servers", radius_servers)
        if radius_testing_enabled is not None:
            pulumi.set(__self__, "radius_testing_enabled", radius_testing_enabled)
        if secondary_concentrator_network_id is not None:
            pulumi.set(__self__, "secondary_concentrator_network_id", secondary_concentrator_network_id)
        if speed_burst is not None:
            pulumi.set(__self__, "speed_burst", speed_burst)
        if splash_guest_sponsor_domains is not None:
            pulumi.set(__self__, "splash_guest_sponsor_domains", splash_guest_sponsor_domains)
        if splash_page is not None:
            pulumi.set(__self__, "splash_page", splash_page)
        if use_vlan_tagging is not None:
            pulumi.set(__self__, "use_vlan_tagging", use_vlan_tagging)
        if visible is not None:
            pulumi.set(__self__, "visible", visible)
        if vlan_id is not None:
            pulumi.set(__self__, "vlan_id", vlan_id)
        if walled_garden_enabled is not None:
            pulumi.set(__self__, "walled_garden_enabled", walled_garden_enabled)
        if walled_garden_ranges is not None:
            pulumi.set(__self__, "walled_garden_ranges", walled_garden_ranges)
        if wpa_encryption_mode is not None:
            pulumi.set(__self__, "wpa_encryption_mode", wpa_encryption_mode)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[_builtins.str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "network_id", value)

    @_builtins.property
    @pulumi.getter
    def number(self) -> pulumi.Input[_builtins.int]:
        """
        Unique identifier of the SSID
        """
        return pulumi.get(self, "number")

    @number.setter
    def number(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "number", value)

    @_builtins.property
    @pulumi.getter(name="activeDirectory")
    def active_directory(self) -> Optional[pulumi.Input['WirelessSsidsActiveDirectoryArgs']]:
        """
        The current setting for Active Directory. Only valid if splashPage is 'Password-protected with Active Directory'
        """
        return pulumi.get(self, "active_directory")

    @active_directory.setter
    def active_directory(self, value: Optional[pulumi.Input['WirelessSsidsActiveDirectoryArgs']]):
        pulumi.set(self, "active_directory", value)

    @_builtins.property
    @pulumi.getter(name="adultContentFilteringEnabled")
    def adult_content_filtering_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean indicating whether or not adult content will be blocked
        """
        return pulumi.get(self, "adult_content_filtering_enabled")

    @adult_content_filtering_enabled.setter
    def adult_content_filtering_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "adult_content_filtering_enabled", value)

    @_builtins.property
    @pulumi.getter(name="apTagsAndVlanIds")
    def ap_tags_and_vlan_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WirelessSsidsApTagsAndVlanIdArgs']]]]:
        """
        The list of tags and VLAN IDs used for VLAN tagging. This param is only valid when the ipAssignmentMode is 'Bridge mode' or 'Layer 3 roaming'
        """
        return pulumi.get(self, "ap_tags_and_vlan_ids")

    @ap_tags_and_vlan_ids.setter
    def ap_tags_and_vlan_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WirelessSsidsApTagsAndVlanIdArgs']]]]):
        pulumi.set(self, "ap_tags_and_vlan_ids", value)

    @_builtins.property
    @pulumi.getter(name="authMode")
    def auth_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The association control method for the SSID
        """
        return pulumi.get(self, "auth_mode")

    @auth_mode.setter
    def auth_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auth_mode", value)

    @_builtins.property
    @pulumi.getter(name="availabilityTags")
    def availability_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of tags for this SSID. If availableOnAllAps is false, then the SSID is only broadcast by APs with tags matching any of the tags in this list
        """
        return pulumi.get(self, "availability_tags")

    @availability_tags.setter
    def availability_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "availability_tags", value)

    @_builtins.property
    @pulumi.getter(name="availableOnAllAps")
    def available_on_all_aps(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether all APs broadcast the SSID or if it's restricted to APs matching any availability tags
        """
        return pulumi.get(self, "available_on_all_aps")

    @available_on_all_aps.setter
    def available_on_all_aps(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "available_on_all_aps", value)

    @_builtins.property
    @pulumi.getter(name="bandSelection")
    def band_selection(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The client-serving radio frequencies of this SSID in the default indoor RF profile
        """
        return pulumi.get(self, "band_selection")

    @band_selection.setter
    def band_selection(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "band_selection", value)

    @_builtins.property
    @pulumi.getter(name="concentratorNetworkId")
    def concentrator_network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The concentrator to use when the ipAssignmentMode is 'Layer 3 roaming with a concentrator' or 'VPN'.
        """
        return pulumi.get(self, "concentrator_network_id")

    @concentrator_network_id.setter
    def concentrator_network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "concentrator_network_id", value)

    @_builtins.property
    @pulumi.getter(name="defaultVlanId")
    def default_vlan_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The default VLAN ID used for 'all other APs'. This param is only valid when the ipAssignmentMode is 'Bridge mode' or 'Layer 3 roaming'
        """
        return pulumi.get(self, "default_vlan_id")

    @default_vlan_id.setter
    def default_vlan_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "default_vlan_id", value)

    @_builtins.property
    @pulumi.getter(name="disassociateClientsOnVpnFailover")
    def disassociate_clients_on_vpn_failover(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Disassociate clients when 'VPN' concentrator failover occurs in order to trigger clients to re-associate and generate new DHCP requests. This param is only valid if ipAssignmentMode is 'VPN'.
        """
        return pulumi.get(self, "disassociate_clients_on_vpn_failover")

    @disassociate_clients_on_vpn_failover.setter
    def disassociate_clients_on_vpn_failover(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disassociate_clients_on_vpn_failover", value)

    @_builtins.property
    @pulumi.getter(name="dnsRewrite")
    def dns_rewrite(self) -> Optional[pulumi.Input['WirelessSsidsDnsRewriteArgs']]:
        """
        DNS servers rewrite settings
        """
        return pulumi.get(self, "dns_rewrite")

    @dns_rewrite.setter
    def dns_rewrite(self, value: Optional[pulumi.Input['WirelessSsidsDnsRewriteArgs']]):
        pulumi.set(self, "dns_rewrite", value)

    @_builtins.property
    @pulumi.getter
    def dot11r(self) -> Optional[pulumi.Input['WirelessSsidsDot11rArgs']]:
        """
        The current setting for 802.11r
        """
        return pulumi.get(self, "dot11r")

    @dot11r.setter
    def dot11r(self, value: Optional[pulumi.Input['WirelessSsidsDot11rArgs']]):
        pulumi.set(self, "dot11r", value)

    @_builtins.property
    @pulumi.getter
    def dot11w(self) -> Optional[pulumi.Input['WirelessSsidsDot11wArgs']]:
        """
        The current setting for Protected Management Frames (802.11w).
        """
        return pulumi.get(self, "dot11w")

    @dot11w.setter
    def dot11w(self, value: Optional[pulumi.Input['WirelessSsidsDot11wArgs']]):
        pulumi.set(self, "dot11w", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not the SSID is enabled
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="encryptionMode")
    def encryption_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The psk encryption mode for the SSID
        """
        return pulumi.get(self, "encryption_mode")

    @encryption_mode.setter
    def encryption_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encryption_mode", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseAdminAccess")
    def enterprise_admin_access(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether or not an SSID is accessible by 'enterprise' administrators ('access disabled' or 'access enabled')
        """
        return pulumi.get(self, "enterprise_admin_access")

    @enterprise_admin_access.setter
    def enterprise_admin_access(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_admin_access", value)

    @_builtins.property
    @pulumi.getter
    def gre(self) -> Optional[pulumi.Input['WirelessSsidsGreArgs']]:
        """
        Ethernet over GRE settings
        """
        return pulumi.get(self, "gre")

    @gre.setter
    def gre(self, value: Optional[pulumi.Input['WirelessSsidsGreArgs']]):
        pulumi.set(self, "gre", value)

    @_builtins.property
    @pulumi.getter(name="ipAssignmentMode")
    def ip_assignment_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The client IP assignment mode
        """
        return pulumi.get(self, "ip_assignment_mode")

    @ip_assignment_mode.setter
    def ip_assignment_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_assignment_mode", value)

    @_builtins.property
    @pulumi.getter(name="lanIsolationEnabled")
    def lan_isolation_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean indicating whether Layer 2 LAN isolation should be enabled or disabled. Only configurable when ipAssignmentMode is 'Bridge mode'.
        """
        return pulumi.get(self, "lan_isolation_enabled")

    @lan_isolation_enabled.setter
    def lan_isolation_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "lan_isolation_enabled", value)

    @_builtins.property
    @pulumi.getter
    def ldap(self) -> Optional[pulumi.Input['WirelessSsidsLdapArgs']]:
        """
        The current setting for LDAP. Only valid if splashPage is 'Password-protected with LDAP'.
        """
        return pulumi.get(self, "ldap")

    @ldap.setter
    def ldap(self, value: Optional[pulumi.Input['WirelessSsidsLdapArgs']]):
        pulumi.set(self, "ldap", value)

    @_builtins.property
    @pulumi.getter(name="localRadius")
    def local_radius(self) -> Optional[pulumi.Input['WirelessSsidsLocalRadiusArgs']]:
        """
        The current setting for Local Authentication, a built-in RADIUS server on the access point. Only valid if authMode is '8021x-localradius'.
        """
        return pulumi.get(self, "local_radius")

    @local_radius.setter
    def local_radius(self, value: Optional[pulumi.Input['WirelessSsidsLocalRadiusArgs']]):
        pulumi.set(self, "local_radius", value)

    @_builtins.property
    @pulumi.getter(name="mandatoryDhcpEnabled")
    def mandatory_dhcp_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether clients connecting to this SSID must use the IP address assigned by the DHCP server
        """
        return pulumi.get(self, "mandatory_dhcp_enabled")

    @mandatory_dhcp_enabled.setter
    def mandatory_dhcp_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "mandatory_dhcp_enabled", value)

    @_builtins.property
    @pulumi.getter(name="minBitrate")
    def min_bitrate(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The minimum bitrate in Mbps of this SSID in the default indoor RF profile
        """
        return pulumi.get(self, "min_bitrate")

    @min_bitrate.setter
    def min_bitrate(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_bitrate", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the SSID
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="namedVlans")
    def named_vlans(self) -> Optional[pulumi.Input['WirelessSsidsNamedVlansArgs']]:
        """
        Named VLAN settings.
        """
        return pulumi.get(self, "named_vlans")

    @named_vlans.setter
    def named_vlans(self, value: Optional[pulumi.Input['WirelessSsidsNamedVlansArgs']]):
        pulumi.set(self, "named_vlans", value)

    @_builtins.property
    @pulumi.getter
    def oauth(self) -> Optional[pulumi.Input['WirelessSsidsOauthArgs']]:
        """
        The OAuth settings of this SSID. Only valid if splashPage is 'Google OAuth'.
        """
        return pulumi.get(self, "oauth")

    @oauth.setter
    def oauth(self, value: Optional[pulumi.Input['WirelessSsidsOauthArgs']]):
        pulumi.set(self, "oauth", value)

    @_builtins.property
    @pulumi.getter(name="perClientBandwidthLimitDown")
    def per_client_bandwidth_limit_down(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The download bandwidth limit in Kbps. (0 represents no limit.)
        """
        return pulumi.get(self, "per_client_bandwidth_limit_down")

    @per_client_bandwidth_limit_down.setter
    def per_client_bandwidth_limit_down(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "per_client_bandwidth_limit_down", value)

    @_builtins.property
    @pulumi.getter(name="perClientBandwidthLimitUp")
    def per_client_bandwidth_limit_up(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The upload bandwidth limit in Kbps. (0 represents no limit.)
        """
        return pulumi.get(self, "per_client_bandwidth_limit_up")

    @per_client_bandwidth_limit_up.setter
    def per_client_bandwidth_limit_up(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "per_client_bandwidth_limit_up", value)

    @_builtins.property
    @pulumi.getter(name="perSsidBandwidthLimitDown")
    def per_ssid_bandwidth_limit_down(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The total download bandwidth limit in Kbps (0 represents no limit)
        """
        return pulumi.get(self, "per_ssid_bandwidth_limit_down")

    @per_ssid_bandwidth_limit_down.setter
    def per_ssid_bandwidth_limit_down(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "per_ssid_bandwidth_limit_down", value)

    @_builtins.property
    @pulumi.getter(name="perSsidBandwidthLimitUp")
    def per_ssid_bandwidth_limit_up(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The total upload bandwidth limit in Kbps (0 represents no limit)
        """
        return pulumi.get(self, "per_ssid_bandwidth_limit_up")

    @per_ssid_bandwidth_limit_up.setter
    def per_ssid_bandwidth_limit_up(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "per_ssid_bandwidth_limit_up", value)

    @_builtins.property
    @pulumi.getter
    def psk(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The passkey for the SSID. This param is only valid if the authMode is 'psk'
        """
        return pulumi.get(self, "psk")

    @psk.setter
    def psk(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "psk", value)

    @_builtins.property
    @pulumi.getter(name="radiusAccountingEnabled")
    def radius_accounting_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not RADIUS accounting is enabled
        """
        return pulumi.get(self, "radius_accounting_enabled")

    @radius_accounting_enabled.setter
    def radius_accounting_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "radius_accounting_enabled", value)

    @_builtins.property
    @pulumi.getter(name="radiusAccountingInterimInterval")
    def radius_accounting_interim_interval(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The interval (in seconds) in which accounting information is updated and sent to the RADIUS accounting server.
        """
        return pulumi.get(self, "radius_accounting_interim_interval")

    @radius_accounting_interim_interval.setter
    def radius_accounting_interim_interval(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "radius_accounting_interim_interval", value)

    @_builtins.property
    @pulumi.getter(name="radiusAccountingServers")
    def radius_accounting_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WirelessSsidsRadiusAccountingServerArgs']]]]:
        """
        List of RADIUS accounting 802.1X servers to be used for authentication
        """
        return pulumi.get(self, "radius_accounting_servers")

    @radius_accounting_servers.setter
    def radius_accounting_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WirelessSsidsRadiusAccountingServerArgs']]]]):
        pulumi.set(self, "radius_accounting_servers", value)

    @_builtins.property
    @pulumi.getter(name="radiusAttributeForGroupPolicies")
    def radius_attribute_for_group_policies(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        RADIUS attribute used to look up group policies
        """
        return pulumi.get(self, "radius_attribute_for_group_policies")

    @radius_attribute_for_group_policies.setter
    def radius_attribute_for_group_policies(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "radius_attribute_for_group_policies", value)

    @_builtins.property
    @pulumi.getter(name="radiusAuthenticationNasId")
    def radius_authentication_nas_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The template of the NAS identifier to be used for RADIUS authentication (ex. $NODE*MAC$:$VAP*NUM$).
        """
        return pulumi.get(self, "radius_authentication_nas_id")

    @radius_authentication_nas_id.setter
    def radius_authentication_nas_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "radius_authentication_nas_id", value)

    @_builtins.property
    @pulumi.getter(name="radiusCalledStationId")
    def radius_called_station_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The template of the called station identifier to be used for RADIUS (ex. $NODE*MAC$:$VAP*NUM$).
        """
        return pulumi.get(self, "radius_called_station_id")

    @radius_called_station_id.setter
    def radius_called_station_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "radius_called_station_id", value)

    @_builtins.property
    @pulumi.getter(name="radiusCoaEnabled")
    def radius_coa_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, Meraki devices will act as a RADIUS Dynamic Authorization Server and will respond to RADIUS Change-of-Authorization and Disconnect messages sent by the RADIUS server.
        """
        return pulumi.get(self, "radius_coa_enabled")

    @radius_coa_enabled.setter
    def radius_coa_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "radius_coa_enabled", value)

    @_builtins.property
    @pulumi.getter(name="radiusFailoverPolicy")
    def radius_failover_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Policy which determines how authentication requests should be handled in the event that all of the configured RADIUS servers are unreachable
        """
        return pulumi.get(self, "radius_failover_policy")

    @radius_failover_policy.setter
    def radius_failover_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "radius_failover_policy", value)

    @_builtins.property
    @pulumi.getter(name="radiusFallbackEnabled")
    def radius_fallback_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not higher priority RADIUS servers should be retried after 60 seconds.
        """
        return pulumi.get(self, "radius_fallback_enabled")

    @radius_fallback_enabled.setter
    def radius_fallback_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "radius_fallback_enabled", value)

    @_builtins.property
    @pulumi.getter(name="radiusGuestVlanEnabled")
    def radius_guest_vlan_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not RADIUS Guest VLAN is enabled. This param is only valid if the authMode is 'open-with-radius' and addressing mode is not set to 'isolated' or 'nat' mode
        """
        return pulumi.get(self, "radius_guest_vlan_enabled")

    @radius_guest_vlan_enabled.setter
    def radius_guest_vlan_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "radius_guest_vlan_enabled", value)

    @_builtins.property
    @pulumi.getter(name="radiusGuestVlanId")
    def radius_guest_vlan_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        VLAN ID of the RADIUS Guest VLAN. This param is only valid if the authMode is 'open-with-radius' and addressing mode is not set to 'isolated' or 'nat' mode
        """
        return pulumi.get(self, "radius_guest_vlan_id")

    @radius_guest_vlan_id.setter
    def radius_guest_vlan_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "radius_guest_vlan_id", value)

    @_builtins.property
    @pulumi.getter(name="radiusLoadBalancingPolicy")
    def radius_load_balancing_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Policy which determines which RADIUS server will be contacted first in an authentication attempt, and the ordering of any necessary retry attempts
        """
        return pulumi.get(self, "radius_load_balancing_policy")

    @radius_load_balancing_policy.setter
    def radius_load_balancing_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "radius_load_balancing_policy", value)

    @_builtins.property
    @pulumi.getter(name="radiusOverride")
    def radius_override(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, the RADIUS response can override VLAN tag. This is not valid when ipAssignmentMode is 'NAT mode'.
        """
        return pulumi.get(self, "radius_override")

    @radius_override.setter
    def radius_override(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "radius_override", value)

    @_builtins.property
    @pulumi.getter(name="radiusProxyEnabled")
    def radius_proxy_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, Meraki devices will proxy RADIUS messages through the Meraki cloud to the configured RADIUS auth and accounting servers.
        """
        return pulumi.get(self, "radius_proxy_enabled")

    @radius_proxy_enabled.setter
    def radius_proxy_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "radius_proxy_enabled", value)

    @_builtins.property
    @pulumi.getter(name="radiusServerAttemptsLimit")
    def radius_server_attempts_limit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of transmit attempts after which a RADIUS server is failed over (must be between 1-5).
        """
        return pulumi.get(self, "radius_server_attempts_limit")

    @radius_server_attempts_limit.setter
    def radius_server_attempts_limit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "radius_server_attempts_limit", value)

    @_builtins.property
    @pulumi.getter(name="radiusServerTimeout")
    def radius_server_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of time for which a RADIUS client waits for a reply from the RADIUS server (must be between 1-10 seconds).
        """
        return pulumi.get(self, "radius_server_timeout")

    @radius_server_timeout.setter
    def radius_server_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "radius_server_timeout", value)

    @_builtins.property
    @pulumi.getter(name="radiusServers")
    def radius_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WirelessSsidsRadiusServerArgs']]]]:
        """
        The RADIUS 802.1X servers to be used for authentication. This param is only valid if the authMode is 'open-with-radius', '8021x-radius' or 'ipsk-with-radius'
        """
        return pulumi.get(self, "radius_servers")

    @radius_servers.setter
    def radius_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WirelessSsidsRadiusServerArgs']]]]):
        pulumi.set(self, "radius_servers", value)

    @_builtins.property
    @pulumi.getter(name="radiusTestingEnabled")
    def radius_testing_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, Meraki devices will periodically send Access-Request messages to configured RADIUS servers using identity 'meraki*8021x*test' to ensure that the RADIUS servers are reachable.
        """
        return pulumi.get(self, "radius_testing_enabled")

    @radius_testing_enabled.setter
    def radius_testing_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "radius_testing_enabled", value)

    @_builtins.property
    @pulumi.getter(name="secondaryConcentratorNetworkId")
    def secondary_concentrator_network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The secondary concentrator to use when the ipAssignmentMode is 'VPN'. If configured, the APs will switch to using this concentrator if the primary concentrator is unreachable. This param is optional. ('disabled' represents no secondary concentrator.)
        """
        return pulumi.get(self, "secondary_concentrator_network_id")

    @secondary_concentrator_network_id.setter
    def secondary_concentrator_network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secondary_concentrator_network_id", value)

    @_builtins.property
    @pulumi.getter(name="speedBurst")
    def speed_burst(self) -> Optional[pulumi.Input['WirelessSsidsSpeedBurstArgs']]:
        """
        The SpeedBurst setting for this SSID'
        """
        return pulumi.get(self, "speed_burst")

    @speed_burst.setter
    def speed_burst(self, value: Optional[pulumi.Input['WirelessSsidsSpeedBurstArgs']]):
        pulumi.set(self, "speed_burst", value)

    @_builtins.property
    @pulumi.getter(name="splashGuestSponsorDomains")
    def splash_guest_sponsor_domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Array of valid sponsor email domains for sponsored guest splash type.
        """
        return pulumi.get(self, "splash_guest_sponsor_domains")

    @splash_guest_sponsor_domains.setter
    def splash_guest_sponsor_domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "splash_guest_sponsor_domains", value)

    @_builtins.property
    @pulumi.getter(name="splashPage")
    def splash_page(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of splash page for the SSID
        """
        return pulumi.get(self, "splash_page")

    @splash_page.setter
    def splash_page(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "splash_page", value)

    @_builtins.property
    @pulumi.getter(name="useVlanTagging")
    def use_vlan_tagging(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not traffic should be directed to use specific VLANs. This param is only valid if the ipAssignmentMode is 'Bridge mode' or 'Layer 3 roaming'
        """
        return pulumi.get(self, "use_vlan_tagging")

    @use_vlan_tagging.setter
    def use_vlan_tagging(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_vlan_tagging", value)

    @_builtins.property
    @pulumi.getter
    def visible(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the SSID is advertised or hidden by the AP
        """
        return pulumi.get(self, "visible")

    @visible.setter
    def visible(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "visible", value)

    @_builtins.property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The VLAN ID used for VLAN tagging. This param is only valid when the ipAssignmentMode is 'Layer 3 roaming with a concentrator' or 'VPN'
        """
        return pulumi.get(self, "vlan_id")

    @vlan_id.setter
    def vlan_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "vlan_id", value)

    @_builtins.property
    @pulumi.getter(name="walledGardenEnabled")
    def walled_garden_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Allow users to access a configurable list of IP ranges prior to sign-on
        """
        return pulumi.get(self, "walled_garden_enabled")

    @walled_garden_enabled.setter
    def walled_garden_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "walled_garden_enabled", value)

    @_builtins.property
    @pulumi.getter(name="walledGardenRanges")
    def walled_garden_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Domain names and IP address ranges available in Walled Garden mode
        """
        return pulumi.get(self, "walled_garden_ranges")

    @walled_garden_ranges.setter
    def walled_garden_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "walled_garden_ranges", value)

    @_builtins.property
    @pulumi.getter(name="wpaEncryptionMode")
    def wpa_encryption_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The types of WPA encryption
        """
        return pulumi.get(self, "wpa_encryption_mode")

    @wpa_encryption_mode.setter
    def wpa_encryption_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "wpa_encryption_mode", value)


@pulumi.input_type
class _WirelessSsidsState:
    def __init__(__self__, *,
                 active_directory: Optional[pulumi.Input['WirelessSsidsActiveDirectoryArgs']] = None,
                 admin_splash_url: Optional[pulumi.Input[_builtins.str]] = None,
                 adult_content_filtering_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ap_tags_and_vlan_ids: Optional[pulumi.Input[Sequence[pulumi.Input['WirelessSsidsApTagsAndVlanIdArgs']]]] = None,
                 auth_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 available_on_all_aps: Optional[pulumi.Input[_builtins.bool]] = None,
                 band_selection: Optional[pulumi.Input[_builtins.str]] = None,
                 concentrator_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 default_vlan_id: Optional[pulumi.Input[_builtins.int]] = None,
                 disassociate_clients_on_vpn_failover: Optional[pulumi.Input[_builtins.bool]] = None,
                 dns_rewrite: Optional[pulumi.Input['WirelessSsidsDnsRewriteArgs']] = None,
                 dot11r: Optional[pulumi.Input['WirelessSsidsDot11rArgs']] = None,
                 dot11w: Optional[pulumi.Input['WirelessSsidsDot11wArgs']] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_admin_access: Optional[pulumi.Input[_builtins.str]] = None,
                 gre: Optional[pulumi.Input['WirelessSsidsGreArgs']] = None,
                 ip_assignment_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 lan_isolation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ldap: Optional[pulumi.Input['WirelessSsidsLdapArgs']] = None,
                 local_radius: Optional[pulumi.Input['WirelessSsidsLocalRadiusArgs']] = None,
                 mandatory_dhcp_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 min_bitrate: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 named_vlans: Optional[pulumi.Input['WirelessSsidsNamedVlansArgs']] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 number: Optional[pulumi.Input[_builtins.int]] = None,
                 oauth: Optional[pulumi.Input['WirelessSsidsOauthArgs']] = None,
                 per_client_bandwidth_limit_down: Optional[pulumi.Input[_builtins.int]] = None,
                 per_client_bandwidth_limit_up: Optional[pulumi.Input[_builtins.int]] = None,
                 per_ssid_bandwidth_limit_down: Optional[pulumi.Input[_builtins.int]] = None,
                 per_ssid_bandwidth_limit_up: Optional[pulumi.Input[_builtins.int]] = None,
                 psk: Optional[pulumi.Input[_builtins.str]] = None,
                 radius_accounting_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 radius_accounting_interim_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 radius_accounting_servers: Optional[pulumi.Input[Sequence[pulumi.Input['WirelessSsidsRadiusAccountingServerArgs']]]] = None,
                 radius_accounting_servers_responses: Optional[pulumi.Input[Sequence[pulumi.Input['WirelessSsidsRadiusAccountingServersResponseArgs']]]] = None,
                 radius_attribute_for_group_policies: Optional[pulumi.Input[_builtins.str]] = None,
                 radius_authentication_nas_id: Optional[pulumi.Input[_builtins.str]] = None,
                 radius_called_station_id: Optional[pulumi.Input[_builtins.str]] = None,
                 radius_coa_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 radius_failover_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 radius_fallback_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 radius_guest_vlan_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 radius_guest_vlan_id: Optional[pulumi.Input[_builtins.int]] = None,
                 radius_load_balancing_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 radius_override: Optional[pulumi.Input[_builtins.bool]] = None,
                 radius_proxy_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 radius_server_attempts_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 radius_server_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 radius_servers: Optional[pulumi.Input[Sequence[pulumi.Input['WirelessSsidsRadiusServerArgs']]]] = None,
                 radius_servers_responses: Optional[pulumi.Input[Sequence[pulumi.Input['WirelessSsidsRadiusServersResponseArgs']]]] = None,
                 radius_testing_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 secondary_concentrator_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 speed_burst: Optional[pulumi.Input['WirelessSsidsSpeedBurstArgs']] = None,
                 splash_guest_sponsor_domains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 splash_page: Optional[pulumi.Input[_builtins.str]] = None,
                 splash_timeout: Optional[pulumi.Input[_builtins.str]] = None,
                 ssid_admin_accessible: Optional[pulumi.Input[_builtins.bool]] = None,
                 use_vlan_tagging: Optional[pulumi.Input[_builtins.bool]] = None,
                 visible: Optional[pulumi.Input[_builtins.bool]] = None,
                 vlan_id: Optional[pulumi.Input[_builtins.int]] = None,
                 walled_garden_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 walled_garden_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 wpa_encryption_mode: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering WirelessSsids resources.
        :param pulumi.Input['WirelessSsidsActiveDirectoryArgs'] active_directory: The current setting for Active Directory. Only valid if splashPage is 'Password-protected with Active Directory'
        :param pulumi.Input[_builtins.bool] adult_content_filtering_enabled: Boolean indicating whether or not adult content will be blocked
        :param pulumi.Input[Sequence[pulumi.Input['WirelessSsidsApTagsAndVlanIdArgs']]] ap_tags_and_vlan_ids: The list of tags and VLAN IDs used for VLAN tagging. This param is only valid when the ipAssignmentMode is 'Bridge mode' or 'Layer 3 roaming'
        :param pulumi.Input[_builtins.str] auth_mode: The association control method for the SSID
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] availability_tags: List of tags for this SSID. If availableOnAllAps is false, then the SSID is only broadcast by APs with tags matching any of the tags in this list
        :param pulumi.Input[_builtins.bool] available_on_all_aps: Whether all APs broadcast the SSID or if it's restricted to APs matching any availability tags
        :param pulumi.Input[_builtins.str] band_selection: The client-serving radio frequencies of this SSID in the default indoor RF profile
        :param pulumi.Input[_builtins.str] concentrator_network_id: The concentrator to use when the ipAssignmentMode is 'Layer 3 roaming with a concentrator' or 'VPN'.
        :param pulumi.Input[_builtins.int] default_vlan_id: The default VLAN ID used for 'all other APs'. This param is only valid when the ipAssignmentMode is 'Bridge mode' or 'Layer 3 roaming'
        :param pulumi.Input[_builtins.bool] disassociate_clients_on_vpn_failover: Disassociate clients when 'VPN' concentrator failover occurs in order to trigger clients to re-associate and generate new DHCP requests. This param is only valid if ipAssignmentMode is 'VPN'.
        :param pulumi.Input['WirelessSsidsDnsRewriteArgs'] dns_rewrite: DNS servers rewrite settings
        :param pulumi.Input['WirelessSsidsDot11rArgs'] dot11r: The current setting for 802.11r
        :param pulumi.Input['WirelessSsidsDot11wArgs'] dot11w: The current setting for Protected Management Frames (802.11w).
        :param pulumi.Input[_builtins.bool] enabled: Whether or not the SSID is enabled
        :param pulumi.Input[_builtins.str] encryption_mode: The psk encryption mode for the SSID
        :param pulumi.Input[_builtins.str] enterprise_admin_access: Whether or not an SSID is accessible by 'enterprise' administrators ('access disabled' or 'access enabled')
        :param pulumi.Input['WirelessSsidsGreArgs'] gre: Ethernet over GRE settings
        :param pulumi.Input[_builtins.str] ip_assignment_mode: The client IP assignment mode
        :param pulumi.Input[_builtins.bool] lan_isolation_enabled: Boolean indicating whether Layer 2 LAN isolation should be enabled or disabled. Only configurable when ipAssignmentMode is 'Bridge mode'.
        :param pulumi.Input['WirelessSsidsLdapArgs'] ldap: The current setting for LDAP. Only valid if splashPage is 'Password-protected with LDAP'.
        :param pulumi.Input['WirelessSsidsLocalRadiusArgs'] local_radius: The current setting for Local Authentication, a built-in RADIUS server on the access point. Only valid if authMode is '8021x-localradius'.
        :param pulumi.Input[_builtins.bool] mandatory_dhcp_enabled: Whether clients connecting to this SSID must use the IP address assigned by the DHCP server
        :param pulumi.Input[_builtins.int] min_bitrate: The minimum bitrate in Mbps of this SSID in the default indoor RF profile
        :param pulumi.Input[_builtins.str] name: The name of the SSID
        :param pulumi.Input['WirelessSsidsNamedVlansArgs'] named_vlans: Named VLAN settings.
        :param pulumi.Input[_builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[_builtins.int] number: Unique identifier of the SSID
        :param pulumi.Input['WirelessSsidsOauthArgs'] oauth: The OAuth settings of this SSID. Only valid if splashPage is 'Google OAuth'.
        :param pulumi.Input[_builtins.int] per_client_bandwidth_limit_down: The download bandwidth limit in Kbps. (0 represents no limit.)
        :param pulumi.Input[_builtins.int] per_client_bandwidth_limit_up: The upload bandwidth limit in Kbps. (0 represents no limit.)
        :param pulumi.Input[_builtins.int] per_ssid_bandwidth_limit_down: The total download bandwidth limit in Kbps (0 represents no limit)
        :param pulumi.Input[_builtins.int] per_ssid_bandwidth_limit_up: The total upload bandwidth limit in Kbps (0 represents no limit)
        :param pulumi.Input[_builtins.str] psk: The passkey for the SSID. This param is only valid if the authMode is 'psk'
        :param pulumi.Input[_builtins.bool] radius_accounting_enabled: Whether or not RADIUS accounting is enabled
        :param pulumi.Input[_builtins.int] radius_accounting_interim_interval: The interval (in seconds) in which accounting information is updated and sent to the RADIUS accounting server.
        :param pulumi.Input[Sequence[pulumi.Input['WirelessSsidsRadiusAccountingServerArgs']]] radius_accounting_servers: List of RADIUS accounting 802.1X servers to be used for authentication
        :param pulumi.Input[Sequence[pulumi.Input['WirelessSsidsRadiusAccountingServersResponseArgs']]] radius_accounting_servers_responses: List of RADIUS accounting 802.1X servers to be used for authentication
        :param pulumi.Input[_builtins.str] radius_attribute_for_group_policies: RADIUS attribute used to look up group policies
        :param pulumi.Input[_builtins.str] radius_authentication_nas_id: The template of the NAS identifier to be used for RADIUS authentication (ex. $NODE*MAC$:$VAP*NUM$).
        :param pulumi.Input[_builtins.str] radius_called_station_id: The template of the called station identifier to be used for RADIUS (ex. $NODE*MAC$:$VAP*NUM$).
        :param pulumi.Input[_builtins.bool] radius_coa_enabled: If true, Meraki devices will act as a RADIUS Dynamic Authorization Server and will respond to RADIUS Change-of-Authorization and Disconnect messages sent by the RADIUS server.
        :param pulumi.Input[_builtins.str] radius_failover_policy: Policy which determines how authentication requests should be handled in the event that all of the configured RADIUS servers are unreachable
        :param pulumi.Input[_builtins.bool] radius_fallback_enabled: Whether or not higher priority RADIUS servers should be retried after 60 seconds.
        :param pulumi.Input[_builtins.bool] radius_guest_vlan_enabled: Whether or not RADIUS Guest VLAN is enabled. This param is only valid if the authMode is 'open-with-radius' and addressing mode is not set to 'isolated' or 'nat' mode
        :param pulumi.Input[_builtins.int] radius_guest_vlan_id: VLAN ID of the RADIUS Guest VLAN. This param is only valid if the authMode is 'open-with-radius' and addressing mode is not set to 'isolated' or 'nat' mode
        :param pulumi.Input[_builtins.str] radius_load_balancing_policy: Policy which determines which RADIUS server will be contacted first in an authentication attempt, and the ordering of any necessary retry attempts
        :param pulumi.Input[_builtins.bool] radius_override: If true, the RADIUS response can override VLAN tag. This is not valid when ipAssignmentMode is 'NAT mode'.
        :param pulumi.Input[_builtins.bool] radius_proxy_enabled: If true, Meraki devices will proxy RADIUS messages through the Meraki cloud to the configured RADIUS auth and accounting servers.
        :param pulumi.Input[_builtins.int] radius_server_attempts_limit: The maximum number of transmit attempts after which a RADIUS server is failed over (must be between 1-5).
        :param pulumi.Input[_builtins.int] radius_server_timeout: The amount of time for which a RADIUS client waits for a reply from the RADIUS server (must be between 1-10 seconds).
        :param pulumi.Input[Sequence[pulumi.Input['WirelessSsidsRadiusServerArgs']]] radius_servers: The RADIUS 802.1X servers to be used for authentication. This param is only valid if the authMode is 'open-with-radius', '8021x-radius' or 'ipsk-with-radius'
        :param pulumi.Input[Sequence[pulumi.Input['WirelessSsidsRadiusServersResponseArgs']]] radius_servers_responses: The RADIUS 802.1X servers to be used for authentication. This param is only valid if the authMode is 'open-with-radius', '8021x-radius' or 'ipsk-with-radius'
        :param pulumi.Input[_builtins.bool] radius_testing_enabled: If true, Meraki devices will periodically send Access-Request messages to configured RADIUS servers using identity 'meraki*8021x*test' to ensure that the RADIUS servers are reachable.
        :param pulumi.Input[_builtins.str] secondary_concentrator_network_id: The secondary concentrator to use when the ipAssignmentMode is 'VPN'. If configured, the APs will switch to using this concentrator if the primary concentrator is unreachable. This param is optional. ('disabled' represents no secondary concentrator.)
        :param pulumi.Input['WirelessSsidsSpeedBurstArgs'] speed_burst: The SpeedBurst setting for this SSID'
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] splash_guest_sponsor_domains: Array of valid sponsor email domains for sponsored guest splash type.
        :param pulumi.Input[_builtins.str] splash_page: The type of splash page for the SSID
        :param pulumi.Input[_builtins.str] splash_timeout: Splash page timeout
        :param pulumi.Input[_builtins.bool] ssid_admin_accessible: SSID Administrator access status
        :param pulumi.Input[_builtins.bool] use_vlan_tagging: Whether or not traffic should be directed to use specific VLANs. This param is only valid if the ipAssignmentMode is 'Bridge mode' or 'Layer 3 roaming'
        :param pulumi.Input[_builtins.bool] visible: Whether the SSID is advertised or hidden by the AP
        :param pulumi.Input[_builtins.int] vlan_id: The VLAN ID used for VLAN tagging. This param is only valid when the ipAssignmentMode is 'Layer 3 roaming with a concentrator' or 'VPN'
        :param pulumi.Input[_builtins.bool] walled_garden_enabled: Allow users to access a configurable list of IP ranges prior to sign-on
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] walled_garden_ranges: Domain names and IP address ranges available in Walled Garden mode
        :param pulumi.Input[_builtins.str] wpa_encryption_mode: The types of WPA encryption
        """
        if active_directory is not None:
            pulumi.set(__self__, "active_directory", active_directory)
        if admin_splash_url is not None:
            pulumi.set(__self__, "admin_splash_url", admin_splash_url)
        if adult_content_filtering_enabled is not None:
            pulumi.set(__self__, "adult_content_filtering_enabled", adult_content_filtering_enabled)
        if ap_tags_and_vlan_ids is not None:
            pulumi.set(__self__, "ap_tags_and_vlan_ids", ap_tags_and_vlan_ids)
        if auth_mode is not None:
            pulumi.set(__self__, "auth_mode", auth_mode)
        if availability_tags is not None:
            pulumi.set(__self__, "availability_tags", availability_tags)
        if available_on_all_aps is not None:
            pulumi.set(__self__, "available_on_all_aps", available_on_all_aps)
        if band_selection is not None:
            pulumi.set(__self__, "band_selection", band_selection)
        if concentrator_network_id is not None:
            pulumi.set(__self__, "concentrator_network_id", concentrator_network_id)
        if default_vlan_id is not None:
            pulumi.set(__self__, "default_vlan_id", default_vlan_id)
        if disassociate_clients_on_vpn_failover is not None:
            pulumi.set(__self__, "disassociate_clients_on_vpn_failover", disassociate_clients_on_vpn_failover)
        if dns_rewrite is not None:
            pulumi.set(__self__, "dns_rewrite", dns_rewrite)
        if dot11r is not None:
            pulumi.set(__self__, "dot11r", dot11r)
        if dot11w is not None:
            pulumi.set(__self__, "dot11w", dot11w)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if encryption_mode is not None:
            pulumi.set(__self__, "encryption_mode", encryption_mode)
        if enterprise_admin_access is not None:
            pulumi.set(__self__, "enterprise_admin_access", enterprise_admin_access)
        if gre is not None:
            pulumi.set(__self__, "gre", gre)
        if ip_assignment_mode is not None:
            pulumi.set(__self__, "ip_assignment_mode", ip_assignment_mode)
        if lan_isolation_enabled is not None:
            pulumi.set(__self__, "lan_isolation_enabled", lan_isolation_enabled)
        if ldap is not None:
            pulumi.set(__self__, "ldap", ldap)
        if local_radius is not None:
            pulumi.set(__self__, "local_radius", local_radius)
        if mandatory_dhcp_enabled is not None:
            pulumi.set(__self__, "mandatory_dhcp_enabled", mandatory_dhcp_enabled)
        if min_bitrate is not None:
            pulumi.set(__self__, "min_bitrate", min_bitrate)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if named_vlans is not None:
            pulumi.set(__self__, "named_vlans", named_vlans)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if number is not None:
            pulumi.set(__self__, "number", number)
        if oauth is not None:
            pulumi.set(__self__, "oauth", oauth)
        if per_client_bandwidth_limit_down is not None:
            pulumi.set(__self__, "per_client_bandwidth_limit_down", per_client_bandwidth_limit_down)
        if per_client_bandwidth_limit_up is not None:
            pulumi.set(__self__, "per_client_bandwidth_limit_up", per_client_bandwidth_limit_up)
        if per_ssid_bandwidth_limit_down is not None:
            pulumi.set(__self__, "per_ssid_bandwidth_limit_down", per_ssid_bandwidth_limit_down)
        if per_ssid_bandwidth_limit_up is not None:
            pulumi.set(__self__, "per_ssid_bandwidth_limit_up", per_ssid_bandwidth_limit_up)
        if psk is not None:
            pulumi.set(__self__, "psk", psk)
        if radius_accounting_enabled is not None:
            pulumi.set(__self__, "radius_accounting_enabled", radius_accounting_enabled)
        if radius_accounting_interim_interval is not None:
            pulumi.set(__self__, "radius_accounting_interim_interval", radius_accounting_interim_interval)
        if radius_accounting_servers is not None:
            pulumi.set(__self__, "radius_accounting_servers", radius_accounting_servers)
        if radius_accounting_servers_responses is not None:
            pulumi.set(__self__, "radius_accounting_servers_responses", radius_accounting_servers_responses)
        if radius_attribute_for_group_policies is not None:
            pulumi.set(__self__, "radius_attribute_for_group_policies", radius_attribute_for_group_policies)
        if radius_authentication_nas_id is not None:
            pulumi.set(__self__, "radius_authentication_nas_id", radius_authentication_nas_id)
        if radius_called_station_id is not None:
            pulumi.set(__self__, "radius_called_station_id", radius_called_station_id)
        if radius_coa_enabled is not None:
            pulumi.set(__self__, "radius_coa_enabled", radius_coa_enabled)
        if radius_failover_policy is not None:
            pulumi.set(__self__, "radius_failover_policy", radius_failover_policy)
        if radius_fallback_enabled is not None:
            pulumi.set(__self__, "radius_fallback_enabled", radius_fallback_enabled)
        if radius_guest_vlan_enabled is not None:
            pulumi.set(__self__, "radius_guest_vlan_enabled", radius_guest_vlan_enabled)
        if radius_guest_vlan_id is not None:
            pulumi.set(__self__, "radius_guest_vlan_id", radius_guest_vlan_id)
        if radius_load_balancing_policy is not None:
            pulumi.set(__self__, "radius_load_balancing_policy", radius_load_balancing_policy)
        if radius_override is not None:
            pulumi.set(__self__, "radius_override", radius_override)
        if radius_proxy_enabled is not None:
            pulumi.set(__self__, "radius_proxy_enabled", radius_proxy_enabled)
        if radius_server_attempts_limit is not None:
            pulumi.set(__self__, "radius_server_attempts_limit", radius_server_attempts_limit)
        if radius_server_timeout is not None:
            pulumi.set(__self__, "radius_server_timeout", radius_server_timeout)
        if radius_servers is not None:
            pulumi.set(__self__, "radius_servers", radius_servers)
        if radius_servers_responses is not None:
            pulumi.set(__self__, "radius_servers_responses", radius_servers_responses)
        if radius_testing_enabled is not None:
            pulumi.set(__self__, "radius_testing_enabled", radius_testing_enabled)
        if secondary_concentrator_network_id is not None:
            pulumi.set(__self__, "secondary_concentrator_network_id", secondary_concentrator_network_id)
        if speed_burst is not None:
            pulumi.set(__self__, "speed_burst", speed_burst)
        if splash_guest_sponsor_domains is not None:
            pulumi.set(__self__, "splash_guest_sponsor_domains", splash_guest_sponsor_domains)
        if splash_page is not None:
            pulumi.set(__self__, "splash_page", splash_page)
        if splash_timeout is not None:
            pulumi.set(__self__, "splash_timeout", splash_timeout)
        if ssid_admin_accessible is not None:
            pulumi.set(__self__, "ssid_admin_accessible", ssid_admin_accessible)
        if use_vlan_tagging is not None:
            pulumi.set(__self__, "use_vlan_tagging", use_vlan_tagging)
        if visible is not None:
            pulumi.set(__self__, "visible", visible)
        if vlan_id is not None:
            pulumi.set(__self__, "vlan_id", vlan_id)
        if walled_garden_enabled is not None:
            pulumi.set(__self__, "walled_garden_enabled", walled_garden_enabled)
        if walled_garden_ranges is not None:
            pulumi.set(__self__, "walled_garden_ranges", walled_garden_ranges)
        if wpa_encryption_mode is not None:
            pulumi.set(__self__, "wpa_encryption_mode", wpa_encryption_mode)

    @_builtins.property
    @pulumi.getter(name="activeDirectory")
    def active_directory(self) -> Optional[pulumi.Input['WirelessSsidsActiveDirectoryArgs']]:
        """
        The current setting for Active Directory. Only valid if splashPage is 'Password-protected with Active Directory'
        """
        return pulumi.get(self, "active_directory")

    @active_directory.setter
    def active_directory(self, value: Optional[pulumi.Input['WirelessSsidsActiveDirectoryArgs']]):
        pulumi.set(self, "active_directory", value)

    @_builtins.property
    @pulumi.getter(name="adminSplashUrl")
    def admin_splash_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "admin_splash_url")

    @admin_splash_url.setter
    def admin_splash_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "admin_splash_url", value)

    @_builtins.property
    @pulumi.getter(name="adultContentFilteringEnabled")
    def adult_content_filtering_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean indicating whether or not adult content will be blocked
        """
        return pulumi.get(self, "adult_content_filtering_enabled")

    @adult_content_filtering_enabled.setter
    def adult_content_filtering_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "adult_content_filtering_enabled", value)

    @_builtins.property
    @pulumi.getter(name="apTagsAndVlanIds")
    def ap_tags_and_vlan_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WirelessSsidsApTagsAndVlanIdArgs']]]]:
        """
        The list of tags and VLAN IDs used for VLAN tagging. This param is only valid when the ipAssignmentMode is 'Bridge mode' or 'Layer 3 roaming'
        """
        return pulumi.get(self, "ap_tags_and_vlan_ids")

    @ap_tags_and_vlan_ids.setter
    def ap_tags_and_vlan_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WirelessSsidsApTagsAndVlanIdArgs']]]]):
        pulumi.set(self, "ap_tags_and_vlan_ids", value)

    @_builtins.property
    @pulumi.getter(name="authMode")
    def auth_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The association control method for the SSID
        """
        return pulumi.get(self, "auth_mode")

    @auth_mode.setter
    def auth_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auth_mode", value)

    @_builtins.property
    @pulumi.getter(name="availabilityTags")
    def availability_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of tags for this SSID. If availableOnAllAps is false, then the SSID is only broadcast by APs with tags matching any of the tags in this list
        """
        return pulumi.get(self, "availability_tags")

    @availability_tags.setter
    def availability_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "availability_tags", value)

    @_builtins.property
    @pulumi.getter(name="availableOnAllAps")
    def available_on_all_aps(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether all APs broadcast the SSID or if it's restricted to APs matching any availability tags
        """
        return pulumi.get(self, "available_on_all_aps")

    @available_on_all_aps.setter
    def available_on_all_aps(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "available_on_all_aps", value)

    @_builtins.property
    @pulumi.getter(name="bandSelection")
    def band_selection(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The client-serving radio frequencies of this SSID in the default indoor RF profile
        """
        return pulumi.get(self, "band_selection")

    @band_selection.setter
    def band_selection(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "band_selection", value)

    @_builtins.property
    @pulumi.getter(name="concentratorNetworkId")
    def concentrator_network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The concentrator to use when the ipAssignmentMode is 'Layer 3 roaming with a concentrator' or 'VPN'.
        """
        return pulumi.get(self, "concentrator_network_id")

    @concentrator_network_id.setter
    def concentrator_network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "concentrator_network_id", value)

    @_builtins.property
    @pulumi.getter(name="defaultVlanId")
    def default_vlan_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The default VLAN ID used for 'all other APs'. This param is only valid when the ipAssignmentMode is 'Bridge mode' or 'Layer 3 roaming'
        """
        return pulumi.get(self, "default_vlan_id")

    @default_vlan_id.setter
    def default_vlan_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "default_vlan_id", value)

    @_builtins.property
    @pulumi.getter(name="disassociateClientsOnVpnFailover")
    def disassociate_clients_on_vpn_failover(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Disassociate clients when 'VPN' concentrator failover occurs in order to trigger clients to re-associate and generate new DHCP requests. This param is only valid if ipAssignmentMode is 'VPN'.
        """
        return pulumi.get(self, "disassociate_clients_on_vpn_failover")

    @disassociate_clients_on_vpn_failover.setter
    def disassociate_clients_on_vpn_failover(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disassociate_clients_on_vpn_failover", value)

    @_builtins.property
    @pulumi.getter(name="dnsRewrite")
    def dns_rewrite(self) -> Optional[pulumi.Input['WirelessSsidsDnsRewriteArgs']]:
        """
        DNS servers rewrite settings
        """
        return pulumi.get(self, "dns_rewrite")

    @dns_rewrite.setter
    def dns_rewrite(self, value: Optional[pulumi.Input['WirelessSsidsDnsRewriteArgs']]):
        pulumi.set(self, "dns_rewrite", value)

    @_builtins.property
    @pulumi.getter
    def dot11r(self) -> Optional[pulumi.Input['WirelessSsidsDot11rArgs']]:
        """
        The current setting for 802.11r
        """
        return pulumi.get(self, "dot11r")

    @dot11r.setter
    def dot11r(self, value: Optional[pulumi.Input['WirelessSsidsDot11rArgs']]):
        pulumi.set(self, "dot11r", value)

    @_builtins.property
    @pulumi.getter
    def dot11w(self) -> Optional[pulumi.Input['WirelessSsidsDot11wArgs']]:
        """
        The current setting for Protected Management Frames (802.11w).
        """
        return pulumi.get(self, "dot11w")

    @dot11w.setter
    def dot11w(self, value: Optional[pulumi.Input['WirelessSsidsDot11wArgs']]):
        pulumi.set(self, "dot11w", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not the SSID is enabled
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="encryptionMode")
    def encryption_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The psk encryption mode for the SSID
        """
        return pulumi.get(self, "encryption_mode")

    @encryption_mode.setter
    def encryption_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encryption_mode", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseAdminAccess")
    def enterprise_admin_access(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether or not an SSID is accessible by 'enterprise' administrators ('access disabled' or 'access enabled')
        """
        return pulumi.get(self, "enterprise_admin_access")

    @enterprise_admin_access.setter
    def enterprise_admin_access(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_admin_access", value)

    @_builtins.property
    @pulumi.getter
    def gre(self) -> Optional[pulumi.Input['WirelessSsidsGreArgs']]:
        """
        Ethernet over GRE settings
        """
        return pulumi.get(self, "gre")

    @gre.setter
    def gre(self, value: Optional[pulumi.Input['WirelessSsidsGreArgs']]):
        pulumi.set(self, "gre", value)

    @_builtins.property
    @pulumi.getter(name="ipAssignmentMode")
    def ip_assignment_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The client IP assignment mode
        """
        return pulumi.get(self, "ip_assignment_mode")

    @ip_assignment_mode.setter
    def ip_assignment_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_assignment_mode", value)

    @_builtins.property
    @pulumi.getter(name="lanIsolationEnabled")
    def lan_isolation_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean indicating whether Layer 2 LAN isolation should be enabled or disabled. Only configurable when ipAssignmentMode is 'Bridge mode'.
        """
        return pulumi.get(self, "lan_isolation_enabled")

    @lan_isolation_enabled.setter
    def lan_isolation_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "lan_isolation_enabled", value)

    @_builtins.property
    @pulumi.getter
    def ldap(self) -> Optional[pulumi.Input['WirelessSsidsLdapArgs']]:
        """
        The current setting for LDAP. Only valid if splashPage is 'Password-protected with LDAP'.
        """
        return pulumi.get(self, "ldap")

    @ldap.setter
    def ldap(self, value: Optional[pulumi.Input['WirelessSsidsLdapArgs']]):
        pulumi.set(self, "ldap", value)

    @_builtins.property
    @pulumi.getter(name="localRadius")
    def local_radius(self) -> Optional[pulumi.Input['WirelessSsidsLocalRadiusArgs']]:
        """
        The current setting for Local Authentication, a built-in RADIUS server on the access point. Only valid if authMode is '8021x-localradius'.
        """
        return pulumi.get(self, "local_radius")

    @local_radius.setter
    def local_radius(self, value: Optional[pulumi.Input['WirelessSsidsLocalRadiusArgs']]):
        pulumi.set(self, "local_radius", value)

    @_builtins.property
    @pulumi.getter(name="mandatoryDhcpEnabled")
    def mandatory_dhcp_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether clients connecting to this SSID must use the IP address assigned by the DHCP server
        """
        return pulumi.get(self, "mandatory_dhcp_enabled")

    @mandatory_dhcp_enabled.setter
    def mandatory_dhcp_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "mandatory_dhcp_enabled", value)

    @_builtins.property
    @pulumi.getter(name="minBitrate")
    def min_bitrate(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The minimum bitrate in Mbps of this SSID in the default indoor RF profile
        """
        return pulumi.get(self, "min_bitrate")

    @min_bitrate.setter
    def min_bitrate(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_bitrate", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the SSID
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="namedVlans")
    def named_vlans(self) -> Optional[pulumi.Input['WirelessSsidsNamedVlansArgs']]:
        """
        Named VLAN settings.
        """
        return pulumi.get(self, "named_vlans")

    @named_vlans.setter
    def named_vlans(self, value: Optional[pulumi.Input['WirelessSsidsNamedVlansArgs']]):
        pulumi.set(self, "named_vlans", value)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_id", value)

    @_builtins.property
    @pulumi.getter
    def number(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Unique identifier of the SSID
        """
        return pulumi.get(self, "number")

    @number.setter
    def number(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "number", value)

    @_builtins.property
    @pulumi.getter
    def oauth(self) -> Optional[pulumi.Input['WirelessSsidsOauthArgs']]:
        """
        The OAuth settings of this SSID. Only valid if splashPage is 'Google OAuth'.
        """
        return pulumi.get(self, "oauth")

    @oauth.setter
    def oauth(self, value: Optional[pulumi.Input['WirelessSsidsOauthArgs']]):
        pulumi.set(self, "oauth", value)

    @_builtins.property
    @pulumi.getter(name="perClientBandwidthLimitDown")
    def per_client_bandwidth_limit_down(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The download bandwidth limit in Kbps. (0 represents no limit.)
        """
        return pulumi.get(self, "per_client_bandwidth_limit_down")

    @per_client_bandwidth_limit_down.setter
    def per_client_bandwidth_limit_down(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "per_client_bandwidth_limit_down", value)

    @_builtins.property
    @pulumi.getter(name="perClientBandwidthLimitUp")
    def per_client_bandwidth_limit_up(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The upload bandwidth limit in Kbps. (0 represents no limit.)
        """
        return pulumi.get(self, "per_client_bandwidth_limit_up")

    @per_client_bandwidth_limit_up.setter
    def per_client_bandwidth_limit_up(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "per_client_bandwidth_limit_up", value)

    @_builtins.property
    @pulumi.getter(name="perSsidBandwidthLimitDown")
    def per_ssid_bandwidth_limit_down(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The total download bandwidth limit in Kbps (0 represents no limit)
        """
        return pulumi.get(self, "per_ssid_bandwidth_limit_down")

    @per_ssid_bandwidth_limit_down.setter
    def per_ssid_bandwidth_limit_down(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "per_ssid_bandwidth_limit_down", value)

    @_builtins.property
    @pulumi.getter(name="perSsidBandwidthLimitUp")
    def per_ssid_bandwidth_limit_up(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The total upload bandwidth limit in Kbps (0 represents no limit)
        """
        return pulumi.get(self, "per_ssid_bandwidth_limit_up")

    @per_ssid_bandwidth_limit_up.setter
    def per_ssid_bandwidth_limit_up(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "per_ssid_bandwidth_limit_up", value)

    @_builtins.property
    @pulumi.getter
    def psk(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The passkey for the SSID. This param is only valid if the authMode is 'psk'
        """
        return pulumi.get(self, "psk")

    @psk.setter
    def psk(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "psk", value)

    @_builtins.property
    @pulumi.getter(name="radiusAccountingEnabled")
    def radius_accounting_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not RADIUS accounting is enabled
        """
        return pulumi.get(self, "radius_accounting_enabled")

    @radius_accounting_enabled.setter
    def radius_accounting_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "radius_accounting_enabled", value)

    @_builtins.property
    @pulumi.getter(name="radiusAccountingInterimInterval")
    def radius_accounting_interim_interval(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The interval (in seconds) in which accounting information is updated and sent to the RADIUS accounting server.
        """
        return pulumi.get(self, "radius_accounting_interim_interval")

    @radius_accounting_interim_interval.setter
    def radius_accounting_interim_interval(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "radius_accounting_interim_interval", value)

    @_builtins.property
    @pulumi.getter(name="radiusAccountingServers")
    def radius_accounting_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WirelessSsidsRadiusAccountingServerArgs']]]]:
        """
        List of RADIUS accounting 802.1X servers to be used for authentication
        """
        return pulumi.get(self, "radius_accounting_servers")

    @radius_accounting_servers.setter
    def radius_accounting_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WirelessSsidsRadiusAccountingServerArgs']]]]):
        pulumi.set(self, "radius_accounting_servers", value)

    @_builtins.property
    @pulumi.getter(name="radiusAccountingServersResponses")
    def radius_accounting_servers_responses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WirelessSsidsRadiusAccountingServersResponseArgs']]]]:
        """
        List of RADIUS accounting 802.1X servers to be used for authentication
        """
        return pulumi.get(self, "radius_accounting_servers_responses")

    @radius_accounting_servers_responses.setter
    def radius_accounting_servers_responses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WirelessSsidsRadiusAccountingServersResponseArgs']]]]):
        pulumi.set(self, "radius_accounting_servers_responses", value)

    @_builtins.property
    @pulumi.getter(name="radiusAttributeForGroupPolicies")
    def radius_attribute_for_group_policies(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        RADIUS attribute used to look up group policies
        """
        return pulumi.get(self, "radius_attribute_for_group_policies")

    @radius_attribute_for_group_policies.setter
    def radius_attribute_for_group_policies(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "radius_attribute_for_group_policies", value)

    @_builtins.property
    @pulumi.getter(name="radiusAuthenticationNasId")
    def radius_authentication_nas_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The template of the NAS identifier to be used for RADIUS authentication (ex. $NODE*MAC$:$VAP*NUM$).
        """
        return pulumi.get(self, "radius_authentication_nas_id")

    @radius_authentication_nas_id.setter
    def radius_authentication_nas_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "radius_authentication_nas_id", value)

    @_builtins.property
    @pulumi.getter(name="radiusCalledStationId")
    def radius_called_station_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The template of the called station identifier to be used for RADIUS (ex. $NODE*MAC$:$VAP*NUM$).
        """
        return pulumi.get(self, "radius_called_station_id")

    @radius_called_station_id.setter
    def radius_called_station_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "radius_called_station_id", value)

    @_builtins.property
    @pulumi.getter(name="radiusCoaEnabled")
    def radius_coa_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, Meraki devices will act as a RADIUS Dynamic Authorization Server and will respond to RADIUS Change-of-Authorization and Disconnect messages sent by the RADIUS server.
        """
        return pulumi.get(self, "radius_coa_enabled")

    @radius_coa_enabled.setter
    def radius_coa_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "radius_coa_enabled", value)

    @_builtins.property
    @pulumi.getter(name="radiusFailoverPolicy")
    def radius_failover_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Policy which determines how authentication requests should be handled in the event that all of the configured RADIUS servers are unreachable
        """
        return pulumi.get(self, "radius_failover_policy")

    @radius_failover_policy.setter
    def radius_failover_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "radius_failover_policy", value)

    @_builtins.property
    @pulumi.getter(name="radiusFallbackEnabled")
    def radius_fallback_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not higher priority RADIUS servers should be retried after 60 seconds.
        """
        return pulumi.get(self, "radius_fallback_enabled")

    @radius_fallback_enabled.setter
    def radius_fallback_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "radius_fallback_enabled", value)

    @_builtins.property
    @pulumi.getter(name="radiusGuestVlanEnabled")
    def radius_guest_vlan_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not RADIUS Guest VLAN is enabled. This param is only valid if the authMode is 'open-with-radius' and addressing mode is not set to 'isolated' or 'nat' mode
        """
        return pulumi.get(self, "radius_guest_vlan_enabled")

    @radius_guest_vlan_enabled.setter
    def radius_guest_vlan_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "radius_guest_vlan_enabled", value)

    @_builtins.property
    @pulumi.getter(name="radiusGuestVlanId")
    def radius_guest_vlan_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        VLAN ID of the RADIUS Guest VLAN. This param is only valid if the authMode is 'open-with-radius' and addressing mode is not set to 'isolated' or 'nat' mode
        """
        return pulumi.get(self, "radius_guest_vlan_id")

    @radius_guest_vlan_id.setter
    def radius_guest_vlan_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "radius_guest_vlan_id", value)

    @_builtins.property
    @pulumi.getter(name="radiusLoadBalancingPolicy")
    def radius_load_balancing_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Policy which determines which RADIUS server will be contacted first in an authentication attempt, and the ordering of any necessary retry attempts
        """
        return pulumi.get(self, "radius_load_balancing_policy")

    @radius_load_balancing_policy.setter
    def radius_load_balancing_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "radius_load_balancing_policy", value)

    @_builtins.property
    @pulumi.getter(name="radiusOverride")
    def radius_override(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, the RADIUS response can override VLAN tag. This is not valid when ipAssignmentMode is 'NAT mode'.
        """
        return pulumi.get(self, "radius_override")

    @radius_override.setter
    def radius_override(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "radius_override", value)

    @_builtins.property
    @pulumi.getter(name="radiusProxyEnabled")
    def radius_proxy_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, Meraki devices will proxy RADIUS messages through the Meraki cloud to the configured RADIUS auth and accounting servers.
        """
        return pulumi.get(self, "radius_proxy_enabled")

    @radius_proxy_enabled.setter
    def radius_proxy_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "radius_proxy_enabled", value)

    @_builtins.property
    @pulumi.getter(name="radiusServerAttemptsLimit")
    def radius_server_attempts_limit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of transmit attempts after which a RADIUS server is failed over (must be between 1-5).
        """
        return pulumi.get(self, "radius_server_attempts_limit")

    @radius_server_attempts_limit.setter
    def radius_server_attempts_limit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "radius_server_attempts_limit", value)

    @_builtins.property
    @pulumi.getter(name="radiusServerTimeout")
    def radius_server_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of time for which a RADIUS client waits for a reply from the RADIUS server (must be between 1-10 seconds).
        """
        return pulumi.get(self, "radius_server_timeout")

    @radius_server_timeout.setter
    def radius_server_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "radius_server_timeout", value)

    @_builtins.property
    @pulumi.getter(name="radiusServers")
    def radius_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WirelessSsidsRadiusServerArgs']]]]:
        """
        The RADIUS 802.1X servers to be used for authentication. This param is only valid if the authMode is 'open-with-radius', '8021x-radius' or 'ipsk-with-radius'
        """
        return pulumi.get(self, "radius_servers")

    @radius_servers.setter
    def radius_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WirelessSsidsRadiusServerArgs']]]]):
        pulumi.set(self, "radius_servers", value)

    @_builtins.property
    @pulumi.getter(name="radiusServersResponses")
    def radius_servers_responses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WirelessSsidsRadiusServersResponseArgs']]]]:
        """
        The RADIUS 802.1X servers to be used for authentication. This param is only valid if the authMode is 'open-with-radius', '8021x-radius' or 'ipsk-with-radius'
        """
        return pulumi.get(self, "radius_servers_responses")

    @radius_servers_responses.setter
    def radius_servers_responses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WirelessSsidsRadiusServersResponseArgs']]]]):
        pulumi.set(self, "radius_servers_responses", value)

    @_builtins.property
    @pulumi.getter(name="radiusTestingEnabled")
    def radius_testing_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, Meraki devices will periodically send Access-Request messages to configured RADIUS servers using identity 'meraki*8021x*test' to ensure that the RADIUS servers are reachable.
        """
        return pulumi.get(self, "radius_testing_enabled")

    @radius_testing_enabled.setter
    def radius_testing_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "radius_testing_enabled", value)

    @_builtins.property
    @pulumi.getter(name="secondaryConcentratorNetworkId")
    def secondary_concentrator_network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The secondary concentrator to use when the ipAssignmentMode is 'VPN'. If configured, the APs will switch to using this concentrator if the primary concentrator is unreachable. This param is optional. ('disabled' represents no secondary concentrator.)
        """
        return pulumi.get(self, "secondary_concentrator_network_id")

    @secondary_concentrator_network_id.setter
    def secondary_concentrator_network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secondary_concentrator_network_id", value)

    @_builtins.property
    @pulumi.getter(name="speedBurst")
    def speed_burst(self) -> Optional[pulumi.Input['WirelessSsidsSpeedBurstArgs']]:
        """
        The SpeedBurst setting for this SSID'
        """
        return pulumi.get(self, "speed_burst")

    @speed_burst.setter
    def speed_burst(self, value: Optional[pulumi.Input['WirelessSsidsSpeedBurstArgs']]):
        pulumi.set(self, "speed_burst", value)

    @_builtins.property
    @pulumi.getter(name="splashGuestSponsorDomains")
    def splash_guest_sponsor_domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Array of valid sponsor email domains for sponsored guest splash type.
        """
        return pulumi.get(self, "splash_guest_sponsor_domains")

    @splash_guest_sponsor_domains.setter
    def splash_guest_sponsor_domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "splash_guest_sponsor_domains", value)

    @_builtins.property
    @pulumi.getter(name="splashPage")
    def splash_page(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of splash page for the SSID
        """
        return pulumi.get(self, "splash_page")

    @splash_page.setter
    def splash_page(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "splash_page", value)

    @_builtins.property
    @pulumi.getter(name="splashTimeout")
    def splash_timeout(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Splash page timeout
        """
        return pulumi.get(self, "splash_timeout")

    @splash_timeout.setter
    def splash_timeout(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "splash_timeout", value)

    @_builtins.property
    @pulumi.getter(name="ssidAdminAccessible")
    def ssid_admin_accessible(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        SSID Administrator access status
        """
        return pulumi.get(self, "ssid_admin_accessible")

    @ssid_admin_accessible.setter
    def ssid_admin_accessible(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ssid_admin_accessible", value)

    @_builtins.property
    @pulumi.getter(name="useVlanTagging")
    def use_vlan_tagging(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not traffic should be directed to use specific VLANs. This param is only valid if the ipAssignmentMode is 'Bridge mode' or 'Layer 3 roaming'
        """
        return pulumi.get(self, "use_vlan_tagging")

    @use_vlan_tagging.setter
    def use_vlan_tagging(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_vlan_tagging", value)

    @_builtins.property
    @pulumi.getter
    def visible(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the SSID is advertised or hidden by the AP
        """
        return pulumi.get(self, "visible")

    @visible.setter
    def visible(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "visible", value)

    @_builtins.property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The VLAN ID used for VLAN tagging. This param is only valid when the ipAssignmentMode is 'Layer 3 roaming with a concentrator' or 'VPN'
        """
        return pulumi.get(self, "vlan_id")

    @vlan_id.setter
    def vlan_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "vlan_id", value)

    @_builtins.property
    @pulumi.getter(name="walledGardenEnabled")
    def walled_garden_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Allow users to access a configurable list of IP ranges prior to sign-on
        """
        return pulumi.get(self, "walled_garden_enabled")

    @walled_garden_enabled.setter
    def walled_garden_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "walled_garden_enabled", value)

    @_builtins.property
    @pulumi.getter(name="walledGardenRanges")
    def walled_garden_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Domain names and IP address ranges available in Walled Garden mode
        """
        return pulumi.get(self, "walled_garden_ranges")

    @walled_garden_ranges.setter
    def walled_garden_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "walled_garden_ranges", value)

    @_builtins.property
    @pulumi.getter(name="wpaEncryptionMode")
    def wpa_encryption_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The types of WPA encryption
        """
        return pulumi.get(self, "wpa_encryption_mode")

    @wpa_encryption_mode.setter
    def wpa_encryption_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "wpa_encryption_mode", value)


@pulumi.type_token("meraki:networks/wirelessSsids:WirelessSsids")
class WirelessSsids(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active_directory: Optional[pulumi.Input[Union['WirelessSsidsActiveDirectoryArgs', 'WirelessSsidsActiveDirectoryArgsDict']]] = None,
                 adult_content_filtering_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ap_tags_and_vlan_ids: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WirelessSsidsApTagsAndVlanIdArgs', 'WirelessSsidsApTagsAndVlanIdArgsDict']]]]] = None,
                 auth_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 available_on_all_aps: Optional[pulumi.Input[_builtins.bool]] = None,
                 band_selection: Optional[pulumi.Input[_builtins.str]] = None,
                 concentrator_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 default_vlan_id: Optional[pulumi.Input[_builtins.int]] = None,
                 disassociate_clients_on_vpn_failover: Optional[pulumi.Input[_builtins.bool]] = None,
                 dns_rewrite: Optional[pulumi.Input[Union['WirelessSsidsDnsRewriteArgs', 'WirelessSsidsDnsRewriteArgsDict']]] = None,
                 dot11r: Optional[pulumi.Input[Union['WirelessSsidsDot11rArgs', 'WirelessSsidsDot11rArgsDict']]] = None,
                 dot11w: Optional[pulumi.Input[Union['WirelessSsidsDot11wArgs', 'WirelessSsidsDot11wArgsDict']]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_admin_access: Optional[pulumi.Input[_builtins.str]] = None,
                 gre: Optional[pulumi.Input[Union['WirelessSsidsGreArgs', 'WirelessSsidsGreArgsDict']]] = None,
                 ip_assignment_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 lan_isolation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ldap: Optional[pulumi.Input[Union['WirelessSsidsLdapArgs', 'WirelessSsidsLdapArgsDict']]] = None,
                 local_radius: Optional[pulumi.Input[Union['WirelessSsidsLocalRadiusArgs', 'WirelessSsidsLocalRadiusArgsDict']]] = None,
                 mandatory_dhcp_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 min_bitrate: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 named_vlans: Optional[pulumi.Input[Union['WirelessSsidsNamedVlansArgs', 'WirelessSsidsNamedVlansArgsDict']]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 number: Optional[pulumi.Input[_builtins.int]] = None,
                 oauth: Optional[pulumi.Input[Union['WirelessSsidsOauthArgs', 'WirelessSsidsOauthArgsDict']]] = None,
                 per_client_bandwidth_limit_down: Optional[pulumi.Input[_builtins.int]] = None,
                 per_client_bandwidth_limit_up: Optional[pulumi.Input[_builtins.int]] = None,
                 per_ssid_bandwidth_limit_down: Optional[pulumi.Input[_builtins.int]] = None,
                 per_ssid_bandwidth_limit_up: Optional[pulumi.Input[_builtins.int]] = None,
                 psk: Optional[pulumi.Input[_builtins.str]] = None,
                 radius_accounting_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 radius_accounting_interim_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 radius_accounting_servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WirelessSsidsRadiusAccountingServerArgs', 'WirelessSsidsRadiusAccountingServerArgsDict']]]]] = None,
                 radius_attribute_for_group_policies: Optional[pulumi.Input[_builtins.str]] = None,
                 radius_authentication_nas_id: Optional[pulumi.Input[_builtins.str]] = None,
                 radius_called_station_id: Optional[pulumi.Input[_builtins.str]] = None,
                 radius_coa_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 radius_failover_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 radius_fallback_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 radius_guest_vlan_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 radius_guest_vlan_id: Optional[pulumi.Input[_builtins.int]] = None,
                 radius_load_balancing_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 radius_override: Optional[pulumi.Input[_builtins.bool]] = None,
                 radius_proxy_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 radius_server_attempts_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 radius_server_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 radius_servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WirelessSsidsRadiusServerArgs', 'WirelessSsidsRadiusServerArgsDict']]]]] = None,
                 radius_testing_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 secondary_concentrator_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 speed_burst: Optional[pulumi.Input[Union['WirelessSsidsSpeedBurstArgs', 'WirelessSsidsSpeedBurstArgsDict']]] = None,
                 splash_guest_sponsor_domains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 splash_page: Optional[pulumi.Input[_builtins.str]] = None,
                 use_vlan_tagging: Optional[pulumi.Input[_builtins.bool]] = None,
                 visible: Optional[pulumi.Input[_builtins.bool]] = None,
                 vlan_id: Optional[pulumi.Input[_builtins.int]] = None,
                 walled_garden_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 walled_garden_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 wpa_encryption_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import meraki:networks/wirelessSsids:WirelessSsids example "network_id,number"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['WirelessSsidsActiveDirectoryArgs', 'WirelessSsidsActiveDirectoryArgsDict']] active_directory: The current setting for Active Directory. Only valid if splashPage is 'Password-protected with Active Directory'
        :param pulumi.Input[_builtins.bool] adult_content_filtering_enabled: Boolean indicating whether or not adult content will be blocked
        :param pulumi.Input[Sequence[pulumi.Input[Union['WirelessSsidsApTagsAndVlanIdArgs', 'WirelessSsidsApTagsAndVlanIdArgsDict']]]] ap_tags_and_vlan_ids: The list of tags and VLAN IDs used for VLAN tagging. This param is only valid when the ipAssignmentMode is 'Bridge mode' or 'Layer 3 roaming'
        :param pulumi.Input[_builtins.str] auth_mode: The association control method for the SSID
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] availability_tags: List of tags for this SSID. If availableOnAllAps is false, then the SSID is only broadcast by APs with tags matching any of the tags in this list
        :param pulumi.Input[_builtins.bool] available_on_all_aps: Whether all APs broadcast the SSID or if it's restricted to APs matching any availability tags
        :param pulumi.Input[_builtins.str] band_selection: The client-serving radio frequencies of this SSID in the default indoor RF profile
        :param pulumi.Input[_builtins.str] concentrator_network_id: The concentrator to use when the ipAssignmentMode is 'Layer 3 roaming with a concentrator' or 'VPN'.
        :param pulumi.Input[_builtins.int] default_vlan_id: The default VLAN ID used for 'all other APs'. This param is only valid when the ipAssignmentMode is 'Bridge mode' or 'Layer 3 roaming'
        :param pulumi.Input[_builtins.bool] disassociate_clients_on_vpn_failover: Disassociate clients when 'VPN' concentrator failover occurs in order to trigger clients to re-associate and generate new DHCP requests. This param is only valid if ipAssignmentMode is 'VPN'.
        :param pulumi.Input[Union['WirelessSsidsDnsRewriteArgs', 'WirelessSsidsDnsRewriteArgsDict']] dns_rewrite: DNS servers rewrite settings
        :param pulumi.Input[Union['WirelessSsidsDot11rArgs', 'WirelessSsidsDot11rArgsDict']] dot11r: The current setting for 802.11r
        :param pulumi.Input[Union['WirelessSsidsDot11wArgs', 'WirelessSsidsDot11wArgsDict']] dot11w: The current setting for Protected Management Frames (802.11w).
        :param pulumi.Input[_builtins.bool] enabled: Whether or not the SSID is enabled
        :param pulumi.Input[_builtins.str] encryption_mode: The psk encryption mode for the SSID
        :param pulumi.Input[_builtins.str] enterprise_admin_access: Whether or not an SSID is accessible by 'enterprise' administrators ('access disabled' or 'access enabled')
        :param pulumi.Input[Union['WirelessSsidsGreArgs', 'WirelessSsidsGreArgsDict']] gre: Ethernet over GRE settings
        :param pulumi.Input[_builtins.str] ip_assignment_mode: The client IP assignment mode
        :param pulumi.Input[_builtins.bool] lan_isolation_enabled: Boolean indicating whether Layer 2 LAN isolation should be enabled or disabled. Only configurable when ipAssignmentMode is 'Bridge mode'.
        :param pulumi.Input[Union['WirelessSsidsLdapArgs', 'WirelessSsidsLdapArgsDict']] ldap: The current setting for LDAP. Only valid if splashPage is 'Password-protected with LDAP'.
        :param pulumi.Input[Union['WirelessSsidsLocalRadiusArgs', 'WirelessSsidsLocalRadiusArgsDict']] local_radius: The current setting for Local Authentication, a built-in RADIUS server on the access point. Only valid if authMode is '8021x-localradius'.
        :param pulumi.Input[_builtins.bool] mandatory_dhcp_enabled: Whether clients connecting to this SSID must use the IP address assigned by the DHCP server
        :param pulumi.Input[_builtins.int] min_bitrate: The minimum bitrate in Mbps of this SSID in the default indoor RF profile
        :param pulumi.Input[_builtins.str] name: The name of the SSID
        :param pulumi.Input[Union['WirelessSsidsNamedVlansArgs', 'WirelessSsidsNamedVlansArgsDict']] named_vlans: Named VLAN settings.
        :param pulumi.Input[_builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[_builtins.int] number: Unique identifier of the SSID
        :param pulumi.Input[Union['WirelessSsidsOauthArgs', 'WirelessSsidsOauthArgsDict']] oauth: The OAuth settings of this SSID. Only valid if splashPage is 'Google OAuth'.
        :param pulumi.Input[_builtins.int] per_client_bandwidth_limit_down: The download bandwidth limit in Kbps. (0 represents no limit.)
        :param pulumi.Input[_builtins.int] per_client_bandwidth_limit_up: The upload bandwidth limit in Kbps. (0 represents no limit.)
        :param pulumi.Input[_builtins.int] per_ssid_bandwidth_limit_down: The total download bandwidth limit in Kbps (0 represents no limit)
        :param pulumi.Input[_builtins.int] per_ssid_bandwidth_limit_up: The total upload bandwidth limit in Kbps (0 represents no limit)
        :param pulumi.Input[_builtins.str] psk: The passkey for the SSID. This param is only valid if the authMode is 'psk'
        :param pulumi.Input[_builtins.bool] radius_accounting_enabled: Whether or not RADIUS accounting is enabled
        :param pulumi.Input[_builtins.int] radius_accounting_interim_interval: The interval (in seconds) in which accounting information is updated and sent to the RADIUS accounting server.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WirelessSsidsRadiusAccountingServerArgs', 'WirelessSsidsRadiusAccountingServerArgsDict']]]] radius_accounting_servers: List of RADIUS accounting 802.1X servers to be used for authentication
        :param pulumi.Input[_builtins.str] radius_attribute_for_group_policies: RADIUS attribute used to look up group policies
        :param pulumi.Input[_builtins.str] radius_authentication_nas_id: The template of the NAS identifier to be used for RADIUS authentication (ex. $NODE*MAC$:$VAP*NUM$).
        :param pulumi.Input[_builtins.str] radius_called_station_id: The template of the called station identifier to be used for RADIUS (ex. $NODE*MAC$:$VAP*NUM$).
        :param pulumi.Input[_builtins.bool] radius_coa_enabled: If true, Meraki devices will act as a RADIUS Dynamic Authorization Server and will respond to RADIUS Change-of-Authorization and Disconnect messages sent by the RADIUS server.
        :param pulumi.Input[_builtins.str] radius_failover_policy: Policy which determines how authentication requests should be handled in the event that all of the configured RADIUS servers are unreachable
        :param pulumi.Input[_builtins.bool] radius_fallback_enabled: Whether or not higher priority RADIUS servers should be retried after 60 seconds.
        :param pulumi.Input[_builtins.bool] radius_guest_vlan_enabled: Whether or not RADIUS Guest VLAN is enabled. This param is only valid if the authMode is 'open-with-radius' and addressing mode is not set to 'isolated' or 'nat' mode
        :param pulumi.Input[_builtins.int] radius_guest_vlan_id: VLAN ID of the RADIUS Guest VLAN. This param is only valid if the authMode is 'open-with-radius' and addressing mode is not set to 'isolated' or 'nat' mode
        :param pulumi.Input[_builtins.str] radius_load_balancing_policy: Policy which determines which RADIUS server will be contacted first in an authentication attempt, and the ordering of any necessary retry attempts
        :param pulumi.Input[_builtins.bool] radius_override: If true, the RADIUS response can override VLAN tag. This is not valid when ipAssignmentMode is 'NAT mode'.
        :param pulumi.Input[_builtins.bool] radius_proxy_enabled: If true, Meraki devices will proxy RADIUS messages through the Meraki cloud to the configured RADIUS auth and accounting servers.
        :param pulumi.Input[_builtins.int] radius_server_attempts_limit: The maximum number of transmit attempts after which a RADIUS server is failed over (must be between 1-5).
        :param pulumi.Input[_builtins.int] radius_server_timeout: The amount of time for which a RADIUS client waits for a reply from the RADIUS server (must be between 1-10 seconds).
        :param pulumi.Input[Sequence[pulumi.Input[Union['WirelessSsidsRadiusServerArgs', 'WirelessSsidsRadiusServerArgsDict']]]] radius_servers: The RADIUS 802.1X servers to be used for authentication. This param is only valid if the authMode is 'open-with-radius', '8021x-radius' or 'ipsk-with-radius'
        :param pulumi.Input[_builtins.bool] radius_testing_enabled: If true, Meraki devices will periodically send Access-Request messages to configured RADIUS servers using identity 'meraki*8021x*test' to ensure that the RADIUS servers are reachable.
        :param pulumi.Input[_builtins.str] secondary_concentrator_network_id: The secondary concentrator to use when the ipAssignmentMode is 'VPN'. If configured, the APs will switch to using this concentrator if the primary concentrator is unreachable. This param is optional. ('disabled' represents no secondary concentrator.)
        :param pulumi.Input[Union['WirelessSsidsSpeedBurstArgs', 'WirelessSsidsSpeedBurstArgsDict']] speed_burst: The SpeedBurst setting for this SSID'
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] splash_guest_sponsor_domains: Array of valid sponsor email domains for sponsored guest splash type.
        :param pulumi.Input[_builtins.str] splash_page: The type of splash page for the SSID
        :param pulumi.Input[_builtins.bool] use_vlan_tagging: Whether or not traffic should be directed to use specific VLANs. This param is only valid if the ipAssignmentMode is 'Bridge mode' or 'Layer 3 roaming'
        :param pulumi.Input[_builtins.bool] visible: Whether the SSID is advertised or hidden by the AP
        :param pulumi.Input[_builtins.int] vlan_id: The VLAN ID used for VLAN tagging. This param is only valid when the ipAssignmentMode is 'Layer 3 roaming with a concentrator' or 'VPN'
        :param pulumi.Input[_builtins.bool] walled_garden_enabled: Allow users to access a configurable list of IP ranges prior to sign-on
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] walled_garden_ranges: Domain names and IP address ranges available in Walled Garden mode
        :param pulumi.Input[_builtins.str] wpa_encryption_mode: The types of WPA encryption
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WirelessSsidsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import meraki:networks/wirelessSsids:WirelessSsids example "network_id,number"
        ```

        :param str resource_name: The name of the resource.
        :param WirelessSsidsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WirelessSsidsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active_directory: Optional[pulumi.Input[Union['WirelessSsidsActiveDirectoryArgs', 'WirelessSsidsActiveDirectoryArgsDict']]] = None,
                 adult_content_filtering_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ap_tags_and_vlan_ids: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WirelessSsidsApTagsAndVlanIdArgs', 'WirelessSsidsApTagsAndVlanIdArgsDict']]]]] = None,
                 auth_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 available_on_all_aps: Optional[pulumi.Input[_builtins.bool]] = None,
                 band_selection: Optional[pulumi.Input[_builtins.str]] = None,
                 concentrator_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 default_vlan_id: Optional[pulumi.Input[_builtins.int]] = None,
                 disassociate_clients_on_vpn_failover: Optional[pulumi.Input[_builtins.bool]] = None,
                 dns_rewrite: Optional[pulumi.Input[Union['WirelessSsidsDnsRewriteArgs', 'WirelessSsidsDnsRewriteArgsDict']]] = None,
                 dot11r: Optional[pulumi.Input[Union['WirelessSsidsDot11rArgs', 'WirelessSsidsDot11rArgsDict']]] = None,
                 dot11w: Optional[pulumi.Input[Union['WirelessSsidsDot11wArgs', 'WirelessSsidsDot11wArgsDict']]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_admin_access: Optional[pulumi.Input[_builtins.str]] = None,
                 gre: Optional[pulumi.Input[Union['WirelessSsidsGreArgs', 'WirelessSsidsGreArgsDict']]] = None,
                 ip_assignment_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 lan_isolation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ldap: Optional[pulumi.Input[Union['WirelessSsidsLdapArgs', 'WirelessSsidsLdapArgsDict']]] = None,
                 local_radius: Optional[pulumi.Input[Union['WirelessSsidsLocalRadiusArgs', 'WirelessSsidsLocalRadiusArgsDict']]] = None,
                 mandatory_dhcp_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 min_bitrate: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 named_vlans: Optional[pulumi.Input[Union['WirelessSsidsNamedVlansArgs', 'WirelessSsidsNamedVlansArgsDict']]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 number: Optional[pulumi.Input[_builtins.int]] = None,
                 oauth: Optional[pulumi.Input[Union['WirelessSsidsOauthArgs', 'WirelessSsidsOauthArgsDict']]] = None,
                 per_client_bandwidth_limit_down: Optional[pulumi.Input[_builtins.int]] = None,
                 per_client_bandwidth_limit_up: Optional[pulumi.Input[_builtins.int]] = None,
                 per_ssid_bandwidth_limit_down: Optional[pulumi.Input[_builtins.int]] = None,
                 per_ssid_bandwidth_limit_up: Optional[pulumi.Input[_builtins.int]] = None,
                 psk: Optional[pulumi.Input[_builtins.str]] = None,
                 radius_accounting_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 radius_accounting_interim_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 radius_accounting_servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WirelessSsidsRadiusAccountingServerArgs', 'WirelessSsidsRadiusAccountingServerArgsDict']]]]] = None,
                 radius_attribute_for_group_policies: Optional[pulumi.Input[_builtins.str]] = None,
                 radius_authentication_nas_id: Optional[pulumi.Input[_builtins.str]] = None,
                 radius_called_station_id: Optional[pulumi.Input[_builtins.str]] = None,
                 radius_coa_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 radius_failover_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 radius_fallback_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 radius_guest_vlan_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 radius_guest_vlan_id: Optional[pulumi.Input[_builtins.int]] = None,
                 radius_load_balancing_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 radius_override: Optional[pulumi.Input[_builtins.bool]] = None,
                 radius_proxy_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 radius_server_attempts_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 radius_server_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 radius_servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WirelessSsidsRadiusServerArgs', 'WirelessSsidsRadiusServerArgsDict']]]]] = None,
                 radius_testing_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 secondary_concentrator_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 speed_burst: Optional[pulumi.Input[Union['WirelessSsidsSpeedBurstArgs', 'WirelessSsidsSpeedBurstArgsDict']]] = None,
                 splash_guest_sponsor_domains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 splash_page: Optional[pulumi.Input[_builtins.str]] = None,
                 use_vlan_tagging: Optional[pulumi.Input[_builtins.bool]] = None,
                 visible: Optional[pulumi.Input[_builtins.bool]] = None,
                 vlan_id: Optional[pulumi.Input[_builtins.int]] = None,
                 walled_garden_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 walled_garden_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 wpa_encryption_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WirelessSsidsArgs.__new__(WirelessSsidsArgs)

            __props__.__dict__["active_directory"] = active_directory
            __props__.__dict__["adult_content_filtering_enabled"] = adult_content_filtering_enabled
            __props__.__dict__["ap_tags_and_vlan_ids"] = ap_tags_and_vlan_ids
            __props__.__dict__["auth_mode"] = auth_mode
            __props__.__dict__["availability_tags"] = availability_tags
            __props__.__dict__["available_on_all_aps"] = available_on_all_aps
            __props__.__dict__["band_selection"] = band_selection
            __props__.__dict__["concentrator_network_id"] = concentrator_network_id
            __props__.__dict__["default_vlan_id"] = default_vlan_id
            __props__.__dict__["disassociate_clients_on_vpn_failover"] = disassociate_clients_on_vpn_failover
            __props__.__dict__["dns_rewrite"] = dns_rewrite
            __props__.__dict__["dot11r"] = dot11r
            __props__.__dict__["dot11w"] = dot11w
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["encryption_mode"] = encryption_mode
            __props__.__dict__["enterprise_admin_access"] = enterprise_admin_access
            __props__.__dict__["gre"] = gre
            __props__.__dict__["ip_assignment_mode"] = ip_assignment_mode
            __props__.__dict__["lan_isolation_enabled"] = lan_isolation_enabled
            __props__.__dict__["ldap"] = ldap
            __props__.__dict__["local_radius"] = local_radius
            __props__.__dict__["mandatory_dhcp_enabled"] = mandatory_dhcp_enabled
            __props__.__dict__["min_bitrate"] = min_bitrate
            __props__.__dict__["name"] = name
            __props__.__dict__["named_vlans"] = named_vlans
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            if number is None and not opts.urn:
                raise TypeError("Missing required property 'number'")
            __props__.__dict__["number"] = number
            __props__.__dict__["oauth"] = oauth
            __props__.__dict__["per_client_bandwidth_limit_down"] = per_client_bandwidth_limit_down
            __props__.__dict__["per_client_bandwidth_limit_up"] = per_client_bandwidth_limit_up
            __props__.__dict__["per_ssid_bandwidth_limit_down"] = per_ssid_bandwidth_limit_down
            __props__.__dict__["per_ssid_bandwidth_limit_up"] = per_ssid_bandwidth_limit_up
            __props__.__dict__["psk"] = psk
            __props__.__dict__["radius_accounting_enabled"] = radius_accounting_enabled
            __props__.__dict__["radius_accounting_interim_interval"] = radius_accounting_interim_interval
            __props__.__dict__["radius_accounting_servers"] = radius_accounting_servers
            __props__.__dict__["radius_attribute_for_group_policies"] = radius_attribute_for_group_policies
            __props__.__dict__["radius_authentication_nas_id"] = radius_authentication_nas_id
            __props__.__dict__["radius_called_station_id"] = radius_called_station_id
            __props__.__dict__["radius_coa_enabled"] = radius_coa_enabled
            __props__.__dict__["radius_failover_policy"] = radius_failover_policy
            __props__.__dict__["radius_fallback_enabled"] = radius_fallback_enabled
            __props__.__dict__["radius_guest_vlan_enabled"] = radius_guest_vlan_enabled
            __props__.__dict__["radius_guest_vlan_id"] = radius_guest_vlan_id
            __props__.__dict__["radius_load_balancing_policy"] = radius_load_balancing_policy
            __props__.__dict__["radius_override"] = radius_override
            __props__.__dict__["radius_proxy_enabled"] = radius_proxy_enabled
            __props__.__dict__["radius_server_attempts_limit"] = radius_server_attempts_limit
            __props__.__dict__["radius_server_timeout"] = radius_server_timeout
            __props__.__dict__["radius_servers"] = radius_servers
            __props__.__dict__["radius_testing_enabled"] = radius_testing_enabled
            __props__.__dict__["secondary_concentrator_network_id"] = secondary_concentrator_network_id
            __props__.__dict__["speed_burst"] = speed_burst
            __props__.__dict__["splash_guest_sponsor_domains"] = splash_guest_sponsor_domains
            __props__.__dict__["splash_page"] = splash_page
            __props__.__dict__["use_vlan_tagging"] = use_vlan_tagging
            __props__.__dict__["visible"] = visible
            __props__.__dict__["vlan_id"] = vlan_id
            __props__.__dict__["walled_garden_enabled"] = walled_garden_enabled
            __props__.__dict__["walled_garden_ranges"] = walled_garden_ranges
            __props__.__dict__["wpa_encryption_mode"] = wpa_encryption_mode
            __props__.__dict__["admin_splash_url"] = None
            __props__.__dict__["radius_accounting_servers_responses"] = None
            __props__.__dict__["radius_servers_responses"] = None
            __props__.__dict__["splash_timeout"] = None
            __props__.__dict__["ssid_admin_accessible"] = None
        super(WirelessSsids, __self__).__init__(
            'meraki:networks/wirelessSsids:WirelessSsids',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            active_directory: Optional[pulumi.Input[Union['WirelessSsidsActiveDirectoryArgs', 'WirelessSsidsActiveDirectoryArgsDict']]] = None,
            admin_splash_url: Optional[pulumi.Input[_builtins.str]] = None,
            adult_content_filtering_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            ap_tags_and_vlan_ids: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WirelessSsidsApTagsAndVlanIdArgs', 'WirelessSsidsApTagsAndVlanIdArgsDict']]]]] = None,
            auth_mode: Optional[pulumi.Input[_builtins.str]] = None,
            availability_tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            available_on_all_aps: Optional[pulumi.Input[_builtins.bool]] = None,
            band_selection: Optional[pulumi.Input[_builtins.str]] = None,
            concentrator_network_id: Optional[pulumi.Input[_builtins.str]] = None,
            default_vlan_id: Optional[pulumi.Input[_builtins.int]] = None,
            disassociate_clients_on_vpn_failover: Optional[pulumi.Input[_builtins.bool]] = None,
            dns_rewrite: Optional[pulumi.Input[Union['WirelessSsidsDnsRewriteArgs', 'WirelessSsidsDnsRewriteArgsDict']]] = None,
            dot11r: Optional[pulumi.Input[Union['WirelessSsidsDot11rArgs', 'WirelessSsidsDot11rArgsDict']]] = None,
            dot11w: Optional[pulumi.Input[Union['WirelessSsidsDot11wArgs', 'WirelessSsidsDot11wArgsDict']]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            encryption_mode: Optional[pulumi.Input[_builtins.str]] = None,
            enterprise_admin_access: Optional[pulumi.Input[_builtins.str]] = None,
            gre: Optional[pulumi.Input[Union['WirelessSsidsGreArgs', 'WirelessSsidsGreArgsDict']]] = None,
            ip_assignment_mode: Optional[pulumi.Input[_builtins.str]] = None,
            lan_isolation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            ldap: Optional[pulumi.Input[Union['WirelessSsidsLdapArgs', 'WirelessSsidsLdapArgsDict']]] = None,
            local_radius: Optional[pulumi.Input[Union['WirelessSsidsLocalRadiusArgs', 'WirelessSsidsLocalRadiusArgsDict']]] = None,
            mandatory_dhcp_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            min_bitrate: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            named_vlans: Optional[pulumi.Input[Union['WirelessSsidsNamedVlansArgs', 'WirelessSsidsNamedVlansArgsDict']]] = None,
            network_id: Optional[pulumi.Input[_builtins.str]] = None,
            number: Optional[pulumi.Input[_builtins.int]] = None,
            oauth: Optional[pulumi.Input[Union['WirelessSsidsOauthArgs', 'WirelessSsidsOauthArgsDict']]] = None,
            per_client_bandwidth_limit_down: Optional[pulumi.Input[_builtins.int]] = None,
            per_client_bandwidth_limit_up: Optional[pulumi.Input[_builtins.int]] = None,
            per_ssid_bandwidth_limit_down: Optional[pulumi.Input[_builtins.int]] = None,
            per_ssid_bandwidth_limit_up: Optional[pulumi.Input[_builtins.int]] = None,
            psk: Optional[pulumi.Input[_builtins.str]] = None,
            radius_accounting_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            radius_accounting_interim_interval: Optional[pulumi.Input[_builtins.int]] = None,
            radius_accounting_servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WirelessSsidsRadiusAccountingServerArgs', 'WirelessSsidsRadiusAccountingServerArgsDict']]]]] = None,
            radius_accounting_servers_responses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WirelessSsidsRadiusAccountingServersResponseArgs', 'WirelessSsidsRadiusAccountingServersResponseArgsDict']]]]] = None,
            radius_attribute_for_group_policies: Optional[pulumi.Input[_builtins.str]] = None,
            radius_authentication_nas_id: Optional[pulumi.Input[_builtins.str]] = None,
            radius_called_station_id: Optional[pulumi.Input[_builtins.str]] = None,
            radius_coa_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            radius_failover_policy: Optional[pulumi.Input[_builtins.str]] = None,
            radius_fallback_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            radius_guest_vlan_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            radius_guest_vlan_id: Optional[pulumi.Input[_builtins.int]] = None,
            radius_load_balancing_policy: Optional[pulumi.Input[_builtins.str]] = None,
            radius_override: Optional[pulumi.Input[_builtins.bool]] = None,
            radius_proxy_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            radius_server_attempts_limit: Optional[pulumi.Input[_builtins.int]] = None,
            radius_server_timeout: Optional[pulumi.Input[_builtins.int]] = None,
            radius_servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WirelessSsidsRadiusServerArgs', 'WirelessSsidsRadiusServerArgsDict']]]]] = None,
            radius_servers_responses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WirelessSsidsRadiusServersResponseArgs', 'WirelessSsidsRadiusServersResponseArgsDict']]]]] = None,
            radius_testing_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            secondary_concentrator_network_id: Optional[pulumi.Input[_builtins.str]] = None,
            speed_burst: Optional[pulumi.Input[Union['WirelessSsidsSpeedBurstArgs', 'WirelessSsidsSpeedBurstArgsDict']]] = None,
            splash_guest_sponsor_domains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            splash_page: Optional[pulumi.Input[_builtins.str]] = None,
            splash_timeout: Optional[pulumi.Input[_builtins.str]] = None,
            ssid_admin_accessible: Optional[pulumi.Input[_builtins.bool]] = None,
            use_vlan_tagging: Optional[pulumi.Input[_builtins.bool]] = None,
            visible: Optional[pulumi.Input[_builtins.bool]] = None,
            vlan_id: Optional[pulumi.Input[_builtins.int]] = None,
            walled_garden_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            walled_garden_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            wpa_encryption_mode: Optional[pulumi.Input[_builtins.str]] = None) -> 'WirelessSsids':
        """
        Get an existing WirelessSsids resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['WirelessSsidsActiveDirectoryArgs', 'WirelessSsidsActiveDirectoryArgsDict']] active_directory: The current setting for Active Directory. Only valid if splashPage is 'Password-protected with Active Directory'
        :param pulumi.Input[_builtins.bool] adult_content_filtering_enabled: Boolean indicating whether or not adult content will be blocked
        :param pulumi.Input[Sequence[pulumi.Input[Union['WirelessSsidsApTagsAndVlanIdArgs', 'WirelessSsidsApTagsAndVlanIdArgsDict']]]] ap_tags_and_vlan_ids: The list of tags and VLAN IDs used for VLAN tagging. This param is only valid when the ipAssignmentMode is 'Bridge mode' or 'Layer 3 roaming'
        :param pulumi.Input[_builtins.str] auth_mode: The association control method for the SSID
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] availability_tags: List of tags for this SSID. If availableOnAllAps is false, then the SSID is only broadcast by APs with tags matching any of the tags in this list
        :param pulumi.Input[_builtins.bool] available_on_all_aps: Whether all APs broadcast the SSID or if it's restricted to APs matching any availability tags
        :param pulumi.Input[_builtins.str] band_selection: The client-serving radio frequencies of this SSID in the default indoor RF profile
        :param pulumi.Input[_builtins.str] concentrator_network_id: The concentrator to use when the ipAssignmentMode is 'Layer 3 roaming with a concentrator' or 'VPN'.
        :param pulumi.Input[_builtins.int] default_vlan_id: The default VLAN ID used for 'all other APs'. This param is only valid when the ipAssignmentMode is 'Bridge mode' or 'Layer 3 roaming'
        :param pulumi.Input[_builtins.bool] disassociate_clients_on_vpn_failover: Disassociate clients when 'VPN' concentrator failover occurs in order to trigger clients to re-associate and generate new DHCP requests. This param is only valid if ipAssignmentMode is 'VPN'.
        :param pulumi.Input[Union['WirelessSsidsDnsRewriteArgs', 'WirelessSsidsDnsRewriteArgsDict']] dns_rewrite: DNS servers rewrite settings
        :param pulumi.Input[Union['WirelessSsidsDot11rArgs', 'WirelessSsidsDot11rArgsDict']] dot11r: The current setting for 802.11r
        :param pulumi.Input[Union['WirelessSsidsDot11wArgs', 'WirelessSsidsDot11wArgsDict']] dot11w: The current setting for Protected Management Frames (802.11w).
        :param pulumi.Input[_builtins.bool] enabled: Whether or not the SSID is enabled
        :param pulumi.Input[_builtins.str] encryption_mode: The psk encryption mode for the SSID
        :param pulumi.Input[_builtins.str] enterprise_admin_access: Whether or not an SSID is accessible by 'enterprise' administrators ('access disabled' or 'access enabled')
        :param pulumi.Input[Union['WirelessSsidsGreArgs', 'WirelessSsidsGreArgsDict']] gre: Ethernet over GRE settings
        :param pulumi.Input[_builtins.str] ip_assignment_mode: The client IP assignment mode
        :param pulumi.Input[_builtins.bool] lan_isolation_enabled: Boolean indicating whether Layer 2 LAN isolation should be enabled or disabled. Only configurable when ipAssignmentMode is 'Bridge mode'.
        :param pulumi.Input[Union['WirelessSsidsLdapArgs', 'WirelessSsidsLdapArgsDict']] ldap: The current setting for LDAP. Only valid if splashPage is 'Password-protected with LDAP'.
        :param pulumi.Input[Union['WirelessSsidsLocalRadiusArgs', 'WirelessSsidsLocalRadiusArgsDict']] local_radius: The current setting for Local Authentication, a built-in RADIUS server on the access point. Only valid if authMode is '8021x-localradius'.
        :param pulumi.Input[_builtins.bool] mandatory_dhcp_enabled: Whether clients connecting to this SSID must use the IP address assigned by the DHCP server
        :param pulumi.Input[_builtins.int] min_bitrate: The minimum bitrate in Mbps of this SSID in the default indoor RF profile
        :param pulumi.Input[_builtins.str] name: The name of the SSID
        :param pulumi.Input[Union['WirelessSsidsNamedVlansArgs', 'WirelessSsidsNamedVlansArgsDict']] named_vlans: Named VLAN settings.
        :param pulumi.Input[_builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[_builtins.int] number: Unique identifier of the SSID
        :param pulumi.Input[Union['WirelessSsidsOauthArgs', 'WirelessSsidsOauthArgsDict']] oauth: The OAuth settings of this SSID. Only valid if splashPage is 'Google OAuth'.
        :param pulumi.Input[_builtins.int] per_client_bandwidth_limit_down: The download bandwidth limit in Kbps. (0 represents no limit.)
        :param pulumi.Input[_builtins.int] per_client_bandwidth_limit_up: The upload bandwidth limit in Kbps. (0 represents no limit.)
        :param pulumi.Input[_builtins.int] per_ssid_bandwidth_limit_down: The total download bandwidth limit in Kbps (0 represents no limit)
        :param pulumi.Input[_builtins.int] per_ssid_bandwidth_limit_up: The total upload bandwidth limit in Kbps (0 represents no limit)
        :param pulumi.Input[_builtins.str] psk: The passkey for the SSID. This param is only valid if the authMode is 'psk'
        :param pulumi.Input[_builtins.bool] radius_accounting_enabled: Whether or not RADIUS accounting is enabled
        :param pulumi.Input[_builtins.int] radius_accounting_interim_interval: The interval (in seconds) in which accounting information is updated and sent to the RADIUS accounting server.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WirelessSsidsRadiusAccountingServerArgs', 'WirelessSsidsRadiusAccountingServerArgsDict']]]] radius_accounting_servers: List of RADIUS accounting 802.1X servers to be used for authentication
        :param pulumi.Input[Sequence[pulumi.Input[Union['WirelessSsidsRadiusAccountingServersResponseArgs', 'WirelessSsidsRadiusAccountingServersResponseArgsDict']]]] radius_accounting_servers_responses: List of RADIUS accounting 802.1X servers to be used for authentication
        :param pulumi.Input[_builtins.str] radius_attribute_for_group_policies: RADIUS attribute used to look up group policies
        :param pulumi.Input[_builtins.str] radius_authentication_nas_id: The template of the NAS identifier to be used for RADIUS authentication (ex. $NODE*MAC$:$VAP*NUM$).
        :param pulumi.Input[_builtins.str] radius_called_station_id: The template of the called station identifier to be used for RADIUS (ex. $NODE*MAC$:$VAP*NUM$).
        :param pulumi.Input[_builtins.bool] radius_coa_enabled: If true, Meraki devices will act as a RADIUS Dynamic Authorization Server and will respond to RADIUS Change-of-Authorization and Disconnect messages sent by the RADIUS server.
        :param pulumi.Input[_builtins.str] radius_failover_policy: Policy which determines how authentication requests should be handled in the event that all of the configured RADIUS servers are unreachable
        :param pulumi.Input[_builtins.bool] radius_fallback_enabled: Whether or not higher priority RADIUS servers should be retried after 60 seconds.
        :param pulumi.Input[_builtins.bool] radius_guest_vlan_enabled: Whether or not RADIUS Guest VLAN is enabled. This param is only valid if the authMode is 'open-with-radius' and addressing mode is not set to 'isolated' or 'nat' mode
        :param pulumi.Input[_builtins.int] radius_guest_vlan_id: VLAN ID of the RADIUS Guest VLAN. This param is only valid if the authMode is 'open-with-radius' and addressing mode is not set to 'isolated' or 'nat' mode
        :param pulumi.Input[_builtins.str] radius_load_balancing_policy: Policy which determines which RADIUS server will be contacted first in an authentication attempt, and the ordering of any necessary retry attempts
        :param pulumi.Input[_builtins.bool] radius_override: If true, the RADIUS response can override VLAN tag. This is not valid when ipAssignmentMode is 'NAT mode'.
        :param pulumi.Input[_builtins.bool] radius_proxy_enabled: If true, Meraki devices will proxy RADIUS messages through the Meraki cloud to the configured RADIUS auth and accounting servers.
        :param pulumi.Input[_builtins.int] radius_server_attempts_limit: The maximum number of transmit attempts after which a RADIUS server is failed over (must be between 1-5).
        :param pulumi.Input[_builtins.int] radius_server_timeout: The amount of time for which a RADIUS client waits for a reply from the RADIUS server (must be between 1-10 seconds).
        :param pulumi.Input[Sequence[pulumi.Input[Union['WirelessSsidsRadiusServerArgs', 'WirelessSsidsRadiusServerArgsDict']]]] radius_servers: The RADIUS 802.1X servers to be used for authentication. This param is only valid if the authMode is 'open-with-radius', '8021x-radius' or 'ipsk-with-radius'
        :param pulumi.Input[Sequence[pulumi.Input[Union['WirelessSsidsRadiusServersResponseArgs', 'WirelessSsidsRadiusServersResponseArgsDict']]]] radius_servers_responses: The RADIUS 802.1X servers to be used for authentication. This param is only valid if the authMode is 'open-with-radius', '8021x-radius' or 'ipsk-with-radius'
        :param pulumi.Input[_builtins.bool] radius_testing_enabled: If true, Meraki devices will periodically send Access-Request messages to configured RADIUS servers using identity 'meraki*8021x*test' to ensure that the RADIUS servers are reachable.
        :param pulumi.Input[_builtins.str] secondary_concentrator_network_id: The secondary concentrator to use when the ipAssignmentMode is 'VPN'. If configured, the APs will switch to using this concentrator if the primary concentrator is unreachable. This param is optional. ('disabled' represents no secondary concentrator.)
        :param pulumi.Input[Union['WirelessSsidsSpeedBurstArgs', 'WirelessSsidsSpeedBurstArgsDict']] speed_burst: The SpeedBurst setting for this SSID'
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] splash_guest_sponsor_domains: Array of valid sponsor email domains for sponsored guest splash type.
        :param pulumi.Input[_builtins.str] splash_page: The type of splash page for the SSID
        :param pulumi.Input[_builtins.str] splash_timeout: Splash page timeout
        :param pulumi.Input[_builtins.bool] ssid_admin_accessible: SSID Administrator access status
        :param pulumi.Input[_builtins.bool] use_vlan_tagging: Whether or not traffic should be directed to use specific VLANs. This param is only valid if the ipAssignmentMode is 'Bridge mode' or 'Layer 3 roaming'
        :param pulumi.Input[_builtins.bool] visible: Whether the SSID is advertised or hidden by the AP
        :param pulumi.Input[_builtins.int] vlan_id: The VLAN ID used for VLAN tagging. This param is only valid when the ipAssignmentMode is 'Layer 3 roaming with a concentrator' or 'VPN'
        :param pulumi.Input[_builtins.bool] walled_garden_enabled: Allow users to access a configurable list of IP ranges prior to sign-on
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] walled_garden_ranges: Domain names and IP address ranges available in Walled Garden mode
        :param pulumi.Input[_builtins.str] wpa_encryption_mode: The types of WPA encryption
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WirelessSsidsState.__new__(_WirelessSsidsState)

        __props__.__dict__["active_directory"] = active_directory
        __props__.__dict__["admin_splash_url"] = admin_splash_url
        __props__.__dict__["adult_content_filtering_enabled"] = adult_content_filtering_enabled
        __props__.__dict__["ap_tags_and_vlan_ids"] = ap_tags_and_vlan_ids
        __props__.__dict__["auth_mode"] = auth_mode
        __props__.__dict__["availability_tags"] = availability_tags
        __props__.__dict__["available_on_all_aps"] = available_on_all_aps
        __props__.__dict__["band_selection"] = band_selection
        __props__.__dict__["concentrator_network_id"] = concentrator_network_id
        __props__.__dict__["default_vlan_id"] = default_vlan_id
        __props__.__dict__["disassociate_clients_on_vpn_failover"] = disassociate_clients_on_vpn_failover
        __props__.__dict__["dns_rewrite"] = dns_rewrite
        __props__.__dict__["dot11r"] = dot11r
        __props__.__dict__["dot11w"] = dot11w
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["encryption_mode"] = encryption_mode
        __props__.__dict__["enterprise_admin_access"] = enterprise_admin_access
        __props__.__dict__["gre"] = gre
        __props__.__dict__["ip_assignment_mode"] = ip_assignment_mode
        __props__.__dict__["lan_isolation_enabled"] = lan_isolation_enabled
        __props__.__dict__["ldap"] = ldap
        __props__.__dict__["local_radius"] = local_radius
        __props__.__dict__["mandatory_dhcp_enabled"] = mandatory_dhcp_enabled
        __props__.__dict__["min_bitrate"] = min_bitrate
        __props__.__dict__["name"] = name
        __props__.__dict__["named_vlans"] = named_vlans
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["number"] = number
        __props__.__dict__["oauth"] = oauth
        __props__.__dict__["per_client_bandwidth_limit_down"] = per_client_bandwidth_limit_down
        __props__.__dict__["per_client_bandwidth_limit_up"] = per_client_bandwidth_limit_up
        __props__.__dict__["per_ssid_bandwidth_limit_down"] = per_ssid_bandwidth_limit_down
        __props__.__dict__["per_ssid_bandwidth_limit_up"] = per_ssid_bandwidth_limit_up
        __props__.__dict__["psk"] = psk
        __props__.__dict__["radius_accounting_enabled"] = radius_accounting_enabled
        __props__.__dict__["radius_accounting_interim_interval"] = radius_accounting_interim_interval
        __props__.__dict__["radius_accounting_servers"] = radius_accounting_servers
        __props__.__dict__["radius_accounting_servers_responses"] = radius_accounting_servers_responses
        __props__.__dict__["radius_attribute_for_group_policies"] = radius_attribute_for_group_policies
        __props__.__dict__["radius_authentication_nas_id"] = radius_authentication_nas_id
        __props__.__dict__["radius_called_station_id"] = radius_called_station_id
        __props__.__dict__["radius_coa_enabled"] = radius_coa_enabled
        __props__.__dict__["radius_failover_policy"] = radius_failover_policy
        __props__.__dict__["radius_fallback_enabled"] = radius_fallback_enabled
        __props__.__dict__["radius_guest_vlan_enabled"] = radius_guest_vlan_enabled
        __props__.__dict__["radius_guest_vlan_id"] = radius_guest_vlan_id
        __props__.__dict__["radius_load_balancing_policy"] = radius_load_balancing_policy
        __props__.__dict__["radius_override"] = radius_override
        __props__.__dict__["radius_proxy_enabled"] = radius_proxy_enabled
        __props__.__dict__["radius_server_attempts_limit"] = radius_server_attempts_limit
        __props__.__dict__["radius_server_timeout"] = radius_server_timeout
        __props__.__dict__["radius_servers"] = radius_servers
        __props__.__dict__["radius_servers_responses"] = radius_servers_responses
        __props__.__dict__["radius_testing_enabled"] = radius_testing_enabled
        __props__.__dict__["secondary_concentrator_network_id"] = secondary_concentrator_network_id
        __props__.__dict__["speed_burst"] = speed_burst
        __props__.__dict__["splash_guest_sponsor_domains"] = splash_guest_sponsor_domains
        __props__.__dict__["splash_page"] = splash_page
        __props__.__dict__["splash_timeout"] = splash_timeout
        __props__.__dict__["ssid_admin_accessible"] = ssid_admin_accessible
        __props__.__dict__["use_vlan_tagging"] = use_vlan_tagging
        __props__.__dict__["visible"] = visible
        __props__.__dict__["vlan_id"] = vlan_id
        __props__.__dict__["walled_garden_enabled"] = walled_garden_enabled
        __props__.__dict__["walled_garden_ranges"] = walled_garden_ranges
        __props__.__dict__["wpa_encryption_mode"] = wpa_encryption_mode
        return WirelessSsids(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="activeDirectory")
    def active_directory(self) -> pulumi.Output[Optional['outputs.WirelessSsidsActiveDirectory']]:
        """
        The current setting for Active Directory. Only valid if splashPage is 'Password-protected with Active Directory'
        """
        return pulumi.get(self, "active_directory")

    @_builtins.property
    @pulumi.getter(name="adminSplashUrl")
    def admin_splash_url(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "admin_splash_url")

    @_builtins.property
    @pulumi.getter(name="adultContentFilteringEnabled")
    def adult_content_filtering_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Boolean indicating whether or not adult content will be blocked
        """
        return pulumi.get(self, "adult_content_filtering_enabled")

    @_builtins.property
    @pulumi.getter(name="apTagsAndVlanIds")
    def ap_tags_and_vlan_ids(self) -> pulumi.Output[Optional[Sequence['outputs.WirelessSsidsApTagsAndVlanId']]]:
        """
        The list of tags and VLAN IDs used for VLAN tagging. This param is only valid when the ipAssignmentMode is 'Bridge mode' or 'Layer 3 roaming'
        """
        return pulumi.get(self, "ap_tags_and_vlan_ids")

    @_builtins.property
    @pulumi.getter(name="authMode")
    def auth_mode(self) -> pulumi.Output[_builtins.str]:
        """
        The association control method for the SSID
        """
        return pulumi.get(self, "auth_mode")

    @_builtins.property
    @pulumi.getter(name="availabilityTags")
    def availability_tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of tags for this SSID. If availableOnAllAps is false, then the SSID is only broadcast by APs with tags matching any of the tags in this list
        """
        return pulumi.get(self, "availability_tags")

    @_builtins.property
    @pulumi.getter(name="availableOnAllAps")
    def available_on_all_aps(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether all APs broadcast the SSID or if it's restricted to APs matching any availability tags
        """
        return pulumi.get(self, "available_on_all_aps")

    @_builtins.property
    @pulumi.getter(name="bandSelection")
    def band_selection(self) -> pulumi.Output[_builtins.str]:
        """
        The client-serving radio frequencies of this SSID in the default indoor RF profile
        """
        return pulumi.get(self, "band_selection")

    @_builtins.property
    @pulumi.getter(name="concentratorNetworkId")
    def concentrator_network_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The concentrator to use when the ipAssignmentMode is 'Layer 3 roaming with a concentrator' or 'VPN'.
        """
        return pulumi.get(self, "concentrator_network_id")

    @_builtins.property
    @pulumi.getter(name="defaultVlanId")
    def default_vlan_id(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The default VLAN ID used for 'all other APs'. This param is only valid when the ipAssignmentMode is 'Bridge mode' or 'Layer 3 roaming'
        """
        return pulumi.get(self, "default_vlan_id")

    @_builtins.property
    @pulumi.getter(name="disassociateClientsOnVpnFailover")
    def disassociate_clients_on_vpn_failover(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Disassociate clients when 'VPN' concentrator failover occurs in order to trigger clients to re-associate and generate new DHCP requests. This param is only valid if ipAssignmentMode is 'VPN'.
        """
        return pulumi.get(self, "disassociate_clients_on_vpn_failover")

    @_builtins.property
    @pulumi.getter(name="dnsRewrite")
    def dns_rewrite(self) -> pulumi.Output[Optional['outputs.WirelessSsidsDnsRewrite']]:
        """
        DNS servers rewrite settings
        """
        return pulumi.get(self, "dns_rewrite")

    @_builtins.property
    @pulumi.getter
    def dot11r(self) -> pulumi.Output[Optional['outputs.WirelessSsidsDot11r']]:
        """
        The current setting for 802.11r
        """
        return pulumi.get(self, "dot11r")

    @_builtins.property
    @pulumi.getter
    def dot11w(self) -> pulumi.Output[Optional['outputs.WirelessSsidsDot11w']]:
        """
        The current setting for Protected Management Frames (802.11w).
        """
        return pulumi.get(self, "dot11w")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether or not the SSID is enabled
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="encryptionMode")
    def encryption_mode(self) -> pulumi.Output[_builtins.str]:
        """
        The psk encryption mode for the SSID
        """
        return pulumi.get(self, "encryption_mode")

    @_builtins.property
    @pulumi.getter(name="enterpriseAdminAccess")
    def enterprise_admin_access(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Whether or not an SSID is accessible by 'enterprise' administrators ('access disabled' or 'access enabled')
        """
        return pulumi.get(self, "enterprise_admin_access")

    @_builtins.property
    @pulumi.getter
    def gre(self) -> pulumi.Output[Optional['outputs.WirelessSsidsGre']]:
        """
        Ethernet over GRE settings
        """
        return pulumi.get(self, "gre")

    @_builtins.property
    @pulumi.getter(name="ipAssignmentMode")
    def ip_assignment_mode(self) -> pulumi.Output[_builtins.str]:
        """
        The client IP assignment mode
        """
        return pulumi.get(self, "ip_assignment_mode")

    @_builtins.property
    @pulumi.getter(name="lanIsolationEnabled")
    def lan_isolation_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Boolean indicating whether Layer 2 LAN isolation should be enabled or disabled. Only configurable when ipAssignmentMode is 'Bridge mode'.
        """
        return pulumi.get(self, "lan_isolation_enabled")

    @_builtins.property
    @pulumi.getter
    def ldap(self) -> pulumi.Output[Optional['outputs.WirelessSsidsLdap']]:
        """
        The current setting for LDAP. Only valid if splashPage is 'Password-protected with LDAP'.
        """
        return pulumi.get(self, "ldap")

    @_builtins.property
    @pulumi.getter(name="localRadius")
    def local_radius(self) -> pulumi.Output[Optional['outputs.WirelessSsidsLocalRadius']]:
        """
        The current setting for Local Authentication, a built-in RADIUS server on the access point. Only valid if authMode is '8021x-localradius'.
        """
        return pulumi.get(self, "local_radius")

    @_builtins.property
    @pulumi.getter(name="mandatoryDhcpEnabled")
    def mandatory_dhcp_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether clients connecting to this SSID must use the IP address assigned by the DHCP server
        """
        return pulumi.get(self, "mandatory_dhcp_enabled")

    @_builtins.property
    @pulumi.getter(name="minBitrate")
    def min_bitrate(self) -> pulumi.Output[_builtins.int]:
        """
        The minimum bitrate in Mbps of this SSID in the default indoor RF profile
        """
        return pulumi.get(self, "min_bitrate")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the SSID
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="namedVlans")
    def named_vlans(self) -> pulumi.Output[Optional['outputs.WirelessSsidsNamedVlans']]:
        """
        Named VLAN settings.
        """
        return pulumi.get(self, "named_vlans")

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[_builtins.str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @_builtins.property
    @pulumi.getter
    def number(self) -> pulumi.Output[_builtins.int]:
        """
        Unique identifier of the SSID
        """
        return pulumi.get(self, "number")

    @_builtins.property
    @pulumi.getter
    def oauth(self) -> pulumi.Output[Optional['outputs.WirelessSsidsOauth']]:
        """
        The OAuth settings of this SSID. Only valid if splashPage is 'Google OAuth'.
        """
        return pulumi.get(self, "oauth")

    @_builtins.property
    @pulumi.getter(name="perClientBandwidthLimitDown")
    def per_client_bandwidth_limit_down(self) -> pulumi.Output[_builtins.int]:
        """
        The download bandwidth limit in Kbps. (0 represents no limit.)
        """
        return pulumi.get(self, "per_client_bandwidth_limit_down")

    @_builtins.property
    @pulumi.getter(name="perClientBandwidthLimitUp")
    def per_client_bandwidth_limit_up(self) -> pulumi.Output[_builtins.int]:
        """
        The upload bandwidth limit in Kbps. (0 represents no limit.)
        """
        return pulumi.get(self, "per_client_bandwidth_limit_up")

    @_builtins.property
    @pulumi.getter(name="perSsidBandwidthLimitDown")
    def per_ssid_bandwidth_limit_down(self) -> pulumi.Output[_builtins.int]:
        """
        The total download bandwidth limit in Kbps (0 represents no limit)
        """
        return pulumi.get(self, "per_ssid_bandwidth_limit_down")

    @_builtins.property
    @pulumi.getter(name="perSsidBandwidthLimitUp")
    def per_ssid_bandwidth_limit_up(self) -> pulumi.Output[_builtins.int]:
        """
        The total upload bandwidth limit in Kbps (0 represents no limit)
        """
        return pulumi.get(self, "per_ssid_bandwidth_limit_up")

    @_builtins.property
    @pulumi.getter
    def psk(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The passkey for the SSID. This param is only valid if the authMode is 'psk'
        """
        return pulumi.get(self, "psk")

    @_builtins.property
    @pulumi.getter(name="radiusAccountingEnabled")
    def radius_accounting_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether or not RADIUS accounting is enabled
        """
        return pulumi.get(self, "radius_accounting_enabled")

    @_builtins.property
    @pulumi.getter(name="radiusAccountingInterimInterval")
    def radius_accounting_interim_interval(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The interval (in seconds) in which accounting information is updated and sent to the RADIUS accounting server.
        """
        return pulumi.get(self, "radius_accounting_interim_interval")

    @_builtins.property
    @pulumi.getter(name="radiusAccountingServers")
    def radius_accounting_servers(self) -> pulumi.Output[Optional[Sequence['outputs.WirelessSsidsRadiusAccountingServer']]]:
        """
        List of RADIUS accounting 802.1X servers to be used for authentication
        """
        return pulumi.get(self, "radius_accounting_servers")

    @_builtins.property
    @pulumi.getter(name="radiusAccountingServersResponses")
    def radius_accounting_servers_responses(self) -> pulumi.Output[Sequence['outputs.WirelessSsidsRadiusAccountingServersResponse']]:
        """
        List of RADIUS accounting 802.1X servers to be used for authentication
        """
        return pulumi.get(self, "radius_accounting_servers_responses")

    @_builtins.property
    @pulumi.getter(name="radiusAttributeForGroupPolicies")
    def radius_attribute_for_group_policies(self) -> pulumi.Output[_builtins.str]:
        """
        RADIUS attribute used to look up group policies
        """
        return pulumi.get(self, "radius_attribute_for_group_policies")

    @_builtins.property
    @pulumi.getter(name="radiusAuthenticationNasId")
    def radius_authentication_nas_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The template of the NAS identifier to be used for RADIUS authentication (ex. $NODE*MAC$:$VAP*NUM$).
        """
        return pulumi.get(self, "radius_authentication_nas_id")

    @_builtins.property
    @pulumi.getter(name="radiusCalledStationId")
    def radius_called_station_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The template of the called station identifier to be used for RADIUS (ex. $NODE*MAC$:$VAP*NUM$).
        """
        return pulumi.get(self, "radius_called_station_id")

    @_builtins.property
    @pulumi.getter(name="radiusCoaEnabled")
    def radius_coa_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If true, Meraki devices will act as a RADIUS Dynamic Authorization Server and will respond to RADIUS Change-of-Authorization and Disconnect messages sent by the RADIUS server.
        """
        return pulumi.get(self, "radius_coa_enabled")

    @_builtins.property
    @pulumi.getter(name="radiusFailoverPolicy")
    def radius_failover_policy(self) -> pulumi.Output[_builtins.str]:
        """
        Policy which determines how authentication requests should be handled in the event that all of the configured RADIUS servers are unreachable
        """
        return pulumi.get(self, "radius_failover_policy")

    @_builtins.property
    @pulumi.getter(name="radiusFallbackEnabled")
    def radius_fallback_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether or not higher priority RADIUS servers should be retried after 60 seconds.
        """
        return pulumi.get(self, "radius_fallback_enabled")

    @_builtins.property
    @pulumi.getter(name="radiusGuestVlanEnabled")
    def radius_guest_vlan_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether or not RADIUS Guest VLAN is enabled. This param is only valid if the authMode is 'open-with-radius' and addressing mode is not set to 'isolated' or 'nat' mode
        """
        return pulumi.get(self, "radius_guest_vlan_enabled")

    @_builtins.property
    @pulumi.getter(name="radiusGuestVlanId")
    def radius_guest_vlan_id(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        VLAN ID of the RADIUS Guest VLAN. This param is only valid if the authMode is 'open-with-radius' and addressing mode is not set to 'isolated' or 'nat' mode
        """
        return pulumi.get(self, "radius_guest_vlan_id")

    @_builtins.property
    @pulumi.getter(name="radiusLoadBalancingPolicy")
    def radius_load_balancing_policy(self) -> pulumi.Output[_builtins.str]:
        """
        Policy which determines which RADIUS server will be contacted first in an authentication attempt, and the ordering of any necessary retry attempts
        """
        return pulumi.get(self, "radius_load_balancing_policy")

    @_builtins.property
    @pulumi.getter(name="radiusOverride")
    def radius_override(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If true, the RADIUS response can override VLAN tag. This is not valid when ipAssignmentMode is 'NAT mode'.
        """
        return pulumi.get(self, "radius_override")

    @_builtins.property
    @pulumi.getter(name="radiusProxyEnabled")
    def radius_proxy_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If true, Meraki devices will proxy RADIUS messages through the Meraki cloud to the configured RADIUS auth and accounting servers.
        """
        return pulumi.get(self, "radius_proxy_enabled")

    @_builtins.property
    @pulumi.getter(name="radiusServerAttemptsLimit")
    def radius_server_attempts_limit(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The maximum number of transmit attempts after which a RADIUS server is failed over (must be between 1-5).
        """
        return pulumi.get(self, "radius_server_attempts_limit")

    @_builtins.property
    @pulumi.getter(name="radiusServerTimeout")
    def radius_server_timeout(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The amount of time for which a RADIUS client waits for a reply from the RADIUS server (must be between 1-10 seconds).
        """
        return pulumi.get(self, "radius_server_timeout")

    @_builtins.property
    @pulumi.getter(name="radiusServers")
    def radius_servers(self) -> pulumi.Output[Optional[Sequence['outputs.WirelessSsidsRadiusServer']]]:
        """
        The RADIUS 802.1X servers to be used for authentication. This param is only valid if the authMode is 'open-with-radius', '8021x-radius' or 'ipsk-with-radius'
        """
        return pulumi.get(self, "radius_servers")

    @_builtins.property
    @pulumi.getter(name="radiusServersResponses")
    def radius_servers_responses(self) -> pulumi.Output[Sequence['outputs.WirelessSsidsRadiusServersResponse']]:
        """
        The RADIUS 802.1X servers to be used for authentication. This param is only valid if the authMode is 'open-with-radius', '8021x-radius' or 'ipsk-with-radius'
        """
        return pulumi.get(self, "radius_servers_responses")

    @_builtins.property
    @pulumi.getter(name="radiusTestingEnabled")
    def radius_testing_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If true, Meraki devices will periodically send Access-Request messages to configured RADIUS servers using identity 'meraki*8021x*test' to ensure that the RADIUS servers are reachable.
        """
        return pulumi.get(self, "radius_testing_enabled")

    @_builtins.property
    @pulumi.getter(name="secondaryConcentratorNetworkId")
    def secondary_concentrator_network_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The secondary concentrator to use when the ipAssignmentMode is 'VPN'. If configured, the APs will switch to using this concentrator if the primary concentrator is unreachable. This param is optional. ('disabled' represents no secondary concentrator.)
        """
        return pulumi.get(self, "secondary_concentrator_network_id")

    @_builtins.property
    @pulumi.getter(name="speedBurst")
    def speed_burst(self) -> pulumi.Output[Optional['outputs.WirelessSsidsSpeedBurst']]:
        """
        The SpeedBurst setting for this SSID'
        """
        return pulumi.get(self, "speed_burst")

    @_builtins.property
    @pulumi.getter(name="splashGuestSponsorDomains")
    def splash_guest_sponsor_domains(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Array of valid sponsor email domains for sponsored guest splash type.
        """
        return pulumi.get(self, "splash_guest_sponsor_domains")

    @_builtins.property
    @pulumi.getter(name="splashPage")
    def splash_page(self) -> pulumi.Output[_builtins.str]:
        """
        The type of splash page for the SSID
        """
        return pulumi.get(self, "splash_page")

    @_builtins.property
    @pulumi.getter(name="splashTimeout")
    def splash_timeout(self) -> pulumi.Output[_builtins.str]:
        """
        Splash page timeout
        """
        return pulumi.get(self, "splash_timeout")

    @_builtins.property
    @pulumi.getter(name="ssidAdminAccessible")
    def ssid_admin_accessible(self) -> pulumi.Output[_builtins.bool]:
        """
        SSID Administrator access status
        """
        return pulumi.get(self, "ssid_admin_accessible")

    @_builtins.property
    @pulumi.getter(name="useVlanTagging")
    def use_vlan_tagging(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether or not traffic should be directed to use specific VLANs. This param is only valid if the ipAssignmentMode is 'Bridge mode' or 'Layer 3 roaming'
        """
        return pulumi.get(self, "use_vlan_tagging")

    @_builtins.property
    @pulumi.getter
    def visible(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the SSID is advertised or hidden by the AP
        """
        return pulumi.get(self, "visible")

    @_builtins.property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The VLAN ID used for VLAN tagging. This param is only valid when the ipAssignmentMode is 'Layer 3 roaming with a concentrator' or 'VPN'
        """
        return pulumi.get(self, "vlan_id")

    @_builtins.property
    @pulumi.getter(name="walledGardenEnabled")
    def walled_garden_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Allow users to access a configurable list of IP ranges prior to sign-on
        """
        return pulumi.get(self, "walled_garden_enabled")

    @_builtins.property
    @pulumi.getter(name="walledGardenRanges")
    def walled_garden_ranges(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Domain names and IP address ranges available in Walled Garden mode
        """
        return pulumi.get(self, "walled_garden_ranges")

    @_builtins.property
    @pulumi.getter(name="wpaEncryptionMode")
    def wpa_encryption_mode(self) -> pulumi.Output[_builtins.str]:
        """
        The types of WPA encryption
        """
        return pulumi.get(self, "wpa_encryption_mode")

