"""
Auto - generated by AutoFix
Helper Functions Module for AutoFix Engine

Provides utility functions for common operations across the AutoFix system.
"""

import logging
from typing import Any, List, Dict, Optional

logger = logging.getLogger(__name__)


def calculate_sum(*args) -> float:
    """Calculate sum with better type handling"""
    try:
        # Flatten nested structures
        def flatten(items):
            result = []
            for item in items:
                if isinstance(item, (list, tuple)):
                    result.extend(flatten(item))
                else:
                    result.append(float(item))  # Convert to number
            return result
        
        if len(args) == 1 and isinstance(args[0], (list, tuple)):
            numbers = flatten(args[0])
        else:
            numbers = flatten(args)
        
        return sum(numbers)
    except (TypeError, ValueError) as e:
        logger.error(f"Error calculating sum: {e}")
        return 0.0


def validate_file_path(file_path: str) -> bool:
    """Validate file path with security checks"""
    import os
    from pathlib import Path
    
    try:
        if not isinstance(file_path, str):
            return False
        
        # Security: prevent path traversal
        resolved_path = Path(file_path).resolve()
        if '..' in str(resolved_path):
            logger.warning(f"Potential path traversal detected: {file_path}")
            return False
        
        return resolved_path.exists() and resolved_path.is_file() and os.access(resolved_path, os.R_OK)
    except (OSError, TypeError, ValueError):
        return False


def safe_dict_get(dictionary: Dict[str, Any], key: str, default: Any = None, validate_type: type = None) -> Any:
    """Enhanced safe dictionary access with type validation"""
    try:
        if not isinstance(dictionary, dict):
            logger.warning(f"Expected dictionary, got {type(dictionary)}")
            return default
        
        value = dictionary.get(key, default)
        
        # Optional type validation
        if validate_type is not None and value is not default:
            if not isinstance(value, validate_type):
                logger.warning(f"Expected {validate_type}, got {type(value)} for key '{key}'")
                return default
        
        return value
    except (AttributeError, TypeError) as e:
        logger.error(f"Error accessing dictionary key '{key}': {e}")
        return default