import numpy as np

Bishop = np.asarray([[1,0,0,0,0,0,0,0,0,0,0,0,0,0,1],
                     [0,1,0,0,0,0,0,0,0,0,0,0,0,1,0],
                     [0,0,1,0,0,0,0,0,0,0,0,0,1,0,0],
                     [0,0,0,1,0,0,0,0,0,0,0,1,0,0,0],
                     [0,0,0,0,1,0,0,0,0,0,1,0,0,0,0],
                     [0,0,0,0,0,1,0,0,0,1,0,0,0,0,0],
                     [0,0,0,0,0,0,1,0,1,0,0,0,0,0,0],
                     [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
                     [0,0,0,0,0,0,1,0,1,0,0,0,0,0,0],
                     [0,0,0,0,0,1,0,0,0,1,0,0,0,0,0],
                     [0,0,0,0,1,0,0,0,0,0,1,0,0,0,0],
                     [0,0,0,1,0,0,0,0,0,0,0,1,0,0,0],
                     [0,0,1,0,0,0,0,0,0,0,0,0,1,0,0],
                     [0,1,0,0,0,0,0,0,0,0,0,0,0,1,0],
                     [1,0,0,0,0,0,0,0,0,0,0,0,0,0,1]])

Rook =   np.asarray([[0,0,0,0,0,0,0,1,0,0,0,0,0,0,0],
                     [0,0,0,0,0,0,0,1,0,0,0,0,0,0,0],
                     [0,0,0,0,0,0,0,1,0,0,0,0,0,0,0],
                     [0,0,0,0,0,0,0,1,0,0,0,0,0,0,0],
                     [0,0,0,0,0,0,0,1,0,0,0,0,0,0,0],
                     [0,0,0,0,0,0,0,1,0,0,0,0,0,0,0],
                     [0,0,0,0,0,0,0,1,0,0,0,0,0,0,0],
                     [1,1,1,1,1,1,1,0,1,1,1,1,1,1,1],
                     [0,0,0,0,0,0,0,1,0,0,0,0,0,0,0],
                     [0,0,0,0,0,0,0,1,0,0,0,0,0,0,0],
                     [0,0,0,0,0,0,0,1,0,0,0,0,0,0,0],
                     [0,0,0,0,0,0,0,1,0,0,0,0,0,0,0],
                     [0,0,0,0,0,0,0,1,0,0,0,0,0,0,0],
                     [0,0,0,0,0,0,0,1,0,0,0,0,0,0,0],
                     [0,0,0,0,0,0,0,1,0,0,0,0,0,0,0]])

Queen = Bishop + Rook

class structEl():
    def __init__(self):
        self.Rk = self.setRook()
        self.Bp = self.setBishop()
        self.Qn = self.setQueen()

    def setRook(self):
        res = [[]]*64    
        for i in range(8):
            for j in range(8):
                bitar = []*64
                ar = Rook[7-i:15-i,7-j:15-j]
                for k in range(8):
                    bitar.extend(ar[k,:])
                res[i*8+j]=bitar    
        return np.asarray(res)
    
    def setBishop(self):
        res = [[]]*64    
        for i in range(8):
            for j in range(8):
                bitar = []*64
                ar = Bishop[7-i:15-i,7-j:15-j]
                for k in range(8):
                    bitar.extend(ar[k,:])
                res[i*8+j]=bitar    
        return np.asarray(res)
    
    def setQueen(self):
        res = [[]]*64    
        for i in range(8):
            for j in range(8):
                bitar = []*64
                ar = Queen[7-i:15-i,7-j:15-j]
                for k in range(8):
                    bitar.extend(ar[k,:])
                res[i*8+j]=bitar    
        return np.asarray(res)